/*
 * @(#)hprof_site.h	1.1 98/08/14
 *
 * Copyright 1997, 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

#ifndef _HPROF_SITE_H
#define _HPROF_SITE_H

/* Allocation sites */
typedef struct hprof_site_t {
    int changed;                       /* objects at this site changed? */
    int is_array;                      /* object arrays:    JVMPI_CLASS
					  primitive arrays: JVMPI_BOOLEAN, ...
					  normal objects:   0 */
    unsigned int trace_serial_num;     /* trace serial number */
    struct hprof_class_t *class;      /* NULL for primitive arrays */
    unsigned int n_alloced_instances; 
    unsigned int n_alloced_bytes;
    unsigned int n_live_instances;
    unsigned int n_live_bytes;
} hprof_site_t;

typedef struct {
    hprof_site_t **sites;
    int index;
    int changed_only;
} hprof_site_iterate_t;

void hprof_site_table_init(void);
hprof_site_t * hprof_intern_site(jobjectID class_id, 
				 int is_array, 
				 int trace_serial_num);
void hprof_output_sites(int flags, float cutoff);
void hprof_clear_site_table(void);

#endif /* _HPROF_SITE_H */

