/*
 * Decompiled with CFR 0.152.
 */
package com.sun.demos.cityim.internal;

import com.sun.demos.cityim.internal.CityInputMethod;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.font.TextHitInfo;
import java.awt.im.spi.InputMethodContext;
import java.util.Locale;

class LookupList
extends Canvas {
    CityInputMethod inputMethod;
    InputMethodContext context;
    Window lookupWindow;
    String[] candidates;
    Locale[] locales;
    int candidateCount;
    int selected;
    final int INSIDE_INSET = 4;
    final int LINE_SPACING = 18;

    LookupList(CityInputMethod cityInputMethod, InputMethodContext inputMethodContext, String[] stringArray, Locale[] localeArray, int n) {
        this.inputMethod = cityInputMethod;
        this.context = inputMethodContext;
        this.candidates = stringArray;
        this.locales = localeArray;
        this.candidateCount = n;
        this.lookupWindow = inputMethodContext.createInputMethodWindow("Lookup Window", true);
        this.setFont(new Font("Dialog", 0, 12));
        this.setSize(200, n * 18 + 8);
        this.setForeground(Color.black);
        this.setBackground(Color.white);
        this.enableEvents(8L);
        this.enableEvents(16L);
        this.lookupWindow.add(this);
        this.lookupWindow.pack();
        this.updateWindowLocation();
        ((Component)this.lookupWindow).setVisible(true);
    }

    private void updateWindowLocation() {
        Point point = new Point();
        int n = this.inputMethod.getSelectedSegmentOffset();
        Rectangle rectangle = this.context.getTextLocation(TextHitInfo.leading(n));
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.lookupWindow.getSize();
        point.x = rectangle.x + dimension2.width > dimension.width ? dimension.width - dimension2.width : rectangle.x;
        point.y = rectangle.y + rectangle.height + 2 + dimension2.height > dimension.height ? rectangle.y - 2 - dimension2.height : rectangle.y + rectangle.height + 2;
        ((Component)this.lookupWindow).setLocation(point);
    }

    void selectCandidate(int n) {
        this.selected = n;
        this.repaint();
    }

    public void paint(Graphics graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.getDescent();
        int n2 = fontMetrics.getAscent();
        int n3 = 0;
        while (n3 < this.candidateCount) {
            graphics.drawString(n3 + 1 + "   " + this.candidates[n3] + "  (" + this.locales[n3].getDisplayName() + ")", 4, 18 * (n3 + 1) + 4 - n);
            ++n3;
        }
        Dimension dimension = this.getSize();
        graphics.drawRect(2, 18 * (this.selected + 1) + 4 - (n + n2 + 1), dimension.width - 4, n + n2 + 2);
        graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
    }

    public void setVisible(boolean bl) {
        if (!bl) {
            ((Component)this.lookupWindow).setVisible(false);
            this.lookupWindow.dispose();
            this.lookupWindow = null;
        }
        super.setVisible(bl);
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        this.inputMethod.dispatchEvent(keyEvent);
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        int n;
        if (mouseEvent.getID() == 501 && (n = mouseEvent.getY()) >= 4 && n < 4 + this.candidateCount * 18) {
            this.inputMethod.selectCandidate((n - 4) / 18);
            this.inputMethod.closeLookupWindow();
        }
    }
}

