/*
 * @(#)jlong_md.h	1.7 98/09/02
 *
 * Copyright 1997, 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

#ifndef _WIN32_JLONG_MD_H_
#define _WIN32_JLONG_MD_H_

/* Make sure ptrdiff_t is defined */
#include <stddef.h>

#define jlong_high(a)	((jint)((a)>>32))
#define jlong_low(a)	((jint)(a))
#define jlong_add(a, b)	((a) + (b))
#define jlong_and(a, b)	((a) & (b))
#define jlong_div(a, b)	((a) / (b))
#define jlong_mul(a, b)	((a) * (b))
#define jlong_neg(a)	(-(a))
#define jlong_not(a)	(~(a))
#define jlong_or(a, b)	((a) | (b))
#define jlong_shl(a, n)	((a) << (n))
#define jlong_shr(a, n)	((a) >> (n))
#define jlong_sub(a, b)	((a) - (b))
#define jlong_xor(a, b)	((a) ^ (b))
#define jlong_rem(a,b)	((a) % (b))

/* comparison operators */
#define jlong_ltz(ll)	((ll) < 0)
#define jlong_gez(ll)	((ll) >= 0)
#define jlong_gtz(ll)	((ll) > 0)
#define jlong_eqz(a)	((a) == 0)
#define jlong_eq(a, b)	((a) == (b))
#define jlong_ne(a,b)	((a) != (b))
#define jlong_ge(a,b)	((a) >= (b))
#define jlong_le(a,b)	((a) <= (b))
#define jlong_lt(a,b)	((a) < (b))
#define jlong_gt(a,b)	((a) > (b))

#define jlong_zero	((jlong) 0)
#define jlong_one	((jlong) 1)
#define jlong_minus_one	((jlong) -1)

/* For static variables initialized to zero */
#define jlong_zero_init	((jlong) 0)

#define jlong_to_ptr(a) ((void*)(int)(a))
#define ptr_to_jlong(a) ((jlong)(int)(a))
#define jint_to_jlong(a)	((jlong)(a))
#define jlong_to_jint(a)	((jint)(a))

/* Useful on machines where jlong and jdouble have different endianness. */
#define jlong_to_jdouble_bits(a)
#define jdouble_to_jlong_bits(a)

#define jlong_to_int(a)     ((int)(a))
#define int_to_jlong(a)     ((jlong)(a))
#define jlong_to_uint(a)    ((unsigned int)(a))
#define uint_to_jlong(a)    ((jlong)(a))
#define jlong_to_ptrdiff(a) ((ptrdiff_t)(a))
#define ptrdiff_to_jlong(a) ((jlong)(a))
#define jlong_to_size(a)    ((size_t)(a))
#define size_to_jlong(a)    ((jlong)(a))
#define long_to_jlong(a)    ((jlong)(a))

#endif
