/* @(#)hprof_jni.h	1.1 98/08/14
 *
 * Copyright 1997, 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

#ifndef _HPROF_JNI_H
#define _HPROF_JNI_H

/* JNI global refs */
typedef struct hprof_globalref_t {
    struct hprof_globalref_t *next;    /* next global ref */
    jobject ref_id;                    /* referece ID */
    struct hprof_objmap_t *obj_id;     /* object ID */
    unsigned int trace_serial_num;     /* trace where the ref was alloced */
} hprof_globalref_t;

hprof_globalref_t * hprof_globalref_find(jobject ref_id);
void hprof_jni_globalref_alloc_event(JNIEnv *env_id, jobjectID obj_id, jobject ref_id);
void hprof_jni_globalref_free_event(JNIEnv *env_id, jobject ref_id);

#endif /* _HPROF_JNI_H */
