#include "ptoc.h"



/*$N+*/
#include "graph.h"

const integer kmin = 1;                        const real e = 1.6e-19;
                               const real el = 2.6e6;/* el=2.6e6;*/
const real emax = 2.88e-18;                 const real ener3 = 1.07e-18;

const integer nf = 18;                         const real q0 = 1e-20;
const integer nn = 144;
const integer nm = 4;
const real m1 = 1836.2;
const real me = 0.9e-30;
const real n0 = 2.6e25;

typedef array<0,180,real> mas1;
typedef array<1,4,integer> mas2;
typedef matrix<1,4,1,5,real> mas3;
typedef array<0,180,integer> mas4;
typedef matrix<1,4,1,5,array<0,180,real> > mas5;
typedef array<1,4,real> mas6;
typedef matrix<1,4,1,5,array<0,180,real> > mas7;
typedef array<1,4,varying_string<5> > stat1;
typedef array<1,4,integer> stat2;
typedef matrix<1,4,1,5,varying_string<18> > stat3;
typedef matrix<1,4,1,5,real> stat4;
typedef matrix<1,4,0,20,real> stat5;
typedef matrix<1,4,1,3,real> stat6;
typedef matrix<1,4,1,5,word> stat7;
typedef matrix<1,4,1,5,word> stat8;
const stat1 s = {{"CO2","N2","O2","H2O"}};
const stat2 nr = {{3,5,1,1}};
const stat2 gaz1 = {{100,0,0,0}};
const stat2 gaz2 = {{0,100,0,0}};
const stat2 m = {{44,28,32,18}};
const stat3 sr = {{{{"e+CO2->e+CO+O","e+CO2->2e+CO2+","e+CO2->e+CO2(W)","",""}},
           {{"e+N2->e+N+N","e+N2->e+N2+","e+N2->e+N2(A)","e+N2->e+N2(B)",
             "e+N2->e+N2(W)"}},
           {{"e+O2->e+O+O(P)","e+O2->e+O+O(D)","e+O2->e+O2+","",""}},
           {{"e+H2O->H- +OH","e+H2O->e+H2O+","","",""}}}};
const stat4 enr = {{{{5.5,13.8,0,0,0}},{{9.8,15.6,0,0,0}},
              {{6,7,12.1,0,0}},{{6,12.6,0,0,0}}}};
const stat5 fm = {{/*(0.42,0.23,0.195,0.18,0.035,0.018,0.013,0.0095,0.0066,
                   0.0044,0.0027,1.69e-3,9.79e-4,5.25e-4,2.56e-4,1.13e-4,4.57e-5,
                   1.7e-5,5.9e-6,0,0),*/
          {{0.28,0.19,0.16,0.11,0.045,0.027,0.02,0.015,0.011,0.008,5.4e-3,
           3.6e-3,2.3e-3,1.36e-3,7.5e-4,3.8e-4,1.8e-4,8.3e-5,3.54e-5,0,0}},

             /*(0.48,0.46,0.226,0.025,0.0127,0.0085,0.006,0.004,2.5e-3,
                    1.3e-3,6.8e-4,3.3e-4,1.5e-4,6.8e-5,3e-5,1.4e-5,6.4e-6,
                    3e-6,1.44e-6,0,0)  */
            /*(0.4,0.38,0.2,0.04,2.3e-2,1.6e-2,1.2e-2,8.3e-3,5.4e-3,3.3e-3,
                  1.8e-3,1e-3,5.4e-4,2.8e-4,1.5e-4,7.9e-5,4.2e-5,2.3e-5,1.3e-5,0,0),*/
         {{0.4,0.38,0.2,0.046,1.8e-2,1.4e-2,1.1e-2,8.3e-3,5.4e-3,3.3e-3,
          1.8e-3,1e-3,5.4e-4,2.8e-4,1.5e-4,7.9e-5,4.2e-5,2.3e-5,1.3e-5,0,0}},
          {{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}},
          {{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}}   }};
const stat5 vdm = {{{{14e6,14e6,14e6,14e6,14e6,14e6,14e6,14e6,14e6,14e6,
               14e6,14e6,14e6,14e6,14e6,14e6,14e6,14e6,14e6,14e6,14e6}},
              {{10e6,10e6,10e6,10e6,10e6,10e6,10e6,10e6,10e6,10e6,
               10e6,10e6,10e6,10e6,10e6,10e6,10e6,10e6,10e6,10e6,10e6}},
              {{14e6,14e6,14e6,14e6,14e6,14e6,14e6,14e6,14e6,14e6,
               14e6,14e6,14e6,14e6,14e6,14e6,14e6,14e6,14e6,14e6,14e6}},
              {{14e6,14e6,14e6,14e6,14e6,14e6,14e6,14e6,14e6,14e6,
               14e6,14e6,14e6,14e6,14e6,14e6,14e6,14e6,14e6,14e6,14e6}}}};
const stat4 yield1 = {{{{4e-1,1e-2,0,0,0}},{{5e-1,1e-2,0,0,0}},
                 {{3e-1,3e-1,6e-3,0,0}},{{1e-2,0,0,0,0}}}};
const stat6 hw = {{{{0.15*2.7e-20,0.2*1.3e-20,0.45*4.7e-20}},{{3.8e-20,0,0}},{{0,0,0}},
             {{0,0,0}}}};
const stat7 bool1 = {{{{4,2,2,2,2}},{{2,2,2,2,2}},{{1,1,1,1,1}},{{2,1,1,1,1}}}};
const stat8 bool2 = {{{{2,2,4,4,4}},{{2,2,4,4,4}},{{1,1,1,1,1}},{{1,1,2,2,1}}}};
integer k,i,j;
integer mmax,ci;
mas1 df,dv,v;
mas1 evvb,velec;
mas1 dfm1,dfm2;
mas2 mixt1,mixt;
mas3 ki,yield2;
mas4 xgr,ygr;
mas5 qcol;
mas6 d;
mas7 qreac;
real fmax,yn1,vd;
real mean,de,de1;
string s1,s2,s3,s4;
/*--------------------------------------------------------------------*/
void start()
{
    integer i,j ,k;
    text f;
    real g;

  assign(f,"q2.txt");
  reset(f);
  for( i=1; i <= nm; i ++)
    {
      for( j=1; j <= 5; j ++)
        {
          for( k=0; k <= (nn / 2); k ++)
            {
              f >> g;
              qcol[i][j][k]=g;
            }
        }
    }
  for( i=1; i <= nm; i ++)
    {
      for( j=1; j <= nr[i]; j ++)
        {
          for( k=0; k <= (nn / 2); k ++)
            {
              f >> g;
              qreac[i][j][k]=g;
            }
        }
    }
  close(f);
  de=(real)(nf)/nn*e;
  de1=(real)(nf)/nn;
}  /*start*/
/*---------------------------------------------------------------------*/
void delta(stat2 mm1, mas6& d2 )
{
    integer i;
    real dl;

  for( i=1; i <= nm; i ++)
    d2[i]=2/(mm1[i]*m1);
}  /*delta*/
/*---------------------------------------------------------------------*/
real fr(integer mxt , real q1, real en1 )
{
  real fr_result;
  fr_result=q1*q0*sqrt(2*en1/me)*n0*mxt/100;
  return fr_result;
}  /*frec*/
/*-----------2-----------------------------------------------------------*/
void interpol( word mask, mas1 f1 , mas1& f2)
{
    mas1 aa,bb,fp,d1,b1,c1;
    integer c,i,mk,nk1;
    real h,dh;

  switch (mask) {
     case 4:   mk=2; break;
     case 2:   mk=4; break;
     case 1:   mk=8; break;
  }
  nk1=nn / mk;
  h=(real)(nf)/nk1;
  c=-4;
  for( i=1; i <= nk1; i ++)
    fp[i]=-6*(f1[i+1]+f1[i-1]-2*f1[i])/(h*h);
  aa[1]=0;
  bb[1]=0;
  for( i=1; i <= nk1-1; i ++)
    {
      aa[i+1]=1/(c-aa[i]);
      bb[i+1]=(bb[i]+fp[i])/(c-aa[i]);
    }
  c1[0]=0;
  c1[nk1]=0;
  for( i=nk1-1; i >= 1; i --)
    c1[i]=aa[i+1]*c1[i+1]+bb[i+1];
   for( i=1; i <= nk1; i ++)
     {
       d1[i]=(c1[i]-c1[i-1])/h;
       b1[i]=h*c1[i]/2-h*h*d1[i]/6+(f1[i]-f1[i-1])/h;
     }

   for( i=0; i <= nk1-1; i ++)
      {
         for( j=0; j <= mk-1; j ++)
           {
              dh=h*((real)(j)/mk-1);
              f2[mk*i+j]=f1[i+1]+b1[i+1]*dh+c1[i+1]*sqr(dh)/2+
                          d1[i+1]*dh*sqr(dh)/6;
           }
      }
   f2[mk*nk1]=f1[nk1];
}  /*interpol*/
/*-------------------------------------------------------------------*/
void interpolq()
{
     mas1 q1,q2;
     integer i,j,k,nn2;

   for( i=1; i <= nm; i ++)
     {
       for( j=1; j <= nr[i]; j ++)
         {
              for( k=0; k <= (nn / 2); k ++) q1[k]=qreac[i][j][k];
              interpol(bool1[i][j],q1,q2);
              for( k=0; k <= nn; k ++) qreac[i][j][k]=q2[k];
         }
     }
   for( i=1; i <= nm; i ++)
     {
       for( j=1; j <= 5; j ++)
         {
              for( k=0; k <= (nn / 2); k ++) q1[k]=qcol[i][j][k];
              interpol(bool2[i][j],q1,q2);
              for( k=0; k <= nn; k ++) qcol[i][j][k]=q2[k];
         }
     }
}  /*interpolq*/
/*----------------------------------------------------------------------*/
void interpolf()
{
    mas1 fq1,fq2;
    integer k,nf1;

  for( k=0; k <= nf; k ++) fq1[k]=fm[1][k];
  interpol(1,fq1,dfm1);
  for( k=0; k <= nf; k ++) fq1[k]=fm[2][k];
  interpol(1,fq1,dfm2);
}  /*interpolf*/
/*-----------------------------------------------------------------------*/
void vdr(mas2 mixt , real ener , real& vdn)
{
    integer i;

  k=round(ener/de);
  for( i=1; i <= nm; i ++)
     vdn=vdn+mixt[i]/(100*vdm[i][k]);
  vdn=1/vdn;
}  /*vd*/
/*---------------------------------------------------------------------*/
void init()
{
     integer gm,gd,error;
     integer maxx,maxy,j;

  gd=detect;
  initgraph(gd,gm,"D:\\BP\\bgi");
  error=graphresult();
  if (error!=grok) 
      {
        output << grapherrormsg(error) << NL;
        input >> NL;
        exit(0);
      }
  cleardevice();
}  /*init*/
/*------------------------------------------------------------------*/
void print()
{
     integer maxx,maxy,j,r,f,count;
     real lgki;

  cleardevice();
  setcolor(red);
  setbkcolor(green);
  count=0;
  s1=" Initial Yield ( per 100 eV )";
  outtextxy(180,50,s1);
  maxx=getmaxx();
  maxy=getmaxy();
  setcolor(blue);
  s1="Mixture  :";
  for( i=1; i <= 4; i ++)
    {
      str(mixt[i],s2);
      s4=s4+s[i]+'='+s2+"%   ";
    }
  outtextxy(150,80,s1+s4);
  outtextxy(50,100,"Reaction             Yield             K                 Lg(K)");
  for( i=1; i <= nm; i ++)
    {
         for( j=1; j <= nr[i]; j ++)
        {
          str(yield2[i][j] , 13 ,s2);
          outtextxy(200,120+(count)*12,s2);
          str((ki[i][j]*1e6) , 13 ,s2);
          outtextxy(350,120+(count)*12,s2);
          if (ki[i][j]!=0) 
            {
              lgki=log(ki[i][j]*1e6)/log(10);
              str(lgki ,11,s1);
            }
                 else
              s1="   -----";
          s3=sr[i][j];
          outtextxy(50,120+(count)*12,s3);
          outtextxy(500,120+(count)*12,s1);
          count=count+1;
        }
    }
    readkey();
  do {; } while (!keypressed());
}  /*print*/
/*---------------------------------------------------------------------*/
void drawf()
{
    integer maxx,maxy,j,r,f;
    integer minflg;
    real minf,fmin;

  cleardevice();
  setcolor(red);
  setbkcolor(green);
  setlinestyle(solidln,0xaaa,normwidth);
  maxx=getmaxx();
  maxy=getmaxy();
  line(50,maxy-50,maxx,maxy-50);
  line(50,maxy-50,50,0);
  fmin=1;
  for( k=0; k <= nn; k ++)
    if (df[k]<fmin)  fmin=df[k];
   minf=1;
  do {
    minf=minf/10;
   } while (!(fmin>minf));
    for( k=0; k <= nn; k ++)
    {
      yn1=1-log(df[k])/log(minf);
      xgr[k]=round((real)((maxx-50))/(nn)*k)+50;
      ygr[k]=-round((maxy-50)*yn1)+maxy-50;
    }
   for( k=0; k <= nn; k ++)
    if (k % 4 == 0) 
      line(xgr[k],maxy-42,xgr[k],maxy-58);
  minflg=round(log(minf)/log(10));
  for( j=0; j >= minflg; j --)
    line(42,round(abs((real)((maxy-50)*j)/minflg)),58,round(abs((real)((maxy-50)*j)/minflg)));
  setlinestyle(dottedln,0xaaa,normwidth);
  for( j=1; j >= minflg; j --)
    line(58,round(abs((real)((maxy-50)*j)/minflg)),maxx,round(abs((real)((maxy-50)*j)/minflg)));
  setcolor(blue);
  setlinestyle(solidln,0xaaa,thickwidth);
  for( k=0; k <= nn-1; k ++)
    line(xgr[k],ygr[k],xgr[k+1],ygr[k+1]);
    s1=" Lg[f(e)] ";
  outtextxy(60,10,s1);
  for( j=0; j >= minflg; j --)
    {
      str(j,s2);
      outtextxy(10,round(abs((real)((maxy-50)*j)/minflg)),s2);
    }
  str(nf,s1);
     outtextxy(maxx-50,maxy-30,s1);
 for( i=1; i <= 2; i ++)
   {
     for( k=0; k <= nn; k ++)
      {
        if (i==1)  yn1=1-log(dfm1[k])/log(minf);
          else yn1=1-log(dfm2[k])/log(minf);
        xgr[k]=round((real)((maxx-50))/(nn)*k)+50;
        ygr[k]=-round((maxy-50)*yn1)+maxy-50;
      }
    if (i==1)  setcolor(6); else setcolor(11);
    for( k=0; k <= nn-1; k ++)
      line(xgr[k],ygr[k],xgr[k+1],ygr[k+1]);
      str(mixt[i],s2);
      s1=s[i]+" = "+s2;
      outtextxy(maxx-100,maxy-300+15*(i-1),s1);
   }
   do {; } while (!keypressed());
   readkey();
}  /*drawf*/
/*---------------------------------------------------------------------*/
void drawq()
{
    integer maxx,maxy,j,r,f,i;
    real minf,qmax,qm;

setbkcolor(green);
setcolor(red);
for( j=1; j <= 5; j ++)
 {
  cleardevice();
  setlinestyle(solidln,0xaaa,normwidth);
  maxx=getmaxx();
  maxy=getmaxy();
  qmax=0;
  line(50,maxy-50,maxx,maxy-50);
  line(50,maxy-50,50,0);
  for( i=1; i <= nm; i ++)
    for( k=0; k <= nn; k ++)
      if (qcol[i][j][k]>qmax)  qmax=qcol[i][j][k];
  for( k=0; k <= nn; k ++)
    if (k % 4 == 0) 
      line(xgr[k],maxy-42,xgr[k],maxy-58);
  for( k=0; k <= 10; k ++)
    line(42,round((real)((maxy-50)*k)/10),58,round((real)((maxy-50)*k)/10));
  setlinestyle(dottedln,0xaaa,normwidth);
  for( k=1; k <= 10; k ++)
    line(58,round((real)((maxy-50)*k)/10),maxx,round((real)((maxy-50)*k)/10));
  for( i=1; i <= nm; i ++)
    {
      switch (i) {
        case 1:  setcolor(blue); break;
        case 2:  setcolor(red); break;
        case 3:  setcolor(green); break;
        case 4:  setcolor(yellow); break;
      }
      setlinestyle(solidln,0xaaa,thickwidth);
        for( k=0; k <= nn; k ++)
          {
            yn1=qcol[i][j][k]/(round(qmax)+1);
            xgr[k]=round((real)((maxx-50))/(nn)*k)+50;
            ygr[k]=-round((maxy-50)*yn1)+maxy-50;
          }
      for( k=0; k <= nn-1; k ++)
        line(xgr[k],ygr[k],xgr[k+1],ygr[k+1]);
      outtextxy(300+100*(i-1),10,s[i]);
    }
  s1=" Q(e)= ";
  qm=q0*(round(qmax)+1);
  str(qm ,12, s2);
  s1=s1+s2;
  setcolor(blue);
  outtextxy(10,10,s1);
  switch (j) {
   case 1 : outtextxy(maxx-150,maxy-30,"Elastic"); break;
   case 2 : outtextxy(maxx-150,maxy-30,"Electronic"); break;
   default:  outtextxy(maxx-150,maxy-30,"Vibrational");
  }
  str(nf,s1);
  outtextxy(maxx-50,maxy-30,s1);
  do {; } while (!keypressed());
  readkey();
 }
}  /*drawq*/
/*---------------------------------------------------------------------*/
void frec(mas2 mixt2 )
{
    integer i,j;
    mas6 del;
    real ener;

for( j=0; j <= nn; j ++)
 {
    ener=j*de;
    delta(m,del);
    dv[j]=0;
    v[j]=0;
    evvb[j]=0;
    velec[j]=0;
    for( i=1; i <= nm; i ++)
      {
        dv[j]=dv[j]+del[i]*fr(mixt2[i],qcol[i][1][j],ener);
        v[j]=v[j]+fr(mixt2[i],qcol[i][1][j],ener);
        for( k=1; k <= 3; k ++)
           evvb[j]=evvb[j]+hw[i][k]*fr(mixt2[i],qcol[i][2+k][j],ener);
        velec[j]=velec[j]+fr(mixt2[i],qcol[i][2][j],ener);
      }
 }
}  /*frec*/
/*---------------------------------------------------------------------*/
void distr()
{
    integer i,n1;
    double con,c0,c1,c4;
    real int_;

  frec(mixt);
  con=3*me/(2*e*e*el*el);
  n1=round(ener3/de);
  df[0]=1;
  int_=0;
  for( i=1; i <= n1; i ++)
    {
      int_=int_+de*con*dv[i]*v[i]*(1+evvb[i]/(i*de*dv[i]));
      df[i]=exp(-int_);
    }
      int_=0;
  for( i=n1+1; i <= nn; i ++)
    {
      int_=int_+de*sqrt(con*v[i]*velec[i]/(de*i));
      df[i]=exp(-int_);
       }
      c4=df[n1]*(dv[n1]*v[n1]*(1+evvb[n1]/(n1*de*dv[n1]))*con/
     sqrt(con*v[n1]*velec[n1]/(de*n1)));
  c1=-df[n1]+c4;
  for( i=0; i <= n1; i ++)
    df[i]=(df[i]+c1);
  for( i=n1+1; i <= nn; i ++)
    df[i]=c4*df[i];
    c0=0;
  for( i=1; i <= nn; i ++)
    c0=c0+de1*(df[i]*sqrt(i*de1)+df[i-1]*sqrt((i-1)*de1))/2;
  c0=1/c0;
  for( i=0; i <= nn; i ++)
    df[i]=c0*df[i];
}  /*distr*/
/*-----------------------------------------------------------------------*/
void meanener(real& en1)
{
    integer i;

  en1=0;
  for( i=1; i <= nn; i ++)
    en1= en1+de*(df[i]*i*de*sqrt(i*de)+df[i-1]*(i-1)*de*sqrt((i-1)*de))/2;
}  /*meanener*/
void yield()
{
  meanener(mean);
  vdr(mixt,mean,vd);
  for( i=1; i <= nm; i ++)
    {
      for( j=1; j <= nr[i]; j ++)
        {
          ki[i][j]=0;
          for( k=1; k <= nn; k ++)
           ki[i][j]= ki[i][j]+de1*q0*(df[k]*qreac[i][j][k]*sqrt(2*k*de/me)*
           sqrt(k*de1)+
           df[k-1]*qreac[i][j][k-1]*sqrt(2*(k-1)*de/me)*sqrt((k-1)*de1))/2;
          yield2[i][j]=mixt[i]*ki[i][j]*n0/(el*(vd/100));
        }
    }
}  /*yield*/
/*----------------------------------------------------------------------*/
void qhelp()
{
    double con,c4,v1;
    integer i,k,n1;

  con=2*e*e*el*el/(3*me);
  n1=round(ener3/de);
  c4=fm[i][n1];
  for( k=n1+1; k <= nn; k ++)
    {
        v1=fr(100,qcol[1][1][k],k*de);
        qcol[1][3][k]=con*sqr(dfm1[k]-dfm1[k-1])/(de*de*c4*v1*n0*
        sqrt(2*de*k/me));
        v1=fr(100,qcol[2][1][k],k*de);
        qcol[2][3][k]=con*sqr(dfm2[k]-dfm2[k-1])/(de*de*c4*v1*n0*
        sqrt(2*de*k/me));
    }
}  /*qhelp*/
/*----------------------------------------------------------------------*/
void inputm()
{
    integer i;

  output << " Input new mixture =>" << NL;
  for( i=1; i <= nm; i ++)
    {
      output << s[i] << NL;
      input >> mixt[i];
    }
}  /*inputm*/
/*-----------------------------------------------------------------------*/
/*procedure pr;
var i,j : integer;
begin
  for i=0 to nk do
    begin
      writeln('N[',i,']=',n[i]:12);
      i:=i+1;
      if i-j>40  then
                  begin
                    j:=i;
                    readln;
                  end;
    end;
  readln;
end;*/
/*----------------------------------------------------------------------*/

int main(int argc, const char* argv[])
{
  pio_initialize(argc, argv);
  mixt1[1]=15; mixt1[2]=70; mixt1[3]=5; mixt1[4]=10;
  /*---------------------------------------------------*/
  start();
  inputm();
  interpolq();
  interpolf();
  /*qhelp;*/
  init();
  drawq();
  distr();
  drawf();
  yield();
  print();
  closegraph();
  return EXIT_SUCCESS;
}
