	Subroutine Runprogram(*,cmd,trace)
	    character*(*) cmd
	    Logical trace	! .true. if TRACE mode
CCCCCC================== (G[=start] [break1 [break2] ...]) 
	Include 'mach.fh'
C***-&...1abcde....2abcde....3abcde....4abcde....5abcde....6abcde....7ab---.....
	Integer*2 nbreak,breakp(9)	! for break points	
	Integer ntmp,n2,kpbreak
	Integer*2 NIP, IR
	Integer*4 Limitdo, InstCNT	! for TRACE mode
C***--==== Functions used
	Integer Str$Find_First_Not_In_Set
c	Integer Str$Find_First_In_Set
CCCCC=---1abcde=---2abcde=---3abcde=---4abcde=---5abcde=---6abcde=---7ab...=---
D	PRint*,'===Run the program in memory'
	InstCNT=0	! for trace mode only, to count how many inst executed
	Limitdo=1	! do one inst at least
	nbreak=0	! assume no break point
c-----------re-Tokenize the command line
D	PRint*,'Runprog---> cmd=',cmd
	ntmp=Str$Find_First_Not_In_Set(cmd(2:),' '//char(9))
	if(ntmp.ne.0) then	!some msg on the cmd line
	    ntmp=ntmp+1	! absolute position
	    n2=ntmp
	    if(cmd(ntmp:ntmp).eq.'=')n2=n2+1	! skip the char "="
	    Call Tokenize(cmd(n2:),' '//char(9),.false.)  !..and parse it again
D	do kk=1,narg
D	 PRint*,'**Runprogram-->',kk,') ',argv(kk), arglenv(kk)
D	enddo
	    if(narg.le.0)goto 888	! error
	    kpbreak=0	
	    if(cmd(ntmp:ntmp).eq.'=')then	! g=star_addr
		read(argv(1)(:arglenv(1)),*,err=888)NIP
		if(NIP.lt.0.or.NIP.gt.MEMSIZE) goto 888	!error
		cpu.IP=NIP	! set the IP
		kpbreak=kpbreak+1	! next arg is the first break pnt
	    endif
C----then, see if he wants to break sometime?
	    do while(kpbreak.lt.narg)	! see any break point?
		kpbreak=kpbreak+1	! next
		read(argv(kpbreak)(:arglenv(kpbreak)),*,err=888)NIP
		nbreak=nbreak+1
		breakp(nbreak)=NIP
		if(trace)then
			Limitdo=NIP  ! In TRACE mode, this is the count
			nbreak=0
			Goto 234     ! and ignore the remaining chars
		endif
	    enddo	! while(...
	endif  !(ntmp.ne.0)
 234	Continue	! used by TRACE mode
D	PRint*,'Runprog-> nbreak,InstCNT,Limitdo=',nbreak,InstCNT,Limitdo
	if(Limitdo.le.0)Limitdo=1
c------all right, now we are ready to go
	Do While(.TRUE.)	! loop until halt
	    ! check if IP out of range
	    if(cpu.IP .ge. MEMSIZE) then
		Print*,' MAGIC halted due to IP > ',MEMSIZE-1
		cpu.IP=0	! reset IP
		Return		! and done
	    endif
	     ! also check if we reach a break point
	    do k=1,nbreak
		if(breakp(k).eq.cpu.IP)then	! yeah, take a break
		    Print110,'Break at IP=',cpu.IP, cpu.IP
 110		    format(1x,a,su,16r,'0x',I3.3,' =',s,r,I5)
		    Return
		endif
	    end do 	! k=1,nbreak
	!! Fetch the Instruction
	    IR=mem(cpu.IP)
	    cpu.IP=cpu.IP+1	! point to next Instruction
	!!! execute this instruction
	    Call execute(*999,IR)	! and goto 999 if it's "HALT"
	    if(trace)then
		Call Showstatus
		! in trace mode, check do count
		InstCNT=InstCNT+1		! count only in TRACE mode
		if(InstCNT.ge.Limitdo)Return
	    endif
	endDo  ! While
 999	Continue
	Return
 888	Return 1	! Error Return	(cmd line error)
	End

	Logical Function IsLT()
	    Logical IsGT, IsEQ
	Include 'mach.fh'
CCCCCCCCC.CCCCCCCCC.CCCCCCCCC.
	IsLT= and(cpu.FLAG,CondCode).eq.F_LessThan
	Return

	Entry IsGT()
	IsLT= and(cpu.FLAG,CondCode).eq.F_GreaterThan
	Return

	Entry IsEQ()
	IsLT= and(cpu.FLAG,CondCode).eq.F_EQualto
	Return
	End

	Subroutine Execute(*,IR)
	    integer*2 IR
ccc--------IR is the Instruction Register
	Include 'mach.fh'
C***-&...1abcde....2abcde....3abcde....4abcde....5abcde....6abcde....7ab---.....
	Integer*2 OPCODE,ADDR,Temp1,Temp2
	Integer*2 cheoln, thischar, nbyte
	Parameter (cheoln=x"24")		! "$"
	Character*80	Tempstr
C***--==== Functions used
	Logical IsLT, IsGT, IsEQ	! functions
CCCCC=---1abcde=---2abcde=---3abcde=---4abcde=---5abcde=---6abcde=---7ab...=---
	OPCODE= and(rshift(IR,12),x"000f")	! see "manf bit"
	ADDR= and(IR,x"0fff")
	Goto (1000,1010,1020,1030,1040,1050,1060,1070,1080,1090,
     &	      1100,1110,1120,1130,1140,1150), OPCODE+1
	Print*,' This is IMPOSSIBLE ! PLS call me at (035)712121-3781'
	Call Exit(0)	! stop
 1000	Continue	! NOP
	Return
 1010	Continue	! LDA
	cpu.ACC=mem(ADDR)
	Return
 1020	Continue	! STA
	mem(ADDR)=cpu.ACC
	Return
 1030	Continue	! ADD
	cpu.ACC= cpu.ACC+mem(ADDR)
	Goto 1085	! affect the FLAG
 1040	Continue	! SUB
	cpu.ACC= cpu.ACC-mem(ADDR)
	Goto 1085	! affect the FLAG
 1050	Continue	! MUL
	cpu.ACC= cpu.ACC*mem(ADDR)
	Goto 1085	! affect the FLAG
 1060	Continue	! DIV
	cpu.ACC= int(cpu.ACC/mem(ADDR))
	Goto 1085	! affect the FLAG
 1070	Continue	! MOD, the remainder has the same SIGN as dividend
	cpu.ACC= mod(cpu.ACC,mem(ADDR))
	Goto 1085	! affect the FLAG
 1080	Continue	! CMP
	Temp2=mem(ADDR)		! the value to compare
	Goto 1087
 1085	Continue	! except CMP instruction
	Temp2=0		! AC compares with 0
 1087	Continue
	Temp1=cpu.ACC
 1089	Continue
	if(Temp1 .gt. Temp2)then
		cpu.FLAG=F_GreaterThan
	else if(Temp1 .eq. Temp2)then
		cpu.FLAG=F_EQualto
	else if(Temp1 .lt. Temp2)then
		cpu.FLAG=F_LessThan
	else 	! impossible
	endif
	Return
 1090	Continue	! JMP
	cpu.IP=ADDR
	Return
 1100	Continue	! JLT
	if(IsLT()) cpu.IP=ADDR
	Return
 1110	Continue	! JEQ
	if(IsEQ()) cpu.IP=ADDR
	Return
 1120	Continue	! JGT
	if(IsGT()) cpu.IP=ADDR
	Return
 1130	Continue	! IN
	Print 132,'? '
  132	format(1x,a,$)
	read(*,*,err=138,end=3810)Temp2
	mem(ADDR)=Temp2
	Return
  138	continue
	Print132,' Error! Type a value '
	Goto 1130
 1140	Continue	! OUT
	Print*,mem(ADDR)
	Return
 1150	Continue	! alternative set of OP
	OPCODE= and(rshift(IR,8),x"000f")
	ADDR= and(ADDR,x"00ff")
	goto(2000,2010,2020,2030,2040,2050,2060,2070,2080,
     &	     2090,2100,2110,2120,2130,2140,2150),OPCODE+1
	Return	! ignore unknown OPcode
 2000	continue	! CLA
	cpu.ACC=0
	Return
 2010	continue	! INS (INput String)
	kaddr=ADDR
	Print 132,'?? '
	read(*,'(a)',end=3820)Tempstr
	Lenk=index(Tempstr,'$')
	if(Lenk.eq.0)Lenk=Str$Actual_Length(Tempstr)
	if(and(Lenk,1).eq.1) Lenk=Lenk+1	! odd to even
	k1=1
	Do while(k1.lt.Lenk)
	    ch1=Tempstr(k1:k1)
	    ch2=Tempstr(k1+1:k1+1)
	    mem(kaddr)=and(x"ffff",ichar(ch2)*256+ichar(ch1))
	    k1=k1+2	! to next word
	    kaddr=kaddr+1
	    if(kaddr.lt.0 .or.kaddr.ge.MEMSIZE)kaddr=0
	endDo
	Return
 2020	continue	! OUTS (OUTput String)
	kaddr=ADDR
	Lenout=0
	Tempstr=' '
c-------------get the string till a "$" or longer than 72 chars
	Temp2=mem(kaddr)
	nbyte=0
	thischar=and(Temp2,x"00ff")
	Do while(Lenout.LT.72.and.thischar.ne.cheoln)
	    Lenout=Lenout+1
	    Tempstr(Lenout:Lenout)=CHAR(thischar)
	    nbyte=nbyte+1	! current we have only Byte1, Byte0
	    Temp2=rshift(Temp2,8)	! next Byte
	    thischar=and(Temp2,x"00ff")
	    if(nbyte.ge.2)then	! over a word, should be corrected
		if(kaddr.lt.MEMSIZE)then
		  kaddr=kaddr+1	! next word
		  Temp2=mem(kaddr)
		  nbyte=0	! Byte 0
	    	  thischar=and(Temp2,x"00ff")
		else	! out of memory
	    	  thischar=cheoln
		endif
	    endif
	endDo
	if(Lenout.gt.0)Print 223,Tempstr(1:Lenout)
  223	format(1x,a,$)
	Return
 2030	continue	! INC addr
	mem(ADDR)=mem(ADDR)+1
	Temp1=mem(ADDR)
	Temp2=0
	Goto 1089	! affect the FLAG
 2040	continue	! DEC addr
	mem(ADDR)=mem(ADDR)-1
	Temp1=mem(ADDR)
	Temp2=0
	Goto 1089	! affect the FLAG
 2050	continue	! INCA 
	cpu.ACC=cpu.ACC+1
	Goto 1085	! affect the FLAG
 2060	continue	! DECA
	cpu.ACC=cpu.ACC-1
	Goto 1085	! affect the FLAG
 2070	continue	! MA2X 
	cpu.X=cpu.ACC
	Return
 2080	continue	! MX2A
	cpu.ACC=cpu.X
	Return
 2090	continue	! LDAI const 
	cpu.ACC=ADDR
	Return
 2100	continue	! LDAX offset
	kaddr=ADDR+cpu.X
	if(kaddr.lt.0.or.kaddr.ge.MEMSIZE)then
		Print*,' ? LDAX ',kaddr, '???'
	else
		cpu.ACC=mem(kaddr)
	endif
	Return
 2110	continue	! STAX offset
	kaddr=ADDR+cpu.X
	if(kaddr.lt.0.or.kaddr.ge.MEMSIZE)then
		Print*,' ? STAX ',kaddr, '???'
	else
		mem(kaddr)=cpu.ACC
	endif
	Return
 2120	continue	! INCX 
	cpu.X=cpu.X+1
	Temp1=cpu.X
	Temp2=0
	Goto 1089	! affect the FLAG
 2130	continue	! DECX
	cpu.X=cpu.X-1
	Temp1=cpu.X
	Temp2=0
	Goto 1089	! affect the FLAG
 2140	continue	! CLX
	cpu.X=0
	Return
 2150	continue	! HALT 
	cpu.IP=cpu.IP-1	! show correct IP
	Return 1	! tell him we execute "HALT"
3810	continue	! when EOF encounted
	Print*,' ? EOF encounted when Reading a number'
	Return
3820	continue	! when EOF encounted
	Print*,' ? EOF encounted when Reading a string'
	Return
	End
