//sortVec2.cpp  ---  @copyLeft by tsaiwn@csie.nctu.edu.tw
// sorting  example using <algorithm>  with/without comparator
//can ONLY handle vector of int in this example
#include <iostream>
#include <algorithm>
#include <vector>
using namespace std;

bool compare (int i,int j) { cout << " ha "; return (i<j); }

//the following defines a Comparator class "Sorter"
typedef struct {  // note the following function in this class
  bool operator() (int i,int j) { cout << " S "; return (i<j);}
} Sorter;
Sorter myObject;

void printV(vector<int> aVector) {
  vector<int>::iterator it;
  // print out content:
  for (it=aVector.begin(); it != aVector.end(); ++it)
     cout << " " << *it;
  cout << endl;
}// printV(

int main () {
  int myints[] = {32,71,12,45,26,80,53,33};
  vector<int> myvector (myints, myints+sizeof myints/sizeof myints[0]);
  cout << "Vector contains:";
  printV(myvector);

  // using default comparison (operator <):  //(12 32 45 71)26 80 53 33
  sort (myvector.begin(), myvector.begin()+4);   // first 4 elements
  cout << "After sort:";
  printV(myvector);

  // using function as comp     // 12 32 45 71(26 33 53 80)  part
  sort (myvector.begin()+4, myvector.end(), compare);
  cout << "\nSort 4-th till end with compare:";
  printV(myvector);

  // using object as comp     // all (12 26 32 33 45 53 71 80)
  sort (myvector.begin(), myvector.end(), myObject);
  cout << "\nSort ALL with Comparator myObject:";
  printV(myvector);

  return 0;
}//main(
/**********       *****   `N running Results, why "ha"? why "S"?
C:\testc\STL>g++ sortVec2.cpp

C:\testc\STL>a
Vector contains: 32 71 12 45 26 80 53 33
After sort: 12 32 45 71 26 80 53 33
 ha  ha  ha  ha  ha  ha  ha  ha  ha
Sort 4-th till end with compare: 12 32 45 71 26 33 53 80
 S  S  S  S  S  S  S  S  S  S  S  S  S  S  S  S  S  S  S  S
Sort ALL with Comparator myObject: 12 26 32 33 45 53 71 80
*****************************************************************/
