//gHanoi2.java -- Graphics Hanoi, by tsaiwn@cs.nctu.edu.tw
//javac gHanoi2.java
//java gHanoi2
///in HTML file,
//    <APPLET code="gHanoi2.class" width=500 height=500>
///
import java.io.*;
import java.applet.*;
import java.awt.*;
import java.awt.event.*;

public class gHanoi2 extends Applet {
  static Frame f;
  static boolean isApplet = true;
  //Panel myPanel;
  public static final int delayTime = 8; // 8/1000 second
  public static final int MOVE_STEP = 33; // 33 points
  public static final int X_SIZE=500, Y_SIZE=500;
  public static final int Y_TOP = 38;
  public static final Color haColor = Color.red;
  int kkk=0;  // used in paint(
  ///
  int nDisks = 0;
  int nPeg[ ] = new int[3];
  int xPosition[ ] = new int[3];  // central position of 3 pegs
  int aX=38, aY= (Y_SIZE - 50);
  int bX=(aX+(X_SIZE-50)/3), bY=aY;
  int cX=(bX+(X_SIZE-50)/3), cY=aY;

  int thick=22; // for disk thick
  int width=33; // for disk width
  int wUnit=2;  // 128/nDisks == 2

  Graphics bufferGraphics=null;  // ΨӵebO骺  
  Image img=null;  // The image that will contain everything that ..
              /// .. has been drawn on bufferGraphics.
              /// .. will be used in paint( ) 
  Dimension dim=null;   // To get the width and height of the applet. 

  PrintStream cout=null;
  BufferedReader br = null;

   public static void main(String xxx[ ]) {
      isApplet = false;   // is Java Application
      f = new Frame("Tower of Hanoi");
      gHanoi2 g2 = new gHanoi2( );
      f.add("Center", g2);
      f.setSize(X_SIZE, Y_SIZE);  // 500,500
      f.setVisible(true);  // f.show( );
      g2.init( );
      g2.start( );
      f.setVisible(false);  // f.show( );
      g2.main( );   // call the " int main( )" from C 
   }//main(

   public void init( ) {
      prepareIO( );
      //setLayout(new BorderLayout());
      //myPanel = new Panel( );
      //add("Center", myPanel);
      ///
      repaint( ); // force to initilize img
   }//init(

   public void start( ) {
      repaint( );
      if(isApplet) {  // from Applet ?
         int n = 5;
         haInit(n);
         validate( );
         setVisible(true);
         repaint( );
         clearTower( );
         hanoi(n, 'A', 'C', 'B'); // disks on peg 'A' to peg 'C'
      }
   }//start(

   public gHanoi2( ) {
   }
   void prepareIO( ){
      try{
         cout = System.out;
         br = new BufferedReader(
               new InputStreamReader(System.in) );
      }catch(Exception e) { System.exit(38); }
   }

// hanoi.c  -- Hanoi tower, @CopyLeft by tsaiwn@csie.nctu.edu.tw
//Hanoi Tower(e) -- _ Recursive -- ۤvsۤv !
// Hanoi Tower, Х http://gogle.com J "hanoi tower"  d
//`N޸p "hanoi tower" d쪺~OAn :-)
//άOݳo  http://en.wikipedia.org/wiki/Tower_of_Hanoi
///
//void moveOne(int px, int py, int ); //3rd parameter is the disk#
void hanoi(int n, int pa, int pc, int pb) {
    if(n==0) return;    // there is no disk
    hanoi(n-1, pa, pb, pc);  // ڧW n-1 disks h
    moveOne(pa, pc, n);   /// move the n-th disk from pa to pc
    hanoi(n-1, pb, pc, pa); // move n-1 disks from pb to pc
} // hanoi

//#include <stdio.h>
void moveOne(int px, int py, int n ) {  // the n-th disk
   moveG(px, py, n);
   String p123[ ] = {"th", "st", "nd", "rd"}; // -th, Fir-st, Seco-nd, -rd
   int k = n%10;
   if(k!=1  && k!=2 && k!=3) k = 0;  // -th
   cout.printf("Move %d-%s disk from %c  to  %c \n", n,p123[k], px, py);
}

int getInt( ) {   // static char buf[99];
   String buf = null;
   int ans=0;
   // fgets(buf, sizeof(buf), stdin); ans=atoi(buf);
   try {
      buf = br.readLine( );
      ans = Integer.parseInt(buf);
   }catch(Exception e) { ans = 3; }
    // pG ans = 3; אּ ans = 64; A{|h[? ? ?
   return ans;  //Y@uh@Ӱʧ@, hݬ 600 billion(d) years
}
void haInit(int n) {
    nDisks = n;
    nPeg[0] = n; // initially all Disks on Peg-0
    nPeg[1] = nPeg[2] = 0;
    thick = (Y_SIZE -50)/n;
    if(thick > 20) thick = 20; // disk thick
    wUnit = 128/nDisks;
    if(wUnit < 2) wUnit=2;
    xPosition[0] = aX + 64;
    xPosition[1] = bX + 64;
    xPosition[2] = cX + 64;
    //
    clearTower( );
    if(f!=null) {
       f.setVisible(true);  // f.show( );
       f.validate( );
       f.requestFocus( );
    }
    repaint( ); 
    clearTower( ); 
    initDisks( );  // draw the initial Disks
    if(f!=null) f.setVisible(true);  // f.show( );
}
int main( ) {   // original main of the C program
    int n; 
    while(true) {
       cout.print(" n=? ");
       n = getInt( );  // read an int into n
       if(n<=0) break;
       haInit(n);
       hanoi(n, 'A', 'C', 'B'); // move n disks on peg 'A' to peg 'C'
    }
    f.dispose( );
    return 0;
}
//////////////////////////
  void clearTower( ){
     if(dim==null) return;  // not ready yet
     setBackground(Color.gray);
     bufferGraphics.clearRect(0,0,dim.width,dim.height);
     bufferGraphics.setColor(Color.pink); 
     bufferGraphics.fillRect(aX, aY, 128, 18); 
     bufferGraphics.fillRect(bX, bY, 128, 18);
     bufferGraphics.fillRect(cX, cY, 128, 18);
     bufferGraphics.setColor(haColor); 
     try{ Thread.sleep(delayTime); }catch(Exception e){ }
     repaint( );
  }//clearTower

  // rewrite update( ) : Always required for good double-buffering.
  // This will cause the Applet not to first wipe off previous 
  // ..drawings but to immediately repaint. 
  // The wiping off  may also causes flickering. 
  // Update is called automatically when repaint( ) is called. 
  public void update(Graphics g) { paint(g); }  // s paint( )

  public void paint(Graphics g) {
     if(img == null) {
        // Create an offscreen image to draw on , same size
        dim = getSize( );  // obtain the width and height
        img = createImage(dim.width, dim.height); 
        bufferGraphics = img.getGraphics( );  
        // use Graphics methods to draw, this is double buffer
        return;
     }//if
     g.drawImage(img, 0, 0, this);   // ɤ~eù
     //System.out.println(" paint "+ ++kkk);
  }//paint(

  void initDisks( ) {
    int x, y;
    for(int n= nDisks; n>=1; --n) {
        if(bufferGraphics==null) repaint( );
        if(bufferGraphics==null) return;
        bufferGraphics.setColor(haColor); 
        x = xPosition[0] - wUnit*n/2;
        y = aY - (nDisks -n+1)*thick;
        bufferGraphics.fillRect(x, y, wUnit*n, thick);
    }//for
    repaint( );
    try{Thread.sleep(delayTime);}catch(Exception e){ }
   }

  void moveG(int px, int py, int n ) {  // the n-th disk
     if(img==null) return;  // not ready yet
     int from = px - 'A';
     int to = py - 'A';
     width = wUnit * n;   // width of n-th disk
     if(width > 128) width = 128;  // limit the width
     moveYUp(from, to, n);
     moveX(from, to, n);
     moveYDown(from, to, n);
     //
     --nPeg[from];  // from == 0? 1? 2?
     ++nPeg[to];
  }//moveG(

  void moveYUp(int fm, int to, int n ) {  // the n-th disk
     int x,y, y1, y2, step=MOVE_STEP;
     x = xPosition[fm] - width/2;
     y2 = Y_TOP;
     y1 = aY - (nDisks+1 -n)*thick;  // y-position of n-th disk
            //  ^^^^^^^^^^^^   y1  ? NOT correct ???  BUG !
     // move y from y1 to y2
     y = y1;
     while(y > y2+step) {
        bufferGraphics.setColor(Color.white ); 
        bufferGraphics.fillRect(x, y, width, thick); 
        y -= step;
        bufferGraphics.setColor(haColor ); 
        bufferGraphics.fillRect(x, y, width, thick); 
        repaint( ); 
        try{Thread.sleep(delayTime);}catch(Exception e){ }
     }//while(
     repaint( ); 
     try{Thread.sleep(delayTime);}catch(Exception e){ }
     bufferGraphics.setColor(Color.white ); 
     bufferGraphics.fillRect(x, y, width, thick); 
     bufferGraphics.setColor(haColor ); 
     bufferGraphics.fillRect(x, y2, width, thick); 
     repaint( );
     try{Thread.sleep(delayTime);}catch(Exception e){ }
  }//moveYUp

  void moveX(int fm, int to, int n ) {  // the n-th disk
     int x,y, x1, x2, step=MOVE_STEP;
     y = Y_TOP;
     x1 = xPosition[fm]  - width/2;  
     x2 = xPosition[to]  - width/2;;
     // move x from x1 to x2
     x = x1;
     while(x < x2-step) {
        bufferGraphics.setColor(Color.white ); 
        bufferGraphics.fillRect(x, y, width, thick); 
        x += step;
        bufferGraphics.setColor(haColor); 
        bufferGraphics.fillRect(x, y, width, thick); 
        repaint( ); 
        try{Thread.sleep(delayTime);}catch(Exception e){ }
     }//while(
     bufferGraphics.setColor(Color.white ); 
     bufferGraphics.fillRect(x, y, width, thick); 
     bufferGraphics.setColor(haColor); 
     bufferGraphics.fillRect(x2, y, width, thick); 
     repaint( );
     try{Thread.sleep(delayTime);}catch(Exception e){ }
  }//moveX

  void moveYDown(int fm, int to, int n ) {  // the n-th disk
     int x,y, y1, y2, step = MOVE_STEP;
     x = xPosition[to]  - width/2;;
     y1 = Y_TOP;
     y2 = aY - (nDisks+1 -n)*thick;    // destination
            //  ^^^^^^^^^^^^   y2  ? NOT correct ???  BUG !
     // move y from y1 to y2
     y = y1;
     while(y < y2-step) {
        bufferGraphics.setColor(Color.white ); 
        bufferGraphics.fillRect(x, y, width, thick); 
        y += step;
        bufferGraphics.setColor(haColor ); 
        bufferGraphics.fillRect(x, y, width, thick); 
        repaint( ); 
        try{Thread.sleep(delayTime);}catch(Exception e){ }
     }//while(
     bufferGraphics.setColor(Color.white ); 
     bufferGraphics.fillRect(x, y, width, thick); 
     bufferGraphics.setColor(haColor ); 
     bufferGraphics.fillRect(x, y2, width, thick); 
     repaint( );
     try{Thread.sleep(delayTime);}catch(Exception e){ }
  }// moveYDown

} // class
