/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JApplet;
import javax.swing.JFrame;

public class ShapesDemo2D
extends JApplet {
    static final int maxCharHeight = 15;
    static final int minFontSize = 6;
    static final Color bg = Color.white;
    static final Color fg = Color.black;
    static final Color red = Color.red;
    static final Color white = Color.white;
    static final BasicStroke stroke = new BasicStroke(2.0f);
    static final BasicStroke wideStroke = new BasicStroke(8.0f);
    static final float[] dash1 = new float[]{10.0f};
    static final BasicStroke dashed = new BasicStroke(1.0f, 0, 0, 10.0f, dash1, 0.0f);
    Dimension totalSize;
    FontMetrics fontMetrics;

    public void init() {
        this.setBackground(bg);
        this.setForeground(fg);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("ShapesDemo2D");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        ShapesDemo2D shapesDemo2D = new ShapesDemo2D();
        jFrame.getContentPane().add("Center", shapesDemo2D);
        ((Applet)shapesDemo2D).init();
        jFrame.pack();
        ((Component)jFrame).setSize(new Dimension(550, 100));
        jFrame.show();
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Dimension dimension = this.getSize();
        int n = dimension.width / 6;
        int n2 = dimension.height / 2;
        this.fontMetrics = this.pickFont(graphics2D, "Filled and Stroked GeneralPath", n);
        Color color = Color.lightGray;
        graphics2D.setPaint(color);
        graphics2D.draw3DRect(0, 0, dimension.width - 1, dimension.height - 1, true);
        graphics2D.draw3DRect(3, 3, dimension.width - 7, dimension.height - 7, false);
        graphics2D.setPaint(fg);
        int n3 = 5;
        int n4 = 7;
        int n5 = n - 2 * n3;
        int n6 = n2 - 3 - this.fontMetrics.getDescent();
        int n7 = n6 - this.fontMetrics.getMaxAscent() - n4 - 2;
        graphics2D.draw(new Line2D.Double(n3, n4 + n7 - 1, n3 + n5, n4));
        graphics2D.drawString("Line2D", n3, n6);
        graphics2D.setStroke(stroke);
        graphics2D.draw(new Rectangle2D.Double(n3 += n, n4, n5, n7));
        graphics2D.drawString("Rectangle2D", n3, n6);
        graphics2D.setStroke(dashed);
        graphics2D.draw(new RoundRectangle2D.Double(n3 += n, n4, n5, n7, 10.0, 10.0));
        graphics2D.drawString("RoundRectangle2D", n3, n6);
        graphics2D.setStroke(wideStroke);
        graphics2D.draw(new Arc2D.Double(n3 += n, n4, n5, n7, 90.0, 135.0, 0));
        graphics2D.drawString("Arc2D", n3, n6);
        graphics2D.setStroke(stroke);
        graphics2D.draw(new Ellipse2D.Double(n3 += n, n4, n5, n7));
        graphics2D.drawString("Ellipse2D", n3, n6);
        int[] nArray = new int[]{n3 += n, n3 + n5, n3, n3 + n5};
        int[] nArray2 = new int[]{n4, n4 + n7, n4 + n7, n4};
        GeneralPath generalPath = new GeneralPath(0, nArray.length);
        generalPath.moveTo(nArray[0], nArray2[0]);
        int n8 = 1;
        while (n8 < nArray.length) {
            generalPath.lineTo(nArray[n8], nArray2[n8]);
            ++n8;
        }
        generalPath.closePath();
        graphics2D.draw(generalPath);
        graphics2D.drawString("GeneralPath", n3, n6);
        n3 = 5;
        n6 += n2;
        int[] nArray3 = new int[]{n3, n3 + n5, n3, n3 + n5};
        int[] nArray4 = new int[]{n4 += n2, n4 + n7, n4 + n7, n4};
        GeneralPath generalPath2 = new GeneralPath(0, nArray3.length);
        generalPath2.moveTo(nArray3[0], nArray4[0]);
        int n9 = 1;
        while (n9 < nArray3.length) {
            generalPath2.lineTo(nArray3[n9], nArray4[n9]);
            ++n9;
        }
        graphics2D.draw(generalPath2);
        graphics2D.drawString("GeneralPath (open)", n3, n6);
        graphics2D.setPaint(red);
        graphics2D.fill(new Rectangle2D.Double(n3 += n, n4, n5, n7));
        graphics2D.setPaint(fg);
        graphics2D.drawString("Filled Rectangle2D", n3, n6);
        GradientPaint gradientPaint = new GradientPaint(n3 += n, n4, red, n3 + n5, n4, white);
        graphics2D.setPaint(gradientPaint);
        graphics2D.fill(new RoundRectangle2D.Double(n3, n4, n5, n7, 10.0, 10.0));
        graphics2D.setPaint(fg);
        graphics2D.drawString("Filled RoundRectangle2D", n3, n6);
        graphics2D.setPaint(red);
        graphics2D.fill(new Arc2D.Double(n3 += n, n4, n5, n7, 90.0, 135.0, 0));
        graphics2D.setPaint(fg);
        graphics2D.drawString("Filled Arc2D", n3, n6);
        gradientPaint = new GradientPaint(n3 += n, n4, red, n3 + n5, n4, white);
        graphics2D.setPaint(gradientPaint);
        graphics2D.fill(new Ellipse2D.Double(n3, n4, n5, n7));
        graphics2D.setPaint(fg);
        graphics2D.drawString("Filled Ellipse2D", n3, n6);
        int[] nArray5 = new int[]{n3 += n, n3 + n5, n3, n3 + n5};
        int[] nArray6 = new int[]{n4, n4 + n7, n4 + n7, n4};
        GeneralPath generalPath3 = new GeneralPath(0, nArray5.length);
        generalPath3.moveTo(nArray5[0], nArray6[0]);
        int n10 = 1;
        while (n10 < nArray5.length) {
            generalPath3.lineTo(nArray5[n10], nArray6[n10]);
            ++n10;
        }
        generalPath3.closePath();
        graphics2D.setPaint(red);
        graphics2D.fill(generalPath3);
        graphics2D.setPaint(fg);
        graphics2D.draw(generalPath3);
        graphics2D.drawString("Filled and Stroked GeneralPath", n3, n6);
    }

    FontMetrics pickFont(Graphics2D graphics2D, String string, int n) {
        boolean bl = false;
        Font font = graphics2D.getFont();
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n2 = font.getSize();
        String string2 = font.getName();
        int n3 = font.getStyle();
        while (!bl) {
            if (fontMetrics.getHeight() <= 15 && fontMetrics.stringWidth(string) <= n) {
                bl = true;
                continue;
            }
            if (n2 <= 6) {
                bl = true;
                continue;
            }
            font = new Font(string2, n3, --n2);
            graphics2D.setFont(font);
            fontMetrics = graphics2D.getFontMetrics();
        }
        return fontMetrics;
    }
}

