/*
 * Decompiled with CFR 0.152.
 */
import java.applet.AudioClip;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class SoundApplet
extends JApplet
implements ActionListener,
ItemListener {
    AppletSoundList soundList;
    String auFile = "spacemusic.au";
    String aiffFile = "flute+hrn+mrmba.aif";
    String midiFile = "trippygaia1.mid";
    String rmfFile = "jungle.rmf";
    String wavFile = "bottle-open.wav";
    String chosenFile;
    AudioClip onceClip;
    AudioClip loopClip;
    JComboBox formats;
    JButton playButton;
    JButton loopButton;
    JButton stopButton;
    boolean looping = false;

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.playButton) {
            this.onceClip = this.soundList.getClip(this.chosenFile);
            this.onceClip.play();
            this.stopButton.setEnabled(true);
            this.showStatus("Playing sound " + this.chosenFile + ".");
            if (this.onceClip == null) {
                this.showStatus("Sound " + this.chosenFile + " not loaded yet.");
            }
            return;
        }
        if (object == this.loopButton) {
            this.loopClip = this.soundList.getClip(this.chosenFile);
            this.looping = true;
            this.loopClip.loop();
            this.loopButton.setEnabled(false);
            this.stopButton.setEnabled(true);
            this.showStatus("Playing sound " + this.chosenFile + " continuously.");
            if (this.loopClip == null) {
                this.showStatus("Sound " + this.chosenFile + " not loaded yet.");
            }
            return;
        }
        if (object == this.stopButton) {
            if (this.looping) {
                this.looping = false;
                this.loopClip.stop();
                this.loopButton.setEnabled(true);
            } else if (this.onceClip != null) {
                this.onceClip.stop();
            }
            this.stopButton.setEnabled(false);
            this.showStatus("Stopped playing " + this.chosenFile + ".");
            return;
        }
    }

    public void init() {
        String[] stringArray = new String[]{this.auFile, this.aiffFile, this.midiFile, this.rmfFile, this.wavFile};
        this.formats = new JComboBox<String>(stringArray);
        this.formats.setSelectedIndex(0);
        this.chosenFile = (String)this.formats.getSelectedItem();
        this.formats.addItemListener(this);
        this.playButton = new JButton("Play");
        this.playButton.addActionListener(this);
        this.loopButton = new JButton("Loop");
        this.loopButton.addActionListener(this);
        this.stopButton = new JButton("Stop");
        this.stopButton.addActionListener(this);
        this.stopButton.setEnabled(false);
        JPanel jPanel = new JPanel();
        jPanel.add(this.formats);
        jPanel.add(this.playButton);
        jPanel.add(this.loopButton);
        jPanel.add(this.stopButton);
        this.getContentPane().add(jPanel);
        this.startLoadingSounds();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.chosenFile = (String)this.formats.getSelectedItem();
        this.soundList.startLoading(this.chosenFile);
    }

    public void start() {
        if (this.looping) {
            this.loopClip.loop();
        }
    }

    void startLoadingSounds() {
        this.soundList = new AppletSoundList(this, this.getCodeBase());
        this.soundList.startLoading(this.auFile);
        this.soundList.startLoading(this.aiffFile);
        this.soundList.startLoading(this.midiFile);
        this.soundList.startLoading(this.rmfFile);
        this.soundList.startLoading(this.wavFile);
    }

    public void stop() {
        this.onceClip.stop();
        if (this.looping) {
            this.loopClip.stop();
        }
    }
}

