/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Container;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;

public class SpinnerDemo
extends JPanel {
    public SpinnerDemo(boolean bl) {
        super(new SpringLayout());
        String[] stringArray = new String[]{"Month: ", "Year: ", "Another Date: "};
        int n = stringArray.length;
        Calendar calendar = Calendar.getInstance();
        JFormattedTextField jFormattedTextField = null;
        Object[] objectArray = SpinnerDemo.getMonthStrings();
        SpinnerListModel spinnerListModel = null;
        spinnerListModel = bl ? new CyclingSpinnerListModel(objectArray) : new SpinnerListModel(objectArray);
        JSpinner jSpinner = SpinnerDemo.addLabeledSpinner(this, stringArray[0], spinnerListModel);
        jFormattedTextField = this.getTextField(jSpinner);
        if (jFormattedTextField != null) {
            jFormattedTextField.setColumns(8);
            jFormattedTextField.setHorizontalAlignment(4);
        }
        int n2 = calendar.get(1);
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(n2, n2 - 100, n2 + 100, 1);
        if (spinnerListModel instanceof CyclingSpinnerListModel) {
            ((CyclingSpinnerListModel)spinnerListModel).setLinkedModel(spinnerNumberModel);
        }
        jSpinner = SpinnerDemo.addLabeledSpinner(this, stringArray[1], spinnerNumberModel);
        jSpinner.setEditor(new JSpinner.NumberEditor(jSpinner, "#"));
        Date date = calendar.getTime();
        calendar.add(1, -100);
        Date date2 = calendar.getTime();
        calendar.add(1, 200);
        Date date3 = calendar.getTime();
        SpinnerDateModel spinnerDateModel = new SpinnerDateModel(date, date2, date3, 1);
        jSpinner = SpinnerDemo.addLabeledSpinner(this, stringArray[2], spinnerDateModel);
        jSpinner.setEditor(new JSpinner.DateEditor(jSpinner, "MM/yyyy"));
        jFormattedTextField = this.getTextField(jSpinner);
        if (jFormattedTextField != null) {
            jFormattedTextField.setHorizontalAlignment(4);
            jFormattedTextField.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 3));
        }
        jSpinner.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        SpringUtilities.makeCompactGrid(this, n, 2, 10, 10, 6, 10);
    }

    public JFormattedTextField getTextField(JSpinner jSpinner) {
        JComponent jComponent = jSpinner.getEditor();
        if (jComponent instanceof JSpinner.DefaultEditor) {
            return ((JSpinner.DefaultEditor)jComponent).getTextField();
        }
        System.err.println("Unexpected editor type: " + jSpinner.getEditor().getClass() + " isn't a descendant of DefaultEditor");
        return null;
    }

    protected static String[] getMonthStrings() {
        int n;
        String[] stringArray = new DateFormatSymbols().getMonths();
        if (stringArray[n = stringArray.length - 1] == null || stringArray[n].length() <= 0) {
            String[] stringArray2 = new String[n];
            System.arraycopy(stringArray, 0, stringArray2, 0, n);
            return stringArray2;
        }
        return stringArray;
    }

    protected static JSpinner addLabeledSpinner(Container container, String string, SpinnerModel spinnerModel) {
        JLabel jLabel = new JLabel(string);
        container.add(jLabel);
        JSpinner jSpinner = new JSpinner(spinnerModel);
        jLabel.setLabelFor(jSpinner);
        container.add(jSpinner);
        return jSpinner;
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame jFrame = new JFrame("SpinnerDemo");
        jFrame.setDefaultCloseOperation(3);
        SpinnerDemo spinnerDemo = new SpinnerDemo(false);
        spinnerDemo.setOpaque(true);
        jFrame.setContentPane(spinnerDemo);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SpinnerDemo.createAndShowGUI();
            }
        });
    }
}

