/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SpinnerDemo4
extends JPanel {
    public SpinnerDemo4() {
        super(new SpringLayout());
        String[] stringArray = new String[]{"Shade of Gray: "};
        int n = stringArray.length;
        JSpinner jSpinner = SpinnerDemo4.addLabeledSpinner(this, stringArray[0], new GrayModel(170));
        jSpinner.setEditor(new GrayEditor(jSpinner));
        SpringUtilities.makeCompactGrid(this, n, 2, 10, 10, 6, 10);
    }

    protected static JSpinner addLabeledSpinner(Container container, String string, SpinnerModel spinnerModel) {
        JLabel jLabel = new JLabel(string);
        container.add(jLabel);
        JSpinner jSpinner = new JSpinner(spinnerModel);
        jLabel.setLabelFor(jSpinner);
        container.add(jSpinner);
        return jSpinner;
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame jFrame = new JFrame("SpinnerDemo4");
        jFrame.setDefaultCloseOperation(3);
        SpinnerDemo4 spinnerDemo4 = new SpinnerDemo4();
        spinnerDemo4.setOpaque(true);
        jFrame.setContentPane(spinnerDemo4);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SpinnerDemo4.createAndShowGUI();
            }
        });
    }

    class GrayEditor
    extends JLabel
    implements ChangeListener {
        public GrayEditor(JSpinner jSpinner) {
            this.setOpaque(true);
            GrayModel grayModel = (GrayModel)jSpinner.getModel();
            this.setBackground(grayModel.getColor());
            jSpinner.addChangeListener(this);
            this.updateToolTipText(jSpinner);
            Dimension dimension = new Dimension(60, 15);
            this.setMinimumSize(dimension);
            this.setPreferredSize(dimension);
        }

        protected void updateToolTipText(JSpinner jSpinner) {
            String string = jSpinner.getToolTipText();
            if (string != null) {
                if (!string.equals(this.getToolTipText())) {
                    this.setToolTipText(string);
                }
            } else {
                GrayModel grayModel = (GrayModel)jSpinner.getModel();
                int n = grayModel.getIntValue();
                this.setToolTipText("(" + n + "," + n + "," + n + ")");
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JSpinner jSpinner = (JSpinner)changeEvent.getSource();
            GrayModel grayModel = (GrayModel)jSpinner.getModel();
            this.setBackground(grayModel.getColor());
            this.updateToolTipText(jSpinner);
        }
    }

    class GrayModel
    extends SpinnerNumberModel {
        public GrayModel(int n) {
            super(n, 0, 255, 5);
        }

        public int getIntValue() {
            Integer n = (Integer)this.getValue();
            return n;
        }

        public Color getColor() {
            int n = this.getIntValue();
            return new Color(n, n, n);
        }
    }
}

