/*
 * Decompiled with CFR 0.152.
 */
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.SwingUtilities;

public class PasswordDemo
extends JPanel
implements ActionListener {
    private static String OK = "ok";
    private static String HELP = "help";
    private JFrame controllingFrame;
    private JPasswordField passwordField;

    public PasswordDemo(JFrame jFrame) {
        this.controllingFrame = jFrame;
        this.passwordField = new JPasswordField(10);
        this.passwordField.setEchoChar('#');
        this.passwordField.setActionCommand(OK);
        this.passwordField.addActionListener(this);
        JLabel jLabel = new JLabel("Enter the password: ");
        jLabel.setLabelFor(this.passwordField);
        JComponent jComponent = this.createButtonPanel();
        JPanel jPanel = new JPanel(new FlowLayout(4));
        jPanel.add(jLabel);
        jPanel.add(this.passwordField);
        this.add(jPanel);
        this.add(jComponent);
    }

    protected JComponent createButtonPanel() {
        JPanel jPanel = new JPanel(new GridLayout(0, 1));
        JButton jButton = new JButton("OK");
        JButton jButton2 = new JButton("Help");
        jButton.setActionCommand(OK);
        jButton2.setActionCommand(HELP);
        jButton.addActionListener(this);
        jButton2.addActionListener(this);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (OK.equals(string)) {
            char[] cArray = this.passwordField.getPassword();
            if (PasswordDemo.isPasswordCorrect(cArray)) {
                JOptionPane.showMessageDialog(this.controllingFrame, "Success! You typed the right password.");
            } else {
                JOptionPane.showMessageDialog(this.controllingFrame, "Invalid password. Try again.", "Error Message", 0);
            }
            for (int i = 0; i < cArray.length; ++i) {
                cArray[i] = '\u0000';
            }
            this.passwordField.selectAll();
            this.resetFocus();
        } else {
            JOptionPane.showMessageDialog(this.controllingFrame, "You can get the password by searching this example's\nsource code for the string \"correctPassword\".\nOr look at the section How to Use Password Fields in\nthe components section of The Java Tutorial.");
        }
    }

    private static boolean isPasswordCorrect(char[] cArray) {
        int n;
        boolean bl = true;
        char[] cArray2 = new char[]{'b', 'u', 'g', 'a', 'b', 'o', 'o'};
        if (cArray.length != cArray2.length) {
            bl = false;
        } else {
            for (n = 0; n < cArray.length; ++n) {
                if (cArray[n] == cArray2[n]) continue;
                bl = false;
            }
        }
        for (n = 0; n < cArray2.length; ++n) {
            cArray2[n] = '\u0000';
        }
        return bl;
    }

    protected void resetFocus() {
        this.passwordField.requestFocusInWindow();
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame jFrame = new JFrame("PasswordDemo");
        jFrame.setDefaultCloseOperation(3);
        final PasswordDemo passwordDemo = new PasswordDemo(jFrame);
        passwordDemo.setOpaque(true);
        jFrame.setContentPane(passwordDemo);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent windowEvent) {
                passwordDemo.resetFocus();
            }
        });
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PasswordDemo.createAndShowGUI();
            }
        });
    }
}

