/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;

public class TreeExpandEventDemo2
extends JPanel {
    DemoArea demoArea;
    JTextArea textArea;
    static final String newline = "\n";

    public TreeExpandEventDemo2() {
        super(new GridBagLayout());
        GridBagLayout gridBagLayout = (GridBagLayout)this.getLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.demoArea = new DemoArea();
        gridBagLayout.setConstraints(this.demoArea, gridBagConstraints);
        this.add(this.demoArea);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.textArea);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setPreferredSize(new Dimension(200, 75));
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        this.add(jScrollPane);
        this.setPreferredSize(new Dimension(450, 450));
        this.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
    }

    void saySomething(String string, TreeExpansionEvent treeExpansionEvent) {
        this.textArea.append(string + "; " + "path = " + treeExpansionEvent.getPath() + newline);
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame jFrame = new JFrame("TreeExpandEventDemo2");
        jFrame.setDefaultCloseOperation(3);
        TreeExpandEventDemo2 treeExpandEventDemo2 = new TreeExpandEventDemo2();
        treeExpandEventDemo2.setOpaque(true);
        jFrame.setContentPane(treeExpandEventDemo2);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TreeExpandEventDemo2.createAndShowGUI();
            }
        });
    }

    class DemoArea
    extends JScrollPane
    implements TreeExpansionListener,
    TreeWillExpandListener {
        Dimension minSize = new Dimension(100, 100);
        JTree tree;
        Object[] willExpandOptions = new Object[]{"Cancel Expansion", "Expand"};
        String willExpandText = "A branch node is about to be expanded.\nClick \"Cancel Expansion\" to prevent it.";
        String willExpandTitle = "Tree Will Expand";

        public DemoArea() {
            TreeNode treeNode = this.createNodes();
            this.tree = new JTree(treeNode);
            this.tree.addTreeExpansionListener(this);
            this.tree.addTreeWillExpandListener(this);
            this.setViewportView(this.tree);
        }

        private TreeNode createNodes() {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("San Francisco");
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Potrero Hill");
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("Restaurants");
            defaultMutableTreeNode2.add(defaultMutableTreeNode3);
            DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode("Thai Barbeque");
            defaultMutableTreeNode3.add(defaultMutableTreeNode4);
            defaultMutableTreeNode4 = new DefaultMutableTreeNode("Goat Hill Pizza");
            defaultMutableTreeNode3.add(defaultMutableTreeNode4);
            defaultMutableTreeNode3 = new DefaultMutableTreeNode("Grocery Stores");
            defaultMutableTreeNode2.add(defaultMutableTreeNode3);
            defaultMutableTreeNode4 = new DefaultMutableTreeNode("Good Life Grocery");
            defaultMutableTreeNode3.add(defaultMutableTreeNode4);
            defaultMutableTreeNode4 = new DefaultMutableTreeNode("Safeway");
            defaultMutableTreeNode3.add(defaultMutableTreeNode4);
            defaultMutableTreeNode2 = new DefaultMutableTreeNode("Noe Valley");
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            defaultMutableTreeNode3 = new DefaultMutableTreeNode("Restaurants");
            defaultMutableTreeNode2.add(defaultMutableTreeNode3);
            defaultMutableTreeNode4 = new DefaultMutableTreeNode("Hamano Sushi");
            defaultMutableTreeNode3.add(defaultMutableTreeNode4);
            defaultMutableTreeNode4 = new DefaultMutableTreeNode("Hahn's Hibachi");
            defaultMutableTreeNode3.add(defaultMutableTreeNode4);
            defaultMutableTreeNode3 = new DefaultMutableTreeNode("Grocery Stores");
            defaultMutableTreeNode2.add(defaultMutableTreeNode3);
            defaultMutableTreeNode4 = new DefaultMutableTreeNode("Real Foods");
            defaultMutableTreeNode3.add(defaultMutableTreeNode4);
            defaultMutableTreeNode4 = new DefaultMutableTreeNode("Bell Market");
            defaultMutableTreeNode3.add(defaultMutableTreeNode4);
            return defaultMutableTreeNode;
        }

        public Dimension getMinimumSize() {
            return this.minSize;
        }

        public Dimension getPreferredSize() {
            return this.minSize;
        }

        public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            TreeExpandEventDemo2.this.saySomething("Tree-will-expand event detected", treeExpansionEvent);
            int n = JOptionPane.showOptionDialog(this, this.willExpandText, this.willExpandTitle, 0, 3, null, this.willExpandOptions, this.willExpandOptions[1]);
            if (n == 0) {
                TreeExpandEventDemo2.this.saySomething("Tree expansion cancelled", treeExpansionEvent);
                throw new ExpandVetoException(treeExpansionEvent);
            }
        }

        public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) {
            TreeExpandEventDemo2.this.saySomething("Tree-will-collapse event detected", treeExpansionEvent);
        }

        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            TreeExpandEventDemo2.this.saySomething("Tree-expanded event detected", treeExpansionEvent);
        }

        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            TreeExpandEventDemo2.this.saySomething("Tree-collapsed event detected", treeExpansionEvent);
        }
    }
}

