/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;

public class CoordinatesDemo {
    private JLabel label;
    private Point clickPoint;
    private Point cursorPoint;

    private void buildUI(Container container) {
        container.setLayout(new BoxLayout(container, 3));
        CoordinateArea coordinateArea = new CoordinateArea(this);
        container.add(coordinateArea);
        this.label = new JLabel();
        this.resetLabel();
        container.add(this.label);
        coordinateArea.setAlignmentX(0.0f);
        this.label.setAlignmentX(0.0f);
    }

    public void updateCursorLocation(int n, int n2) {
        if (n < 0 || n2 < 0) {
            this.cursorPoint = null;
            this.updateLabel();
            return;
        }
        if (this.cursorPoint == null) {
            this.cursorPoint = new Point();
        }
        this.cursorPoint.x = n;
        this.cursorPoint.y = n2;
        this.updateLabel();
    }

    public void updateClickPoint(Point point) {
        this.clickPoint = point;
        this.updateLabel();
    }

    public void resetLabel() {
        this.cursorPoint = null;
        this.updateLabel();
    }

    protected void updateLabel() {
        String string = "";
        if (this.clickPoint == null && this.cursorPoint == null) {
            string = "Click or move the cursor within the framed area.";
        } else {
            if (this.clickPoint != null) {
                string = string + "The last click was at (" + this.clickPoint.x + ", " + this.clickPoint.y + "). ";
            }
            if (this.cursorPoint != null) {
                string = string + "The cursor is at (" + this.cursorPoint.x + ", " + this.cursorPoint.y + "). ";
            }
        }
        this.label.setText(string);
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame jFrame = new JFrame("CoordinatesDemo");
        jFrame.setDefaultCloseOperation(3);
        CoordinatesDemo coordinatesDemo = new CoordinatesDemo();
        coordinatesDemo.buildUI(jFrame.getContentPane());
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CoordinatesDemo.createAndShowGUI();
            }
        });
    }

    public static class CoordinateArea
    extends JComponent
    implements MouseInputListener {
        Point point = null;
        CoordinatesDemo controller;
        Dimension preferredSize = new Dimension(400, 75);
        Color gridColor;

        public CoordinateArea(CoordinatesDemo coordinatesDemo) {
            this.controller = coordinatesDemo;
            this.setBorder(BorderFactory.createMatteBorder(1, 5, 5, 1, Color.RED));
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.setBackground(Color.WHITE);
            this.setOpaque(true);
        }

        public Dimension getPreferredSize() {
            return this.preferredSize;
        }

        protected void paintComponent(Graphics graphics) {
            if (this.isOpaque()) {
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            graphics.setColor(Color.GRAY);
            this.drawGrid(graphics, 20);
            if (this.point != null) {
                graphics.setColor(this.getForeground());
                graphics.fillRect(this.point.x - 3, this.point.y - 3, 7, 7);
            }
        }

        private void drawGrid(Graphics graphics, int n) {
            Insets insets = this.getInsets();
            int n2 = insets.left;
            int n3 = insets.top;
            int n4 = this.getWidth() - insets.right;
            int n5 = this.getHeight() - insets.bottom;
            for (int i = n2; i < n4; i += n) {
                graphics.drawLine(i, n3, i, n5);
            }
            for (int i = n3; i < n5; i += n) {
                graphics.drawLine(n2, i, n4, i);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (this.point == null) {
                this.point = new Point(n, n2);
            } else {
                this.point.x = n;
                this.point.y = n2;
            }
            this.controller.updateClickPoint(this.point);
            this.repaint();
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.controller.updateCursorLocation(mouseEvent.getX(), mouseEvent.getY());
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.controller.resetLabel();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }
    }
}

