/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class ComponentEventDemo
extends JApplet
implements ComponentListener,
ActionListener {
    JTextArea display;
    JFrame aFrame;
    public boolean showIt = false;
    static final String SHOW = "show";
    static final String CLEAR = "clear";
    String newline = "\n";

    public void init() {
        this.display = new JTextArea();
        this.display.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.display);
        jScrollPane.setPreferredSize(new Dimension(200, 75));
        this.getContentPane().add((Component)jScrollPane, "Center");
        JButton jButton = new JButton("Start playing...");
        jButton.setActionCommand(SHOW);
        jButton.addActionListener(this);
        this.getContentPane().add((Component)jButton, "First");
        JButton jButton2 = new JButton("Clear");
        jButton2.setActionCommand(CLEAR);
        jButton2.addActionListener(this);
        this.getContentPane().add((Component)jButton2, "Last");
        JFrame.setDefaultLookAndFeelDecorated(true);
        this.aFrame = new JFrame("A Frame");
        ComponentPanel componentPanel = new ComponentPanel(this);
        this.aFrame.addComponentListener(this);
        componentPanel.addComponentListener(this);
        this.aFrame.getContentPane().add((Component)componentPanel, "Center");
        this.aFrame.pack();
        this.aFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ComponentEventDemo.this.showIt = false;
            }
        });
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand() == SHOW) {
            this.showIt = true;
            this.aFrame.setVisible(true);
        } else {
            this.display.setText("");
        }
    }

    public void stop() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ComponentEventDemo.this.aFrame.setVisible(false);
            }
        });
    }

    public void start() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (ComponentEventDemo.this.showIt) {
                    ComponentEventDemo.this.aFrame.setVisible(true);
                }
            }
        });
    }

    protected void displayMessage(String string) {
        this.display.append(string + this.newline);
    }

    public void componentHidden(ComponentEvent componentEvent) {
        this.displayMessage("componentHidden event from " + componentEvent.getComponent().getClass().getName());
    }

    public void componentMoved(ComponentEvent componentEvent) {
        this.displayMessage("componentMoved event from " + componentEvent.getComponent().getClass().getName());
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.displayMessage("componentResized event from " + componentEvent.getComponent().getClass().getName());
    }

    public void componentShown(ComponentEvent componentEvent) {
        this.displayMessage("componentShown event from " + componentEvent.getComponent().getClass().getName());
    }
}

