/*
 * Decompiled with CFR 0.152.
 */
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;

class ColorAndTextTransferHandler
extends ColorTransferHandler {
    private DataFlavor stringFlavor = DataFlavor.stringFlavor;
    private JTextComponent source;
    private boolean shouldRemove;
    Position p0 = null;
    Position p1 = null;

    ColorAndTextTransferHandler() {
    }

    public boolean importData(JComponent jComponent, Transferable transferable) {
        JTextComponent jTextComponent = (JTextComponent)jComponent;
        if (!this.canImport(jComponent, transferable.getTransferDataFlavors())) {
            return false;
        }
        if (jTextComponent.equals(this.source) && jTextComponent.getCaretPosition() >= this.p0.getOffset() && jTextComponent.getCaretPosition() <= this.p1.getOffset()) {
            this.shouldRemove = false;
            return true;
        }
        if (this.hasStringFlavor(transferable.getTransferDataFlavors())) {
            try {
                String string = (String)transferable.getTransferData(this.stringFlavor);
                jTextComponent.replaceSelection(string);
                return true;
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                System.out.println("importData: unsupported data flavor");
            }
            catch (IOException iOException) {
                System.out.println("importData: I/O exception");
            }
        }
        return super.importData(jComponent, transferable);
    }

    protected Transferable createTransferable(JComponent jComponent) {
        this.source = (JTextComponent)jComponent;
        int n = this.source.getSelectionStart();
        int n2 = this.source.getSelectionEnd();
        Document document = this.source.getDocument();
        if (n == n2) {
            return null;
        }
        try {
            this.p0 = document.createPosition(n);
            this.p1 = document.createPosition(n2);
        }
        catch (BadLocationException badLocationException) {
            System.out.println("Can't create position - unable to remove text from source.");
        }
        this.shouldRemove = true;
        String string = this.source.getSelectedText();
        return new StringSelection(string);
    }

    public int getSourceActions(JComponent jComponent) {
        return 3;
    }

    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        if (this.shouldRemove && n == 2 && this.p0 != null && this.p1 != null && this.p0.getOffset() != this.p1.getOffset()) {
            try {
                JTextComponent jTextComponent = (JTextComponent)jComponent;
                jTextComponent.getDocument().remove(this.p0.getOffset(), this.p1.getOffset() - this.p0.getOffset());
            }
            catch (BadLocationException badLocationException) {
                System.out.println("Can't remove text from source.");
            }
        }
        this.source = null;
    }

    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        if (this.hasStringFlavor(dataFlavorArray)) {
            return true;
        }
        return super.canImport(jComponent, dataFlavorArray);
    }

    protected boolean hasStringFlavor(DataFlavor[] dataFlavorArray) {
        int n = 0;
        while (n < dataFlavorArray.length) {
            if (this.stringFlavor.equals(dataFlavorArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

