/*
 * @(#)DatagramSocketImplFactory.java	1.6 01/12/03
 *
 * Copyright 2002 Sun Microsystems, Inc. All rights reserved.
 * SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package java.net;

/**
 * This interface defines a factory for datagram socket implementations. It
 * is used by the classes <code>DatagramSocket</code> to create actual socket
 * implementations.
 *
 * @author  Yingxian Wang
 * @version %I %E
 * @see     java.net.DatagramSocket
 * @since   1.3
 */
public
interface DatagramSocketImplFactory {
    /**
     * Creates a new <code>DatagramSocketImpl</code> instance.
     *
     * @return  a new instance of <code>DatagramSocketImpl</code>.
     * @see     java.io.DatagramSocketImpl
     */
    DatagramSocketImpl createDatagramSocketImpl();
}
