/*
 * @(#)hprof_name.c	1.1 98/08/14
 *
 * Copyright 1997, 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

#include <string.h>
#include "hprof.h"

static hprof_hash_t hprof_name_table;

static unsigned int hash_name(void *_hname)
{
    hprof_name_t *hname = _hname;
    unsigned int hash = 0;
    int len = strlen(hname->name);
    int i;

    for (i = 0; i < len; i++) {
        hash = 37*hash + hname->name[i];
    }
    return hash;
}

static unsigned int size_name(void *_name)
{
    return sizeof(hprof_name_t);
}

static int compare_name(void *_hname1, void *_hname2)
{
    hprof_name_t *hname1 = _hname1;
    hprof_name_t *hname2 = _hname2;

    return (strcmp(hname1->name, hname2->name));
}

void hprof_name_table_init(void)
{
    hprof_hash_init(&hprof_name_table, 20009,
		    hash_name, size_name, compare_name);
}

void hprof_output_name(hprof_name_t *name)
{
    if (output_format == 'b') {
        if (name->marked) {
	    return;
	} else {
	    name->marked = 1;
	    if (name->name) {
	        hprof_write_header(HPROF_UTF8, strlen(name->name) + sizeof(void *));
		hprof_write_id(name);
		hprof_write_raw(name->name, strlen(name->name));
	    }
	}
    }
}

hprof_name_t * hprof_intern_name(char *name)
{
    hprof_name_t name_tmp;
    hprof_name_t *result;
    
    if (name == NULL) {
        name = "<Unknown>";
    }
    name_tmp.name = name;
    result = hprof_hash_lookup(&hprof_name_table, &name_tmp);
    if (result == NULL) {
        name_tmp.name = strdup(name);
	name_tmp.marked = 0;
	result = hprof_hash_put(&hprof_name_table, &name_tmp);
    }
    hprof_output_name(result);
    return result;
}
