/* @(#)hprof_jni.c	1.2 98/12/17
 *
 * Copyright 1997, 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

#include "hprof.h"

static hprof_globalref_t *hprof_globalrefs = NULL;

static void
hprof_globalref_add(hprof_objmap_t *obj_id, 
		    jobject ref_id, 
		    unsigned int trace_serial_num)
{
    hprof_globalref_t *globalref = hprof_calloc(sizeof(hprof_globalref_t));
    globalref->obj_id = obj_id;
    globalref->ref_id = ref_id;
    globalref->trace_serial_num = trace_serial_num;
    globalref->next = hprof_globalrefs;
    hprof_globalrefs = globalref;
}

static void 
hprof_globalref_del(jobject ref_id)
{
    hprof_globalref_t **p = &hprof_globalrefs;
    hprof_globalref_t *globalref;
    while ((globalref = *p)) {
        if (globalref->ref_id == ref_id) {
	    *p = globalref->next;
	    hprof_free(globalref);
	    return;
	}
	p = &(globalref->next);
    }
}

hprof_globalref_t * hprof_globalref_find(jobject ref_id)
{
    hprof_globalref_t *globalref = hprof_globalrefs;
    while (globalref) {
        if (globalref->ref_id == ref_id) {
	    return globalref;
	}
	globalref = globalref->next;
    }
    return NULL;
}

void hprof_jni_globalref_alloc_event(JNIEnv *env_id, jobjectID obj_id, jobject ref_id)
{
    hprof_trace_t *htrace;
    hprof_objmap_t *objmap;
    
    CALL(RawMonitorEnter)(data_access_lock);
    htrace = hprof_get_trace(env_id, max_trace_depth);
    if (htrace == NULL) {
        fprintf(stderr, "HPROF ERROR: got NULL trace in jni_globalref_alloc\n");
	goto globalref_alloc_done;
    } 
    
    objmap = hprof_fetch_object_info(obj_id);
    if (objmap == NULL) {
        fprintf(stderr, "HPROF ERROR: unable to map JVMPI obj ID to hprof "
		"obj ID in globalref_alloc \n");
	goto globalref_alloc_done;
    }
   
    hprof_globalref_add(objmap, ref_id, htrace->serial_num);

 globalref_alloc_done:
    CALL(RawMonitorExit)(data_access_lock);
}
    
void hprof_jni_globalref_free_event(JNIEnv *env_id, jobject ref_id)
{
    hprof_trace_t *htrace;
    
    CALL(RawMonitorEnter)(data_access_lock); 
    hprof_globalref_del(ref_id);
    CALL(RawMonitorExit)(data_access_lock);
}

