program SISC_Computer;
(***********************************************************************)
(***************** Simple Instruction Set Computer *********************)
(** by Wen-Nung Tsai, tsaiwn@csie.nctu.edu.tw, written in Turbo Pascal**)
(** @CopyLeft reserved:-)                      (:- @CopyLeft reserved **)
(** COPY/Distribute it as long as you like it with Author information **)
(** All CopyLeft notices are maintained on this software source code. **)
(* Replace "Break" by "goto ..." if you use Turbo Pascal 6.0 or below. *)
(* 2010-03-10 Version 3.36 ---  Enable SETPC Directive for start addr. *)
(* 2010-03-08 Version 3.35 ---  Enable ORG directive when loading MCode*)
(* 1996-12-20 Version 3.33 ---  fix some bugs that cause SISC to crash *)
(* 1996-12-20 Version 3.32 ---  Enable CTRL_C when GETi reading integer*)
(* 1996-12-19 Version 3.31 ---  myReadln so that reading Unix file OK  *)
(* 1996-11-24 Version 3.3  ---  command X to generate Internal eXample *)
(* 1996-11-23 Version 3.25 ---  horselight changed + Dos shell         *)
(* 1996-11-03 Version 3.2  ---  horselight at bottom                   *)
(* 1995-12-30 Version 3.1  ---  command F for changing log File        *)
(* 1995-12-19 @ Hsinchu, Taiwan, R.O.C.                                *)
(***  The Source Program can be found in  ~csie1bta/public/sisc.pas  ***)
(***********************************************************************)
(***********************************************************************
    This Simple Instruction Set Computer (SISC) has the Architecture 
of the computer described in the Appendix B of our text book with some
extensions:
    1. The Memory has 1024 bytes. But you can toggle it between 256/1024.
    2. The Program Counter has 10 bits and thus can access 1024 bytes
       of the memory. However, it will use only 8 bits if the memory
       size is toggled to 256-byte mode.
    3. There is an internal STACK of 200 words which used for
       CALL ??? and RETURN instructions.
    4. I/O instructions are supported so that you can really
       write a program that its work can be watched:-)
    5. Integer comparisom instruction can be used to compare two
       integers in registers and the conditional jump instructions
       JLT/JEQ/JGE will jump to a location (up to 3ff in hex) if
       it matchs the status that affected by last CMP instruction.
       Note that the integers are treated as signed integer, though
       the PUTi will print out their value in 0..255.
--------------------------------------------------------------------------
   This program emulates the simple computer that described in Appendix B
   of the text book that written  by J.Glenn Brookshear:
     "Introduction to Computer Science: An Overview, fourth edition."
   However, the instruction set has been expanded.
       The additional instructions are listed below:(refer to pp.455-456)
       ****** Note that "?" means don't care
          0???   NOP   (No OPeration)
          D0??   GETC : Get a Char into R0
          D1??   PUTC : Output a Char from R0
          D2??   GETi : Get an integer into R0
          D3??   PUTi : Output integer from R0
          D5XY   GETS : Get a String into Memory starts from location XY
          D6XY   PUTS : Output String from Memory location XY till a '$'
 the followin instructions can have address that up to 3ffh (1023 decimal):
    (Note that  those "zzz xxxx yyyy" below are  in binaryform.)
         EZXY : determined by right 2 bits in Z (see below)
          Ezz00 xxxx yyyy: LOAD F,zzxxxxyyyy
          Ezz01 xxxx yyyy:STORE F,zzxxxxyyyy
          Ezz10 xxxx yyyy: CALL zzxxxxyyyy
          E??11 ???? ????: RETurn
         FZXY   : determined by right 2 bits in Z
           zzzz xxxx yyyy are all in binary form:
           ??00 xxxx yyyy:  CMP RX to RY     (will affect status:LT/EQ/GT)
           zz01 xxxx yyyy:  JLT zzxxxxyyyy    (Jump if the status is LT)
           zz10 xxxx yyyy:  JEQ zzxxxxyyyy
           zz11 xxxx yyyy:  JGT zzxxxxyyyy
         Only CMP instruction can affect LT/EQ/GT status
***********************************************************************)
(***********************************************************************)
(** by Wen-Nung Tsai, tsaiwn@csie.nctu.edu.tw, written in Turbo Pascal**)
(* CopyLeft not reserved:-)  COPY/Distribute it as long as you like it.*)
(* @1995-12-19 *)
(***********************************************************************)

{$M 16384,0,65536  **This is Directive;  DO NOT Remove this line!  }

uses Crt,Dos;
         (* Not standard! *)
         (* Crt unit: keypressed,readkey,window,text... *)
         (* Dos unit:  for GetTime() *)
         (* I didn't use Strings unit which deal C-like strings *)
Const ESC=27;  version='3.36';
      initDelayTime=1;  (*Default delay time in milli seconds *)
      defaultLogName:string[15]='SISC.LOG';
      MaxStrLen=28; (* we only allowed 28 chars per line*)
      w1len=18; w1width=35; (* for cmdWindow on left screen *)
      w2len=5; w2width=37;  (* for memaddr window for instructions dealed*)
      w3len=5;  (* 5 rows for the memdata window *)
      X1:byte=3; Y1:byte=4;  (* cmdWindow's up-left corner = (3,4)  *)
      x2:byte=42; y2:byte=4;
      x3:byte=42; y3:byte=17;    (* memdata window *)
      pcx:byte=42; pcy:byte=10;  (* for the window to show CPU status *)
      pcwidth:byte=37; pclen:byte=5;
      w1color=lightGreen; (* text color for cmdWindow *)
    MSLarge=1024;  (* Large Size of MEMory *)
    MSSmall=256;   (* Memory size small mode *)
    STACKSize=200; (* STACK has 200 words for CALL/RETURN *)
    MNEMONIC: array[0..15] of string[5]=(
      'NOP  ','LOAD ', 'LDI  ', 'STORE', 'MOVE ', 'ADD  ','FADD ', 'OR   ',
      'AND  ','XOR  ','ROTR ',  'JUMP ', 'Halt ', 'PUTS ','LOADF', 'CMP  ');
    ioinst: array[0..6] of string[8]=(
      'GETC    ', 'PUTC    ', 'GETi    ', 'PUTi    ', '???',
      'GetS    ', 'PutS    ');
type cputype= record
                     PC:integer;
                     REG: array[0..15] of integer;
                     IR:integer;
                     TEMP:integer;
                     Carry: byte;
                     BP,numBP: integer;
                     STACK: array [0..STACKSize] of integer;
                     SP: integer;
                   end;
    ALUtype=  record
                opcode,reg1,reg2,reg3,reg4:byte;
                addr:word; (* reg4 is the right-2 bit of reg1 *)
              end;
var
   startAddress: integer;  (* for cpu.PC after Loadding program *)
   gotCTRLCwhenGetline: boolean;  (* when hit CTRL_C *)
   psHr:integer;  (* for horse light *)
   toggleHorse:integer;  (* for horse Light *)
   myMessage: string[238];  (* for horse Light *)
   hCount: integer;  (* for horse Light *)
   cx1,cx2,cx3, cy1,cy2,cy3,xone,xten:Byte;  (* for cursor of windows *)
   xtmp,ytmp:Byte; (* tmpint:integer; *)
   CMD,CMD2,OldCMD,tmpCMD:char;  (* store the CoMmanD *)
   FLOG: text;   
   logFileName: string[15];
   tmpstr:string[33];  ps:integer;
   tmp4char,tmp2char,strInteger:string[4];
   str80,strBlank:string[80];   (* used for input STRING *)
   str40:string[40];
   HehitESCape,HehitCTRLC: boolean;
   Delaytime: Word;    sold:Word; (* SecondOLD for saving time/second *)
   MEMSize: integer;  (* store the Size of MEMory *)
   MEM: array[0..MSLarge-1+1] of integer;     (* the MEMory cells *)
   Upc: integer; (* pc(program counter) for Unassemble command*)
   strinst: string[20]; (* STRing for INStruction that decoded *)
   CPU: cputype;
   ALU: ALUtype;
(*============================================================*)
function isORG(s:string): boolean; forward;
function isSetPC(s:string): boolean; forward;
function getPC(s:string): integer; forward;
procedure hello; forward;
procedure setBackground; forward;
procedure showCPU; forward;
procedure showHint(txt:string;mode:Byte); forward;
procedure newShell; forward;
function myReadKey(var SPCKEY:char): char; forward;
procedure cmdWindow(t:string; crlf:integer); forward;
procedure cmdWin2(t:string; crlf:integer); forward;
    (******
       cmdWindow(t,crlf) and cmdWin2(t,crlf) both display
       the string t on the command window. the flag crlf is
       used to determined if CR/LF are rewuired after t is
       displayed: 0 means NO while 1 means YES.
       cmdWindow(t,crlf) will also append the text onto
       the LOG file so that you can have a running script
    ******)
procedure showmem(nextinst:integer;mode:integer); forward;
procedure memdatawin(loc:integer); forward;
(***=========================================================***)
procedure beep;
begin
    sound(500); delay(50); nosound;
end;
 (************)
procedure beeBee;
const f1=890; f2=890; f3=880; f4=880;
begin
  sound(f1); delay(30); nosound; delay(20); sound(f2); delay(30); nosound;
  sound(f3); delay(30); nosound; delay(20); sound(f4); delay(30); nosound;
end;
(***=========================================================***)
function isORG(s:string): boolean; 
Label eoj;
begin
   isORG:=false;  (* assume false*)
   if((s[1] <> 'O') and (s[1] <> 'o')) then goto eoj;
   if((s[2] <> 'R') and (s[2] <> 'r')) then goto eoj;
   if((s[3] <> 'G') and (s[3] <> 'g')) then goto eoj;
   isORG:= true;
  eoj:
end;
(***=========================================================***)
function getPC(s:string): integer; 
var len,i,p:integer;  c:char;
    tmps:string[8];
    v1,v2,err1,err2,pos,nInst:integer;
begin
    i:=1;
    while true do begin
       if(s[i] = 'C') then Break;
       i := i+1;
    end;
    i := i+1;   (* skip 'C' *)
    while true do begin
       if(s[i] <> ' ') then Break;
       i := i+1;
    end;
    len:= ord(s[0]);
    p:= 1;
    while true do begin  (* more chars *)
       tmps[p] := s[i];
       p:=p+1; i:=i+1;
       if (p>4) or(i>len) then Break; 
    end;
    tmps[0] := chr(p-1);
    val(tmps, v1, err1);   (* string to integer *)
    if(err1=0)then getPC := v1
    else getPC := 0;   (* error when val() *)
end;
(***=========================================================***)
function isPC(s:string): boolean; 
Label eoj;
begin
   isPC:=false;  (* assume false*)
   if(UpCase(s[1])<> 'P') then goto eoj;
   if(UpCase(s[2])<> 'C') then goto eoj;
   isPC:= true; goto eoj;
  eoj:
end;
function isSetPC(s:string): boolean; 
Label eoj, setTest;
begin
   isSetPC:=false;  (* assume false*)
   if(UpCase(s[1])= 'S') then goto setTest;
   if(UpCase(s[1])<> 'P') then goto eoj;
   if(UpCase(s[2])<> 'C') then goto eoj;
   isSetPC:= true; goto eoj;    (*PC ... *)
  setTest:
   if(UpCase(s[2])<> 'E') then goto eoj;
   if(UpCase(s[3])<> 'T') then goto eoj;
   if(UpCase(s[4])<> 'P') then goto eoj;
   if(UpCase(s[5])<> 'C') then goto eoj;
   isSetPC:= true; goto eoj;    (*SETPC ... *)
  eoj:
end;
(***=========================================================***)
procedure newShell;
var c1,c2: char;
Label EOJ;
begin
    beep;
    cmdWindow('', 1);
    cmdWindow('About to new a DOS shell',1);
    textcolor(LightRED);
    Writeln('type EXIT to get back here!');
     cmdWin2('',1);   (* no LOG*)
     textcolor(w1color);
     beeBee;
     cmdWindow('Hit  Y  to confirm:', 0);
     showHint('Y confirm, other key give up',0);
    c1:= myReadKey(c2);    c1:= UpCase(c1);
    cmdWindow(c1,0); nosound;
    cmdWindow('',1);
    if(c1 <> 'Y') then goto EOJ;
    window(1,1,80,25); TextBackground(Black);  
    TextColor(lightGreen); 
    clrScr;
    SwapVectors;
      Exec(GetEnv('COMSPEC'), ' /K  echo type EXIT to back to SISC');
    SwapVectors;
      cmdWin2('',1);
      setBackground;  (* set  BackGround color*)
     hello;
    showCPU; 
    showHint('H  for Help,  Q to Quit',Blink);
  EOJ:
      beep;
end;
(***=========================================================***)
 procedure horseLight;
 var len:integer;
     loopTimes:integer;
 Label eoj;
 begin
     if(toggleHorse=0) then goto eoj;   (* horse light off*)
     if(toggleHorse=2) then goto eoj;   (* horse light off*)
     if(toggleHorse=4) then goto eoj;   (* horse light off*)
     loopTimes := 18;  (* 1 *)
     if(toggleHorse = 3) then loopTimes := 3;
     if(toggleHorse = 5) then loopTimes := 38;
     len := length(myMessage);
     hCount := (hCount + 1) mod loopTimes;  (* do NOT run too fast *)
     if (hCount <> 1) then goto eoj; 
     window(18,24,58,24);
     TextBackground(blue);  textcolor(yellow);
     psHr:=  (1+ psHr) mod len;  
     Write('        ', copy(myMessage,psHr+1, len-psHr+1), 
                       copy(myMessage,1,psHr));
  eoj:
     delay(1);
 end;
(***=========================================================***)
procedure showTime;    (* show time on the Right-Upper corner *)
var h,m,s,hund: Word;  (* Word==integer  in Standard Pascal*)
begin
    horseLight;
    GetTime(h,m,s,hund);   (* In Turbo Pascal IDE, press CTRL_F1 for HELP*)
    if(s <> sold)then begin
         window(72,1,80,1);  sold := s;  TextColor(LightMagenta);
         TextBackground(white);   Write(h:02,':');
         if(m<10)then Write('0'); Write(m:0,':');
         if(s<10)then Write('0'); Write(s:0);
         if(m=00) then if (s<2) then beeBee;
    end;
end;
(***=========================================================***)
function myReadKey(var SPCKEY:char): char;
 begin
     While(not KeyPressed) do begin
        delay(88); showTime;
        cmdWin2('',0);   (* required so that cursor in cmdWindow *)
     end;
     SPCKEY:= ReadKey; MyReadKey:=SPCKEY;
     if( ord(SPCKEY)=0)then SPCKEY:=ReadKey; (* special KEY has two bytes*)
 end;
(***=========================================================***)
function myCheckESC:boolean;  (* return TRUE if ESCape key pressed*)
 var c,c2:char;
 begin
      myCheckESC:=false;
      if(KeyPressed) then begin
        c:=myReadKey(c2);
        if(ord(c)=ESC) then myCheckESC:=true;
      end;
 end;
(***=========================================================***)
function FileExists(FileName: String): Boolean;
{ Boolean function that returns True if the file exists;otherwise,
 it returns False. Closes the file if it exists. }
var
 F: file;
begin
 {$I-}   (* turn off I/O checking *)
 Assign(F, FileName);
 FileMode := 0;  (* Set file access to read only *)
  Reset(F);
 Close(F);
 {$I+}
 FileExists := (IOResult = 0) and (FileName <> '');
end;  { FileExists }
(*******************)
function LeadingZero(w : Word) : String;
var
  s : String;
begin
  Str(w:0,s);     (* convert integer w into a string in s *)
  if Length(s) = 1 then
    s := '0' + s;
  LeadingZero := s;
end;
(**************************************)
procedure openLOG(LGFileN:string);
      (* LOG the running script into the file 'SISC.LOG' *)
const
  days : array [0..6] of String[9] =
    ('Sunday','Monday','Tuesday',
     'Wednesday','Thursday','Friday',
     'Saturday');
var
  h, m, s, hund : Word;
  y, mm, d, dow : Word;
begin   (* open LOG file and write down time and date *)
   assign(FLOG,LGFileN);
   if(FileExists(LGFileN)) then Append(FLOG)
   else Rewrite(FLOG);
   Writeln(FLOG);
   Write(FLOG, '****** SISC LOG at ');
   GetTime(h,m,s,hund);
   Write(FLOG,LeadingZero(h),':',
              LeadingZero(m),':',LeadingZero(s));
   GetDate(y,mm,d,dow);
   Write(FLOG,' on ', days[dow],', ',
              mm:0, '/', d:0, '/', y:0);
   Writeln(FLOG,' ******');
end;
(***=========================================================***)
procedure hello;
begin
    Window(1, 1, 80, 1 );
    TextBackground(Black);
    sound(888); delay(88); sound(777); delay(77); sound(888); delay(99);
    clrscr; nosound;
    TextBackground(White);    TextColor(LightRed);
    GotoXY(19,1);  Write('Simple Instruction Set Computer ver ',version);
    (******)
    Window(27,2, 77, 2);  TextBackground(Green);  textcolor(Yellow);
    Write('J.Glenn Brookshear');
    TextBackground(white);  textcolor(Black);
    gotoXY(25,1);   Write('tsaiwn@csie.nctu.edu.tw');
    tmp4char:='0000';
end;
(***=========================================================***)
procedure showHint(txt:string;mode:Byte);
begin   (* mode=0 : normal,  mode=blink *)
    Window(1, 2, 26, 2 ); TextBackground(Black);
    TextColor(White+mode); Write(txt);
end;
(***********************************)
procedure clearHint;
begin
     showHint('                         ',0);  (**)
end;
(***=========================================================***)
function mygetline(xp,yp:Byte;mode:integer):integer;
   (* input a line and return number of char we got as function value *)
var x,y,nch: Byte;  c1,c2: char;
begin
     gotCTRLCwhenGetline := false;
     x:=xp; y:=yp;   (* Cursor for cmdWindow or cmdWin2 *)
     nch:=0;   (* assume 0 char input *)
     str80[0]:= chr(0);  (* assume null string *)
     c1 := myReadKey(c2);
     while True  do begin
       case ord(c1) of
         3: begin (* Control_C *)
                  cx1:=x; cy1:=y;
                  if(nch>0)then cmdWindow(str80,0);
                  cmdWindow('^C',1);
                  nch:=0;  mygetline:= -999;
                  str80[0]:= chr(0);
                  gotCTRLCwhenGetline := true;
                  Break; 
            end;
         8: begin (* backSpace *)
               if nch > 0 then begin
                  cmdWin2('',0);
                  textcolor(Black);
                  cx1:=x; cy1:=y;   (* cursor back to original position*)
             (*   cmdWin2('',0); clreol;   *)  (* I do it by myself *)
                  strblank[0]:= chr(nch); (* string length *)
                  cmdWin2(strblank,0);   (* clear old string *)
                  textcolor(w1color);
                  dec(nch);  str80[0]:= chr(nch);
                  cx1:=x; cy1:=y;
                  cmdWin2(str80,0);
               end else beep;
            end;
        27: begin  (* ESCape *)
               if nch=0 then mygetline:= -888;
               Break;   (* done *)
            end;
        10: begin   (* chr(10)= LF = New Line *)
              beep;
            end;
        13: begin (* chr(13)= Ctrl_M = RETURN key *)
               if nch=0 then mygetline := -999
               else begin
                  cx1:=x; cy1:=y;
                  cmdWindow(str80,0);   (* show and LOG it *)
               end;
               cmdWindow('',1); (* CR/LF *)
               Break;  (* done, leave the While Loop *) (* Break; *)
            end;
        32..126:
            begin
               if(nch >= MaxStrLen ) then Beep
               else begin (* got one char *)
                  inc(nch);  cmdWin2(c1,0); (* echo the character *)
                  str80[nch] := c1;
                  str80[0] := chr(nch);
               end;
            end;
        else
            Beep;
       end; (*case*)
       c1:=myReadKey(c2);
     end;(*While*)
 (* done: *)
     if(nch>0)then begin
       str80[0]:= chr(nch);
       mygetline:= nch;
     end;
end;
(******====================******)
function getint(mode:integer):integer;      (* get an Integer *)
            (* mode=0 means decimal, mode=16 means hex *)
var nch,xpos,ypos: Byte;  data,errcode:integer;
begin
     xpos:=cx1;   ypos:=cy1;
     if(mode = 0) or (mode=10) then
        showHint('Decimal or $??? for Hex',0)
     else
        showHint('enter Hexadecimal value',0);
     cmdWin2('',0); (* move CURSOR *)
     nch:=mygetline(xpos,ypos,1);  (* get line into str80 *)
     getint:= nch; (* assume error input, -999 or -888 *)
     if nch > 0 then begin
        errcode:=0;
        if(mode=0) or (mode=10) or (str80[1]='$') then
           val(str80, data, errcode)
        else
           val('$'+str80, data, errcode);   (* Hexadecimal mode *)
        getint:= data;  (* suppose got data *)
        if errcode <> 0 then getint:= -777; (* not integer *)
     end; (* got something *)
end;
(***=========================================================***)
function hex2ch(n:integer):char;
begin   (* return the Right most Nibble in character form*)
     n:= (n and 15)+ ord('0');
     if n > ord('9') then n:= n-ord('9')+ord('A')-1;
     hex2ch:= chr(n);
end;
(***=========================================================***)
procedure int2hex(n:integer);
(* integer to Hexdecimal *)
(* result will be placed in tmp4char:string[4] *)
var k,hex:word;
begin
  for k:=4 downto 1 do begin
     tmp4char[k]:= hex2ch(n);
     n := n shr 4;
  end;
end;
(***=========================================================***)
procedure int2ch(n:integer);
(* integer to 2 char  *)
(* result will be placed in tmp2char:string *)
var k,bb:word;
begin
  for k:=2 downto 1 do begin
     tmp2char[k]:= '.';
     bb :=  n and $7f;
     if(bb > 31) and (bb < 127) then tmp2char[k]:= chr(bb);
     n := n shr 8;
  end;
  tmp2char[0]:=chr(2);
end;
(***=========================================================***)
procedure unasm(data:integer);   (* Un Assembly the instruction *)
begin  (*unasm *)
  with ALU do begin
    strinst:=' ';  opcode:= data shr 12;
    reg1:= (data shr 8) and $0f;
    addr:= data and 255;   reg2:=addr div 16;  reg3:= addr mod 16;
    case opcode of
      0,12: strinst:= MNEMONIC[opcode];  (* NOP, Halt *)
      1,2,3,11:  begin  (* 1=LOAD, 2=LDI, 3=STORE, 11=JUMP *)
            strinst:= concat(MNEMONIC[opcode],' .,. ');
            strinst[7]:=hex2ch(reg1);
            strinst[9]:=hex2ch(reg2);  strinst[10]:=hex2ch(reg3);
          end;
      4:  begin
            strinst:='MOVE  .,  ';
            strinst[7]:=hex2ch(reg2);
            strinst[9]:=hex2ch(reg3);
          end;
      5..9:  begin  (* 5=ADD, 6=FADD, 7=OR, 8=AND, 9=XOR *)
            strinst:= concat(MNEMONIC[opcode],' .,.,. ');
            strinst[7]:=hex2ch(reg1);
            strinst[9]:=hex2ch(reg2);  strinst[11]:=hex2ch(reg3);
          end;
      10:  begin
            strinst:='ROTR  .,  ';
            strinst[7]:=hex2ch(reg1);
            strinst[9]:=hex2ch(reg3);
          end;
      13:  begin (* I/O *)
              strinst:='?   ';
              case reg1 of
               0,1,2,3,5,6:
                 begin
                    strinst:= ioinst[reg1];  (* 'PUTS  XY' *)
                    if(reg1=5)or (reg1=6) then begin
                       strinst[7]:=hex2ch(reg2);
                       strinst[8]:=hex2ch(reg3);
                    end;
                 end;
              end;(*case*)
          end; (*13: *)
      14: begin
             reg4:= reg1 and 3;
             reg1:= reg1 shr 2;
             case reg4 of
               0: strinst:='LOAD  F,000 ';
               1: strinst:='Store F,000 ';
               2: strinst:='CALL    000 ';
               3: strinst:='RETURN      ';
             end;
             if(reg4<3)then begin
                strinst[9]:=hex2ch(reg1);
                strinst[10]:=hex2ch(reg2);
                strinst[11]:=hex2ch(reg3);
                addr:= ( integer(reg1) SHL 8 ) or addr;
                addr:= addr mod MEMSize;
             end;
          end;    (* 15: *)
      15: begin
             reg4:= reg1 and 3;
             reg1:= reg1 shr 2;
             case reg4 of
               0: strinst:='CMP   .,. ';
               1: strinst:='JLT   ... ';
               2: strinst:='JEQ   ... ';
               3: strinst:='JGT   ... ';
             end;
             strinst[9]:=hex2ch(reg3);
             if(reg4=0)then  strinst[7]:=hex2ch(reg2)
             else begin  (* JLT/JEQ/JGT zXY *)
                strinst[7]:=hex2ch(reg1); strinst[8]:=hex2ch(reg2);
                addr:= ( integer(reg1) SHL 8 ) or addr;
                addr:= addr mod MEMSize;
             end;
          end;    (* 15: *)
    end; (* case*)
  end; (* with *)
end;  (* unasm *)
(***=========================================================***)
procedure showCPU;   (* show CPU status *)
const textCY:array [0..1] of string[3]=('No ', 'Yes');
      textLTEQGT:array [-1..1] of string[8]=(
          '< LT', 'EQ =', 'GT >');
var flagrelation,pc,nextinst,data,k:integer;
begin  (*showCPU*)
    pc:=CPU.PC;  (* show Program Counter first *)
    window(pcx,pcy,pcx+pcwidth,pcy+pclen);
    TextBackground(black);   textcolor(LightGreen);
    Write('PC:  '); textcolor(LightRED);
    int2hex(pc);  Write(copy(tmp4char,2,3));
    textcolor(LightGreen);    Write('h');
    (* then show the BP *)
    GotoXY(13,1);    Write('break Pointer(hex): ');
    int2hex(CPU.BP);
    if(CPU.numBP>0)then Write(copy(tmp4char,2,3):4)else Write('none');
    Writeln;
    (* then the MEM[pc] and MEM[pc+1] *)
    nextinst:= (integer(MEM[pc]) SHL 8) or (MEM[pc+1] and $00ff);
    int2hex(nextinst);
    Write('MEM[PC]= ',copy(tmp4char,1,2));
    Write('  ', copy(tmp4char,3,2));
    textcolor(Yellow);
    unasm(nextinst);  Write('   ',strinst:15);
    Writeln;  textcolor(LightGreen);
(*    int2hex(CPU.IR);  Write('IR: ',tmp4char,'h  '); *)
    (* show MEMory Size *)
    str(MEMSize,strInteger);
    textcolor(yellow);    Write(MEMSize:4,' bytes');
    textcolor(LightGreen);
    (* then the Status/Flag *)
    Write(',Carry: ');
    if(CPU.carry<>0)then textcolor(LightRED) else textcolor(White);
    Write(textCY[CPU.carry]);  textcolor(LightGreen);
    flagrelation:=0;   if(CPU.TEMP<0)then flagrelation:= -1
                     else if(CPU.TEMP>0)then flagrelation:=1;
    Writeln('<=>status: ', textLTEQGT[flagrelation]);
    for k:=0 to 15 do begin
        data:=CPU.REG[k]; int2hex(data);
        Write('R',hex2ch(k),'=');
        if(k=0)then textbackground(LightRed);
        Write(copy(tmp4char,3,2));
        textbackground(Black); Write(' ');
        if(k=5) or (k=11) then Writeln;
    end;
    showmem(0,0); (* Write memdatawin if refer to a memory cell *)
end;
(***=========================================================***)
procedure showmem(nextinst:integer;mode:integer);
begin
    if(mode<>0) then unasm(nextinst);
    with ALU do begin
       case opcode of
         1,3,11:
            begin
               memdatawin(addr);
            end;
         14,  (* LOAD F,zXY  / STORE / CALL /RETURN *)
         15:begin (* CMP, JLT/JEQ/JGT *)
               if(reg4<>0) then memdatawin(addr);
            end;
         else
       end; (*case*)
    end; (* with *)
end;
(***=========================================================***)
procedure cmdWin2(t:string;crlf:integer);
begin
      Window(X1, Y1, X1 +w1width, Y1 + w1len );
      TextBackground(Black);    TextColor(w1color);
      gotoXY(cx1,cy1);
      Write(t); if(crlf<>0) then Writeln;
      cx1:=whereX; cy1:=whereY; (*backup current X,Y for latter use*)
end;
(***=========================================================***)
procedure cmdWindow(t:string;crlf:integer);
    (* the only difference between cmdWindow and cmdWin2 is that
       the latter won't LOG the output text *)
begin
      cmdWin2(t,crlf);
      (* then, Write to LOG file *)
      Write(FLOG,t); if(crlf<>0) then Writeln(FLOG);
end;
(***=========================================================***)
 procedure memAddrWin(where:integer);
     (* decode an instruction and show on memaddr window *)
     (* where is the memory location to decode *)
 var data,pc:integer;
 begin
      Window(X2, Y2, X2 + 35, Y2 + w2len);
      TextBackground(Black);     TextColor(Yellow);
      pc:=where; if(pc<0) then pc:=CPU.pc;
      pc:=pc mod MEMSize; gotoxy(cx2,cy2);
      int2hex(pc);   Write(copy(tmp4char,2,3),':  ');
      data:= (MEM[pc] SHL 8) or (MEM[pc+1] and $00ff);
      int2hex(data);    Write(tmp4char,'  ');
      unasm(data); Write(strinst);
      Writeln;
      cx2:=whereX; cy2:=whereY;
 end;
(***=========================================================***)
procedure show4Instructions;
var k:integer;
begin
   for k:=0 to 4 do begin   (* show the first 4 instructions *)
       memAddrWin(2*k + CPU.pc);
   end;
end;
(***=========================================================***)
 procedure memdatawin(loc:integer);
 var data:integer;
 begin
         Window(X3, Y3, X3 + 35, Y3 + w3len);
         TextBackground(Black);     TextColor(LightRED);
         gotoxy(cx3,cy3);
         int2hex(loc);   Write(copy(tmp4char,2,3),':  ');
         data:=  MEM[loc] and $00ff;
         int2hex(data);    Write(copy(tmp4char,3,2),'h  == ',data:3);
         if(data > 127) then
             Write('  ==  -', 256-data:0);
         Writeln;
         cx3:=whereX; cy3:=whereY;
 end;
(***=========================================================***)
procedure showHelp;  (* print out the additional instructions *)
begin
   cmdWindow(' ',1);
   cmdWindow('Command can be either Upper case',1);
   cmdWindow('               or lower case:',1);
   cmdWindow('  Q   Quit this system',1);
   cmdWindow('  H/I Help message/Instructions',1);
   cmdWindow('  A   Assemble assembly program',1);
   cmdWindow('  B   set break pointer',1);
   cmdWindow('  E   show/Enter memory data',1);
   cmdWindow('  L/S Load/Save the Machine Code',1);
   cmdWindow('  P   set Program counter',1);
   cmdWindow('  R?  modify content of Register ?',1);
   cmdWindow('  G   Go (RUN) start from PC',1);
   cmdWindow('  T   Trace the program one step',1);
   cmdWindow('  U   Unassemble (16 instructions)',1);
   cmdWindow('  M   Memory size toggle',1);
   cmdWindow('  =+- show/change RUNNING speed',1);
   cmdWindow('  other cmd:  C K F X Y . ,',1);
   cmdWindow('Only CMP affects LT/EQ/GT status',1);
end;
(***=========================================================***)
procedure addToMem(var pc:integer; instStr:string);
      (** add the instruction in instStr into MEM[pc]... **)
var k:integer;
    c1,c2: char;
    v1,v2,err1,err2,pos,nInst:integer;
begin
    nInst := length(instStr) div 4;   (* 4 hex per instruction *)
    pos := 0;
    for k:=0 to nInst-1 do begin
         val('$0'+copy(instStr,1+pos,2), v1, err1);
         val('$0'+copy(instStr,3+pos,2), v2, err2);
       (****** 4 Hex digit per instruction ******)
         MEM[pc]:= v1 and $00ff;   (* 8 bits / Byte *)
         MEM[pc+1] := v2 and $00ff;
         pc := pc + 2 ; 
         pos := pos+4;     (* next instruction *)
         if(pc > MEMSize) then Break; 
    end;  (* for *)
end;
procedure generateMoreCodes(var pc:integer);
var  c1,c2: char;
     iiStr: string;
begin
     pc:=160;  (* 0A0h *)
     pc:=170;   (* starting at 0AAh according to text book*)
   (* ; ORG $AA   ; .start 0AAh  ( $A0 )  *)
     iiStr := '210122002530270f286C';
     addToMem(pc, iiStr);
     iiStr := '204Dd1002028d1002030d100';
     addToMem(pc, iiStr);
     iiStr := '4080500230d92acc';
     addToMem(pc, iiStr);
     iiStr := '3a27B0102068d100';
     addToMem(pc, iiStr);

     iiStr := '2029d100203Dd100';
     addToMem(pc, iiStr);
     iiStr := '10ff2aE03a27B010';
     addToMem(pc, iiStr);
     iiStr := '200Dd100200Ad100';
     addToMem(pc, iiStr);
     iiStr := '52212003B2f0B0B4';
     addToMem(pc, iiStr);
     iiStr := 'C000B0A00000';
     addToMem(pc, iiStr);

    
     (*   ORG $10   ; .start 10h   ( $10 )   *)
     pc := 16;
        (*******)
     iiStr := '400dA00480072A1c';
     addToMem(pc, iiStr);
     iiStr := '3a41B02840d08007';   (*41 ; 28 *)
     addToMem(pc, iiStr);
     iiStr := '2A263a41B028B0ff';
     addToMem(pc, iiStr);
     iiStr := '400C2009BC3c2008';
     addToMem(pc, iiStr);
     iiStr := 'BC3c8AC02000BA3c';
     addToMem(pc, iiStr);
     iiStr := '20075CC050C5D100';
     addToMem(pc, iiStr);
     iiStr := 'B0ffB0A00000';
     addToMem(pc, iiStr);

     clearHint;
end;
(***=========================================================***)
procedure generateExample;
var  c1,c2: char;
     pc, pc1, k, data: integer;
Label giveUp, done;
begin
    cmdWindow('', 1);
    cmdWindow('generate Example in textbook', 1);
    textcolor(LightRED);
    Writeln('Caution! Memory will be override!');
    cmdWin2('',1);   (* no LOG*)
    textcolor(w1color);
    beep;
    cmdWindow('Hit  Y  to confirm:', 0);
     showHint('Y confirm, C clear Memory',0);
    c1:= myReadKey(c2);    c1:= UpCase(c1);
    cmdWindow(c1,0); nosound;
    cmdWindow('',1);

(***** clear memory? *****)
    if(c1 = 'C') then begin  (* clear memory*)
       cmdWindow('',1);
       textcolor(LightRED);
       Writeln('About to Clear Memory !');
       cmdWin2('',1);   (* no LOG*)
       cmdWin2(' Are you sure(N,Y)? ',0);   (* no LOG*)
        clearHint;
        showHint('Hit y  will do CLEAR MEM',0);
       textcolor(w1color);
       c1:= myReadKey(c2);    c1:= UpCase(c1);
       cmdWindow(c1,0); nosound;
       if(c1 <> 'Y') then goto giveUp; 
       (* clear memory *)
       for k:=0 to MEMSize-1 do begin
           MEM[k] :=  0;
       end;
       CPU.pc := 0;   (* reset PC *)
       cmdWindow('',1);
       cmdWindow('ALL Memory Cleared.',1);
       cmdWindow('PC reset to 0x00',1);
       show4Instructions;
       goto done;
    end;
    if(c1 <> 'Y') then goto giveUp; 
    (***************************************)
    cmdWin2('',1);   (* no LOG*)
    cmdWindow('PC will be set to A0 as in book', 1); 

    CPU.pc := 160;   (* 0xA0 *)
     MEM[160] :=  21;
      MEM[161] := 108;
     MEM[162] :=  22;
      MEM[163] := 109;
     MEM[164] := 80;
      MEM[165] := 86;
     MEM[166] :=  48;
      MEM[167] := 110;
     MEM[168] :=  192;   (* C0 = 192 *)
      MEM[169] := 0;
      (******
           iiStr := '156C166D5056306EC000';
           addToMem(pc, iiStr);
      ******)
     generateMoreCodes(pc);     (*************)
             (***************************)
     MEM[108] := $33;   (* 6c *)
     MEM[109] := $55;   (* 6D *)
     MEM[$6e] := 0;   (* 6e *)
     pc:=160;
     for k:=1 to 10 do begin
         int2hex(pc);   
         cmdWindow(copy(tmp4char,2,3)+':  ',0);
         pc1:= (pc+1) mod MEMSize;
         data:= (MEM[pc] SHL 8) or (MEM[(pc1)] and $00ff);
         int2hex(data);    
         cmdWindow(tmp4char+'  ',0);
         int2ch(data);   (* data ==> tmp2char *)
         cmdWindow(tmp2char+'  ',0);
         unasm(data);  
         cmdWindow(strinst,1);
         pc:= (pc + 2 ) mod MEMSize;
     end;
     show4Instructions;
     goto done;
giveUp:
     cmdWindow(' Give UP!', 1);
done:
     clearHint; showCPU;
end;
(***=========================================================***)
procedure showInst;  (* print out the additional instructions *)
var  c1,c2: char;
begin
cmdWindow(' ',1);
   cmdWindow('In addition to instructions on',1);
   cmdWindow('our text book page 455-456,',1);
   cmdWindow('("?" means don''t care)',1);
   cmdWindow(' D0??/D1?? Get/Put Char to/from R0',1);
   cmdWindow(' D2??/D3?? Get/Put int to/from R0',1);
   cmdWindow(' D5XY/D6XY In/Put string to/from XY',1);
   cmdWindow('EZXY (zzzz xxxx yyyy in binary):',1);
   cmdWindow(' Ezz00 xxxx yyyy: LOAD F,zzxxxxyyyy',1);
   cmdWindow(' Ezz01 xxxx yyyy:STORE F,zzxxxxyyyy',1);
   cmdWindow(' Ezz10 xxxx yyyy: CALL zzxxxxyyyy',1);
   cmdWindow(' E??11 ???? ????: RETurn',1);
   cmdWindow(' FZXY  compare/conditional Jump',1);
   cmdWindow('  zzzz in binary:',1);
   cmdWindow('  ??00 xxxx yyyy:  CMP RX to RY',1);
   cmdWindow('  zz01 xxxx yyyy:  JLT zzxxxxyyyy',1);
   cmdWindow('  zz10 xxxx yyyy:  JEQ zzxxxxyyyy',1);
   cmdWindow('  zz11 xxxx yyyy:  JGT zzxxxxyyyy',1);
   cmdWindow('Only CMP affects LT/EQ/GT status',1);
   (****** ******)
   cmdWindow('Hit ', 0);
   TextBackground(Black); TextColor(2); 
   cmdWindow('i ', 0);
   TextColor(w1color); TextBackground(Black);
   cmdWindow('to show other Instructions:',0);
    showHint('hit I key or any key',0);
   c1:= myReadKey(c2);    c1:= UpCase(c1);
   cmdWindow(c1,0); nosound;
   cmdWindow('',1);
   if(c1='I') or (c1='i') then begin (* instructions on textbook *)
     clearHint; 
       cmdWindow('OP OPErand meaning',1); 
       cmdWindow(' 0  ???   NOP   (by tsaiwn@nctu)', 1);
       cmdWindow(' 1  RXY   LOAD  R,XY', 1);
       cmdWindow(' 2  RXY   LDI   R,XY', 1);
       cmdWindow(' 3  RXY   STORE R,XY', 1);
       cmdWindow(' 4  0ST   MOVE  S,T ', 1);
       cmdWindow(' 5  RST   ADD   R,S,T ', 1);
       cmdWindow(' 6  RST   FADD  R,S,T ', 1);
       cmdWindow(' 7  RST   OR    R,S,T ', 1);
       cmdWindow(' 8  RST   AND   R,S,T ', 1);
       cmdWindow(' 9  RST   XOR   R,S,T ', 1);
       cmdWindow(' A  R0N   ROTR  R,N ', 1);
       cmdWindow(' B  RXY   JUMP  R,XY', 1);
       cmdWindow(' C  ???   Halt ', 1);
       cmdWindow('',  1);
   end;
   clearHint; 
end;
(***=========================================================***)
 procedure setBackground;      (* set New Background *)
 var k:integer;
 begin
    TextBackground(Black); ClrScr;
    window(1,3,80,23);   (* change only (1,3)-(80,23) BG color *)
      (**    TextBackground(Random(16));   ClrScr;  **)
    TextBackground(3);   
    ClrScr;
    for k:=1 to 30 do
       cmdWin2('                                    ',1);
 end;
(***=========================================================***)
function ishexdigit(c:char):boolean;
begin
    ishexdigit:= false;
    if( UpCase(C) in ['0','1','2','3','4','5','6','7','8','9',
              'A','B','C','D','E','F'] )
    then ishexdigit:=TRUE;
end;
(******=================******)
procedure waitReturnKey;
var c2:char;
begin
   repeat  until myReadKey(c2) = char(13);
end;
(***=========================================================***)
procedure showSTACK;
var tmpstr: string[6];
    k,cnt:integer;
begin
    k:=CPU.SP;  str(k:4,tmpstr);
    cmdWindow('  '+tmpstr+' elements in STACK',1);
    if(k>0)then begin
       int2hex(CPU.STACK[k]); (* into tmp4char *)
       cmdWindow('  '+tmp4char+'   <--- TOP',1);
       k:=k-1; cnt:=1;
       while (K>0) do begin
          if(cnt mod 10) = 0 then begin
             cmdWin2('Hit Return to continue...',0);
             waitReturnKey; cmdWin2('',1);
          end;(*if cnt *)
          int2hex(CPU.STACK[k]); (* into tmp4char *)
          cmdWindow('  '+tmp4char,1);
          k:=k-1; cnt:=cnt+1;
       end; (*while*)
    end; (* if k *)
end; (* showSTACK *)
(***=========================================================***)
procedure doUnassemble;
var Upc1,data,k:integer;
begin
     if(OldCMD <> 'u') and (OldCMD<>'U')   (* previous CMD is not "U" *)
       then Upc:=CPU.pc mod MEMSize;  (* unassemble from Program Counter *)
     for k:=1 to 16 do begin
         int2hex(Upc);   cmdWindow(copy(tmp4char,2,3)+':  ',0);
         Upc1:= (Upc+1) mod MEMSize;
         data:= (MEM[Upc] SHL 8) or (MEM[(Upc1)] and $00ff);
         int2hex(data);    cmdWindow(tmp4char+'  ',0);
         int2ch(data); (* data ==> tmp2char *)
         cmdWindow(tmp2char+'  ',0);
         unasm(data);  cmdWindow(strinst,1);
         Upc:= (Upc + 2 ) mod MEMSize;
     end;
end;
(***=========================================================***)
procedure zapInp2Str40(var s:string);
   (* remove blank/tab/ ","   s ---> str40[]  *)
var k,i,p:integer;  c:char;
Label zapDone;
begin
     i:=1; p:=0; k:= ord(s[0]);
     while k > 0 do begin  (* more chars *)
        c := s[i];
        if (p>4) or((ord(c) > 32) and (c<>',')) then begin 
                    (* 32= $20 = ' ' *)
           inc(p);  str40[p]:= c;
           if(p > 39) then goto zapDone;   (* max 39 char *)
        end; (*if*)
        dec(k);  inc(i);  (* next char *)
     end;
   zapDone:
     str40[0] := chr(p);  (* number of char in the string *)
end;
(******************)
(***=========================================================***)
function myReadln(var F:text; var strinp:string):integer;
   (* read a line from F and return number of char we got *)
var x,y,nch: Byte;  
    c1,c2: char;
    cRead: integer;
Label again, okok;
begin
     cRead:=0;   (* assume 0 char input *)
     strinp[0]:= chr(0);  (* assume null string *)
     myReadln:= -999;
   again:
     while not eof(F)  do begin
        read(F, c1);
        if(ord(c1) = 13) then goto again;
        if(ord(c1) = 10) then goto okok;
        (*****************)
        cRead := cRead + 1;
        strinp[cRead] := c1;
     end; (* not eof *)
   okok:
     strinp[0]:= chr(cRead); 
     myReadln:= cRead;
end;
(***=========================================================***)
procedure LoadMachineCode; (* Load instruction codes from file into memory *)
var k,nch,loc, nLine:integer;  c1:char;
    v1,v2,err1,err2,inplen, cRead:integer;
    F: text;
            (*  strinp:string[88];   *)
    strinp:string;
begin
   showHint('default EXTention is .MC',0);
   cmdWindow('Make sure your file is TEXT File. ',1);
   cmdWindow('Filename: ',0);
   nch:=mygetline(cx1,cy1,1);
   if(nch>0)then begin
      if(pos('.',str80)=0)then str80 := str80+'.MC';
      for k:=1 to nch do str80[k]:=UpCase(str80[k]);
   end; (* if nch > 0 *)  (*   cmdWindow(str80,1);  *) (* echo *)
   if (nch>0 ) and (fileexists(str80))then begin
      Assign(F, str80);
      cmdWindow('=== Loading file '+str80+' ===',1);
      reset(F); loc:=0;
      nLine := 0;
      startAddress := 0;   (* Default Starting address in cpu.PC*)
      repeat
            (* readln(F,strinp);   not work for Unix file? *)
         cRead := myReadln(F,strinp);   (* my own readln() function *)
         nLine := nLine+1;
         zapInp2Str40(strinp);   (* zap out (remove) blank *)
         c1:= str40[1];  (* 1st char, ";" for comment *)
         inplen:=ord(str40[0]);  (* length(str40) *)
         if(c1=';') then cmdWindow(strinp,1)   (* comment *)
         else if( isPC(str40)  ) then begin   (* PC directive *)
                  startAddress:= getPC(str40);
                  cmdWindow('', 1);
                  cmdWindow('  '+str40, 1);
              end
         else if( isSetPC(str40)  ) then begin   (* SETPC directive *)
                  startAddress:= getPC(str40);
                  cmdWindow('', 1);
                  cmdWindow('  '+str40, 1);
              end
         else if( isORG(str40)  ) then begin   (* ORG directive *)
                  val(copy(str40+'  ',4,3), v1, err1);
                  if(err1=0)then begin
                     loc := v1;  (*no error*)
                     cmdWindow('', 1);
                     cmdWindow('  ORG '+copy(str40,4,33), 1);
                  end; (* if *)
              end
         else if (inplen<4) or(NOT(ishexdigit(c1)) )then begin (*error*)
                 if(inplen=0) then cmdWindow('      ',0)
                 else cmdWindow(' ???  ',0);
                 cmdWindow(strinp,1);   
              end
         else begin
            val('$0'+copy(str40,1,2), v1, err1);   (* HexaDecimal *)
            val('$0'+copy(str40,3,2), v2, err2);
            if(err1+err2) = 0 then begin  (* no error *)
               int2hex(loc);  (* to HEX in tmp4char *)
               cmdWindow(tmp4char+': ',0);
               cmdWindow(strinp,1);
               MEM[loc]:= v1 and $00ff;
               MEM[loc+1] := v2 and $00ff;
               loc := loc + 2 ; if(loc > MEMSize) then Break; 
            end;(*if err..*)
         end(*if c1 *)
      until eof(F);
      Close(F);   { Close file, save changes }
      cmdWindow('Total ', 0);
      Write(nLine:3);
      Write(' Lines read.');
      cmdWindow('',1);
      cpu.PC:= startAddress mod MEMSize; (* reset the Program_Counter *)
      show4Instructions;   (* show the first 4 instructions *)
   end else begin (* file error *)
      if nch>0 then cmdWindow(str80+' not found',1);
   end;
   clearHint; showCPU;
end;
(***=========================================================***)
procedure initCPU; (* Initialize CPU *)
begin
     CPU.PC:=0;  CPU.carry:=0;
     CPU.numBP:=0;  CPU.SP:=0;
     MEMSize:=MSLarge;  (* default 1024 bytes *)
     OldCMD:='*';  
     delayTime:= initDelayTime;  nosound;
end;
(***=========================================================***)
procedure setBreakPoint; (* set BREAK pointer *)
var newbp:integer;  x,y:byte;
begin
     CPU.numBP:=0;
(* call mygetlin *)
     cmdWindow('Enter BP(RETURN to clear):',0);
     x:=cx1; y:=cy1;
     newbp := getint(16);
(*     gotoXY(x,y);   cmdWindow(str80,1); *)
     if( newbp >= 0 ) then begin
         CPU.BP := newbp mod MEMSize;
         CPU.numBP:=1;
     end;
     clearHint; showCPU;
end;
(***=========================================================***)
procedure setPC; (* set Program Counter *)
var newpc:integer;  x,y:byte;
    oldpc:integer;
begin
(* call mygetlin *)
     oldpc := CPU.PC;
     cmdWindow('Enter new Program Counter:',0);
     x:=cx1; y:=cy1; newpc := getint(16);
(*     gotoXY(x,y);  cmdWindow(str80,1);  *)


     if( newpc >= 0 ) then begin
         CPU.PC := newpc mod MEMSize;
         show4Instructions;   (* show the first 4 instructions *)
     end;
     clearHint; showCPU;
     if( newpc < 0 ) then begin
        cmdWindow('Current PC is 0x',0);
        int2hex(oldpc);  
        Write(copy(tmp4char,2,3));
        cmdWindow('',1);
     end;
end;
(***=========================================================***)
procedure RegisterModify;
var tmpx,tmpy:Byte; c1,c2:char; v,errCode,data:integer;
begin
    clearHint;  cmdWindow(UpCase(CMD),0);
(*    showHint('Enter register number ',0);  (***)
    showHint('Enter register# or = x',0);
    sound(20);   cmdWin2('',0);
    tmpx:=cx1; tmpy:=cy1;
    c1:= myReadKey(c2);    c1:= UpCase(c1);
    cmdWindow(c1,1); nosound;
    if(c1='X') then begin (* clear all registers *)
          for v:=0 to 15 do cpu.REG[v]:=0;
          cmdWindow('all Registers cleared',1);
          showCPU;
                    end
    else if(c1='=') then begin (* show all registers *)
          for v:=0 to 15 do  begin
             int2hex( cpu.REG[v] and $00ff); (* to tmp4char *)
             cmdWindow('R'+hex2ch(v)+'= '+copy(tmp4char,3,2)+'  ',0);
             if( v and 3) = 3 then cmdWindow('',1); (* next line *)
          end;
                         end
    else if(ishexdigit(c1)) then begin
          Val( '$0'+c1, v, errCode);
          if(errCode=0)then begin
             int2hex( cpu.REG[v] and $00ff); (* to tmp4char *)
             cmdWindow('R'+c1+'= '+copy(tmp4char,3,2)+': ',0);
             data:=getint(16);
(*             gotoXY(tmpx,tmpy);  cmdWindow(str80,1);  *)
             if data <= -777 then   (* -777,-888,-999 means no change *)
                data:=data
             else begin
                cpu.REG[v] := data AND $00ff;
                showCPU;
             end;
          end;(* if errCode *)
    end;(*if c1*)
    clearHint;
end;
(******====================******)
procedure entermemory;  (* command E *)
          (* Examine memory cell/Enter Hexa value into memory *)
var loc,data:integer;
label done;
begin
      cmdWindow('Location(hex)?',0); loc:=getint(16);
         (* loc < 0 means : He hit RETURN only *)
   While (loc >=0 ) do begin
      loc:=loc mod MEMSize;  (* make sure in the RANGE of legal memory *)
      (* cmdWindow('',1);  *)   (* CR/LF *)
      int2hex(loc);  cmdWindow('  MEM['+copy(tmp4char,2,3)+'h] = ',0);
      str( (MEM[loc] and $00ff):3,strInteger);
      cmdWindow('dec '+strInteger+'  = ',0);
      memdatawin(loc);   (* tmp4char will get the mem[loc] data *)
      cmdWindow(copy(tmp4char,3,2)+'h : ',0);
      showHint(' Enter new value in HEX',0);
      data:=getint(16);
      if data <= -777 then goto done;  (* -999 means no change *) (* Break; *)
      MEM[loc] := data AND $00ff;
      memdatawin(loc);
      loc := loc+1;  (* next MEMory cell *)
   end; (* while loc *)
  done:
     clearHint;   (*   cmdWindow('',1);  (**)
     showCPU;
end;
(***=========================================================***)
function floatValue(data:integer):real;
const wet:array [0..7] of integer=(1,2,4,8,16,32,64,128);
var exponent,sign,fraction: integer;
    ans:real;
begin
     sign:=1;  (* assume positive *)
     if(data and $80) <> 0 then sign:= -1; (* negative *)
     exponent:= (data shr 4) and 7;   (* bit-6, bit-5, bit-4 *)
     fraction:= data and $0f;
     ans:= (fraction* wet[exponent])/256.0;
     if sign < 0 then ans:= -ans;
     floatValue:=ans;
     (***     cmdWin2('',0); Writeln(ans);Writeln;  ***)  (* test *)
end;
function float2bin(fdata:real):integer;
const expbit:array [-4..3] of integer=
                (0, $10, $20, $30, $40,  $50, $60, $70);
var signbit,exponent,ans:integer;
begin
     signbit:=0; (* assume positive *)
     if fdata < 0 then begin
        signbit:= 1; (* negative *)
        fdata := -fdata;
     end;
     exponent:=0;
     if fdata = 0 then begin ans:=0; exponent:= -4; end
     else if fdata = 0.5 then ans:= 8
     else if fdata < 0.5 then begin
            while fdata < 0.5 do begin
                  fdata := fdata + fdata;
                  dec(exponent);
            end; (* while*)
            if(exponent< -4) then exponent:= -4;
            ans := ans or expbit[exponent];
          end
     else begin (* fdata > 0.5 *)
            while fdata > 0.93555 do begin
                  fdata := fdata / 2.0;
                  inc(exponent);
            end; (* while*)
            if(exponent>3) then exponent:= 3;
            ans := ans or expbit[exponent];
     end;
     if signbit <> 0 then ans:=ans or $80;   (* turn sign-bit on *)
     float2bin:=ans;   (* that is the bit pattern we want *)
end;
procedure doFADD(rans, r1, r2 : integer);
var v1,v2,ans: real; ansint:integer;
begin
     v1:=floatValue(cpu.REG[r1 mod $0f]);
     v2:=floatValue(cpu.REG[r2 mod $0f]);
     ans:= v1+v2;
     if ans > 7.5 then ans:=7.5;     (* overflow *)
     if ans < -7.5 then ans:= -7.5;  (* overflow *)
     ansint:= float2bin(ans);  (* convert to binary form *)
     cpu.REG[rans mod $0f] := ansint and $0ff;
end;
(***=========================================================***)
procedure execOneInst; (* EXECute ONE INSTruction *)
var tmpword,k,m: word;   firstget: boolean; (* flag for prompt *)
    tmpx,tmpy:Byte; (* for old cursor position *)
    sint1,sint2: shortint;
    tmpint,pc1,nch,errcode:integer;
    tmpstr6: string[6]; tmpch,tmpc1,tmpc2:char;
Label stopInput;
begin
    memAddrWin(-1);  (* direct CURSOR to MEMADDR window *)
    pc1:= (CPU.PC+1) mod MEMSize;
    (*Fetch the instruction, big endian format*)
    CPU.IR := (MEM[CPU.PC] SHL 8) OR (MEM[pc1] and $00ff);
    unasm(CPU.IR);  (* Decode the inst. in IR *)
    (* and then, advance PC to point to NEXT Instruction *)
    with CPU do begin PC:=PC+2; if PC >=MEMSize then PC:=PC mod MEMSize; end;
 (******* now, EXECute the instruction ******)
  with ALU do begin
    sint1:=CPU.REG[reg2] and $00ff;
    sint2:=CPU.REG[reg3] and $00ff;
    case opcode of
      0: ;   (* NOP *)
      1: CPU.REG[reg1] := MEM[addr] and $00FF;  (* Load r,[mem] *)
      2: CPU.REG[reg1] := addr and $00ff; (* LDI *)
      3: begin  (* Store *)
            MEM[addr] := CPU.REG[reg1] and $00ff;
            memdatawin(addr); (* show on MEMD Data Window *)
         end;
      4:  begin  (* move reg2, reg3 *)
              CPU.REG[reg3]:=CPU.REG[reg2];
          end;
      5:  begin  (* ADD reg1,reg2,reg3 *)
              tmpint:= integer(sint1 and $00ff) + integer(sint2 and $00ff);
              (*** cmdWindow('',1); Writeln(tmpint);  (**debug purpose*)
              CPU.Carry:=0; (* assume no carry *)
              if(tmpint and $0100) <> 0 then CPU.Carry:= 1;
              CPU.REG[reg1]:= tmpint and $00ff;
          end;
      6:  begin  (* FADD reg1,reg2,reg3 *)
              doFADD(reg1,reg2,reg3);
          end;
      7:  begin  (* OR reg1,reg2,reg3 *)
              tmpint:= integer(sint1) OR integer(sint2);
              CPU.REG[reg1]:= tmpint and $00ff;
          end;
      8:  begin  (* AND reg1,reg2,reg3 *)
              tmpint:= integer(sint1) AND integer(sint2);
              CPU.REG[reg1]:= tmpint and $00ff;
          end;
      9:  begin  (* XOR reg1,reg2,reg3 *)
              tmpint:= integer(sint1) XOR integer(sint2);
              CPU.REG[reg1]:= tmpint and $00ff;
          end;
      10:  begin   (* ROTate the reg1 Right reg3 bits *)
              tmpword:= CPU.REG[reg1];
              for k:=1 to reg3 do begin
                  m:= tmpword and 1;   (* right most bit *)
                  tmpword:= tmpword shr 1;
                  if(m=1) then tmpword:=tmpword or $80; (* high bit on *)
                  CPU.REG[reg1] := tmpword and $00ff;
              end;
          end;
      11: begin (* Branch to XY if Rr = R0 *)
             if(CPU.REG[reg1]=CPU.REG[0]) then CPU.PC:= addr mod MEMSize;
          end;
      12: CPU.SP:=0; (* Halt, clear the STACK *)
      13: begin   (* Input/Output *)
             HehitCTRLC:=false;
             case reg1 of
               0: begin (*GETC *)
                    showHint('waiting for one KEY',blink);
                    showCPU;   (* so that the "PC" looks correct *)
                    cmdWin2('',0); (* move cursor to cmd window *)
                    tmpc1:= myreadkey(tmpc2);
                    CPU.REG[0] := ord(tmpc1);
                    clearHint;
                  end;
               1: begin (*PUTC *)
                    cmdWindow( chr(CPU.REG[0] and $0ff), 0);
                  end;
               2: begin (*GETi *)
                    firstget:=true;
                    showCPU;
                    repeat
                       showHint('Waiting decimal integer',blink);
                       if not firstget then beep;
                       cmdWin2('',0);
                       tmpx:=cx1; tmpy:=cy1;
                       nch:= mygetline(cx1,cy1,1);
                       firstget:=false;
                       if(gotCTRLCwhenGetline)then goto stopInput;
                    until nch > 0;
                    val(str80,tmpint,errcode);
                    cpu.REG[0] := tmpint and $0ff;
                 stopInput:
                    clearHint;
(*                    cmdWin2('',0); gotoXY(tmpx,tmpy);
                    cmdWindow(str80,1);  *)
                  end;
               3: begin (*PUTi *)
                    str(integer(CPU.REG[0]), tmpstr6);
                    cmdWindow(' '+tmpstr6,0);
                  end;
               5: begin (*GETS *)
                    k:= addr mod MEMSize;
                    nch:=mygetline(cx1,cy1,1);  nch:=nch+1;  m:=1;
                    while nch > 1 do begin
                       MEM[k] := ord(str80[m]) and $0ff;
                       k:= (k+1) mod MEMSize;
                       inc(m); dec(nch);    (* m++, nch-- *)
                    end;
                    if nch=1 then MEM[k] := ord('$');
                  end;
               6: begin (*PutS *)
                    k:= addr mod MEMSize;
                    tmpch:= chr( MEM[k] and $0ff);
                    while tmpch <> '$' do begin
                       cmdWindow(tmpch,0);
                       k:= (k+1) mod MEMSize;
                       tmpch:= chr( MEM[k] and $0ff);
                    end; (* while *)
                  end;
             end;
          end;
      14: begin  (* LOAD F,zzXY  STORE F,zzXY, CALL xxXY, RETURN *)
             (* addr = reg1*256+ reg2*16 + reg3 *)
             case reg4 of
               0: begin (* LOAD F,zzXY *);
                     CPU.REG[15] := MEM[addr mod MEMSize] and $00ff;
                  end;
               1: begin  (*Store F,zzXY *)
                     MEM[addr mod MEMSize] := CPU.REG[15] and $00ff;
                  end;
               2: if(CPU.SP < STACKSize)then begin (* CALL zzXY *)
                     inc(CPU.sp); CPU.STACK[CPU.sp]:=CPU.PC; (*save PC *)
                     CPU.PC:= addr mod MEMSize;  (* goto addr *)
                  end;
               3: if(CPU.SP>0)then begin  (*RETurn *)
                     CPU.PC := CPU.STACK[CPU.SP];
                     dec(CPU.SP);
                     CPU.PC:= CPU.PC mod MEMSize;
                  end;
             end;
          end;    (* 15: *)
      15: begin  (* CMP/ JLT/JEQ/JGT *)
             (* addr = reg1*256+ reg2*16 + reg3 *)
             case reg4 of  (* sub-opcode is in reg4 *)
               0: begin (* CMP *);
                     sint1:= CPU.REG[reg2] and $00ff;
                     sint2:= CPU.REG[reg3] and $00ff;
                     CPU.temp :=  integer( sint1 - sint2 );
                  end;
               1: begin  (*JLT*);
                     if CPU.temp < 0 then CPU.PC:= addr mod MEMSize;
                  end;
               2: begin (*JEQ *);
                     if CPU.temp = 0 then CPU.PC:= addr mod MEMSize;
                  end;
               3: begin  (*JGT *)
                     if CPU.temp > 0 then CPU.PC:= addr mod MEMSize;
                  end;
             end;
          end;    (* 15: *)
    end; (* case*)
  end; (* with *)
    showCPU;
end;
(***=========================================================***)
(***===========INTERPRETER=======Execute the Program=========***)
procedure execute(mode:integer);
begin
   HehitCTRLC:=false;
   if(UpCase(OldCMD)<> 'T') then showCPU;
   if(mode <> 1) then    (*not Trace mode *)
       showHint('Hit ESCape to STOP...  ',Blink);
   While TRUE do begin
      execOneInst;  showTime;
      HeHitESCape:=myCheckESC; (* check Keyboard and process time *)
      if(HehitESCape)then Break;  (* leave for loop *) (* Break; *)
      if(gotCTRLCwhenGetline)then HehitCTRLC := true;   (* when GETi *)
      if(HehitCTRLC)then begin  (* this happen at input instructions *)
          HehitCTRLC:=false;
          Break;  (* leave for loop *) (* Break; *)
      end;
      if(mode=1) then Break;  (* Trace mode *) (* Break; *)
      if(CPU.IR and $F000) = $C000 then Break;   (* $C000 = Halt *)
      if(CPU.numbp>0)then begin
           (* use array if more break Points required *)
           if(CPU.PC=CPU.BP) then Break; (* Break; *)
      end;
      delay(delayTime);
   end;
   clearHint;
   if(mode<>1)then  begin   (* break, but not Trace mode *)
      int2hex(CPU.PC);      (* hex char will be in tmp4char *)
      showHint('break at '+copy(tmp4char,2,3)+'h',0);
   end;
end;
(***=========================================================***)
procedure doAssemble; (* Read Assembly program and Assemble it *)
begin
    beep; showHint('Not implemented yet!',0);
end;
(***=========================================================***)
procedure SaveMCimage;  (* Save Machine Code core image *)
begin
    beep; showHint('Not implemented yet!',0);
end;
(***=========================================================***)
procedure changeLogFile;    (* change the FileName of LOG File *)
 var nch,k:integer;
begin
(***    beep; showHint('Not implemented yet!',0); (**)
     showHint('Default extention is .LOG',0); (**)
     cmdWindow('new LOG_FileName:',0);
     nch:=mygetline(cx1,cy1,1);  (* get line into str80 *)
     if(nch>0)then begin
        if(pos('.',str80)=0)then str80 := str80+'.LOG';
        for k:=1 to nch do str80[k]:=UpCase(str80[k]);
     end; (* if nch > 0 *)  (*   cmdWindow(str80,1);  *) (* echo *)
     if(nch<=0) or not(str80[1] in ['A'..'Z','0'..'9']) then begin
       cmdWindow('Log Filename not changed',1);
       if(nch>0)then cmdWindow('Filename must begin with letter  or digit',1);
     end else begin (* seems be a good filenamr *)
       logFileName := str80;
       openLOG(logFileName); (* new OPEN will automatically CLOSE file opened*)
     end;
end;  (* changeLogFile *)
(***=========================================================***)
begin  (* MAIN Main main() *)
   psHr := 0; hCount := 0;
   toggleHorse := 1;
   myMessage := ' Are you going to Scarborough fair? ';
   myMessage := myMessage + ' Parsley, sage, rosemary and thyme,';
   myMessage := myMessage + ' Remember me to one who lives there.';
   myMessage := myMessage + ' For once.';
   myMessage := myMessage + ' ..  He was a true love of mine... ';
   sold:= 0;   (* for showTime *)
   setBackground;  (* set  BackGround color*)
   strBlank:= '                      '; (* blank*)
   cx1:=1; cy1:=1; cx2:=1;cy2:=1;  cx3:=1; cy3:=1;
   logFileName:=defaultLogName;
   openLOG(logFileName);
   initCPU;   
   hello;
   showCPU;   (* Initialize and Show status *)
  (*show mor CPU status at the FIRST *)
   str(delayTime,strInteger);
   cmdWindow('Current Delay=' + strInteger, 0);
   str(MEMSize,strInteger);
   cmdWindow(', MemorySize='+strInteger, 1);
(*** test hex2ch(date)
   for tmpint:=0 to 15 do cmdWindow(hex2ch(tmpint),0);
   readln; cmdWindow('',1);
***)
   showHint('H = Help I=Instructions',blink);
   While (TRUE) do begin  (* loop forever till Quit *)
      xtmp:=cx1; ytmp:=cy1;   (* used when illegal CMD *)
      tmpCMD:= OldCMD;    OldCMD:=CMD;
      cmdWindow('Yes> ',0);   CMD:=myReadKey(CMD2);
      if(CMD in ['?','H','h','i','I','G','g','T','t','L','l',
                 'P','p','B','b','C','c','F','f',
                 'E','e','U','u','a','A','S','s',
                 'K','k'
                 ]) then begin
                 clearHint;  cmdWindow(UpCase(CMD),1);
      end; (*if CMD *)
      case CMD of
        'Q','q':  begin
                      cmdWindow('Q',0);
                      cmdWin2('uit',0);  (* not in LOG file *)
                      cmdWindow('',1);  (* CR/LF *)
                      Break; (*Break;   Quit the system *)
                  end;
        '.',',','?':  toggleHorse := (1+toggleHorse) mod 6;
        'H','h','?':  showHelp;
        'I','i':  showInst;
        'X','x':  generateExample;
        'K','k':  showSTACK;
        'F','f':  changeLogFile;
        'G','g':  execute(0);
        'T','t':  execute(1);    (* trace mode *)
        'A','a':  doassemble;
        'B','b':  setBreakPoint;
        'C','c': begin cmdWindow('',0); clrscr; cx1:=1; cy1:=1; end;
        'E','e':  entermemory;
        'L','l':  LoadMachineCode; (* Load program in Machine Code form *)
        'Y','y','D','d',
        'N','n':  newShell; (* new DOS Shell *)
        'S','s':  SaveMCimage; (* save Machine Code *)
        'P','p':  setPC;
        'R','r':  RegisterModify;
        'U','u':  doUnassemble;
        '+','-','=','\':  begin  clearHint;
           if (CMD='+') or (CMD='\') then begin
              if delayTime > 990 then delayTime:=delayTime-250
              else if delayTime > 90 then delayTime:=delayTime-50
              else if delayTime > 10 then delayTime:=delayTime-10
              else if delayTime > 2  then delayTime:=delayTime-1;
           end;
           if CMD='-'then  begin
              if delayTime < 50  then delayTime:=delayTime+10
              else if delayTime < 888 then delayTime:=delayTime+50
              else if delayTime < 8888 then delayTime:=delayTime+250;
           end;
           str(delayTime,strInteger);
           cmdWindow(CMD+'  Delay='+strInteger, 0);
           if CMD='=' then begin
              str(MEMSize,strInteger);
              cmdWindow(', MemorySize='+strInteger, 0);
           end;
           cmdWindow('',1);  (* CR/LF *)
                  end;
        'M','m': begin  (* toggle Memory Size *)
           MEMSize:= MSLarge+MSSmall - MEMSize;
           str(MEMSize,strInteger);   clearHint; showCPU;
           cmdWindow(CMD+'  now Memory Size='+strInteger, 1);
                 end;
        else
            begin sound(444); showHint('H  for Help,  Q to Quit',Blink);
               delay(49); nosound;
               cx1:=xtmp; cy1:=ytmp; CMD:= tmpCMD; (* ignore err cmd *)
            end;
      end;  (* case CMD *)
   end; (* while TRUE *)
(*byebye: *)
   cmdWindow('',1);    (* move cursor to command window *)
   textcolor(LightRED); (* tell him LOG Filename in RED color *)
   Writeln('Log file is '+LogFileName);   (* donot call cmdWin... *)
   cmdWin2('',1);
   textcolor(w1color);  (* change color back to color for this window *)
   cmdWindow('Thank you for using SISC!',0);
   sound(660); Delay(200);   sound(550); delay(200);
   cmdWindow('',1);   nosound;
   Close(FLOG); (* close LOG file *)
   cmdWin2('Hit Return Key...',0); waitRETURNKEY;
   window(1,1,80,25); TextBackground(Black);  TextColor(2); clrScr;
   Writeln('Your running LOG is in ',logFileName);
   clrscr; nosound;
   NormVideo;
   clrscr; nosound;
      SwapVectors;
      Exec(GetEnv('COMSPEC'), '/C ' + 'MODE');
      SwapVectors;
end.
