//sortVec6.cpp  -- by tsaiwn@csie.nctu.edu.tw
//test using vector, sort( ) in STL, with compare function
#include <vector>
#include <iostream>
#include <algorithm>
#include<string>
#include<string.h>
using namespace std;
string xx[ ] = { "aaa", "hello", "DDT", "bad", "california", "BBS" };
int nn[ ]={ 55, 38, 49, 88, 58 };
double yy[ ]={ 3.8, 4.9, 2, 58, 8.5 };
vector<string> x(xx, xx+sizeof xx/sizeof xx[0]);   // `NΪk
vector<int> vn(nn, nn+sizeof nn/sizeof nn[0]);
vector<double> vy(yy, yy+sizeof yy/sizeof yy[0]);
//
template<class T> void print(vector<T> y) {
   for(int i=0; i< y.size( ); ++i) cout << y[i] << ", ";
   cout << endl;
}
//compare functions for later use (C++ STL uses bool functions)
bool comp(const string&a, const string&b) { return b < a; }
bool comp22(const string&a, const string&b) {
   const char *aa, *bb;  // should be const for pointing to c_str( )
   char *pa, *pb;
   aa = a.c_str( ); bb = b.c_str( );    // convert to C string
   //aa[0] = 58; // error because that aa[ ] is const
   pa= (char*)malloc(1+ strlen(aa)); pb=(char*) malloc(1+strlen(bb));
   strcpy (pa, aa);  strcpy(pb, bb);
   for(int i=0; i< strlen(pa); ++i) pa[i] = toupper(pa[i]);
   for(int i=0; i< strlen(pb); ++i) pb[i] = toupper(pb[i]);
   // all convert into Upper case; i.e., ignore Case
   return strcmp(pa, pb) < 0;    // use C Lib function strcmp( )
} // comp22(      // compare Ignore Case
//bool comp33(const string&a, const string&b) {
bool comp33(string a, string b) {
  static string s1, s2;
  s1 = a, s2 = b;
  for(int i=0; i< s1.size( ); ++i) s1[i] = toupper(s1[i]);
  for(int i=0; i< s2.size( ); ++i) s2[i] = toupper(s2[i]);
  return s1 > s2;    // OK for C++ string
}// comp33(
int main( ) {
  cout << "x: "; print(x);
  sort(x.begin( ), x.end( )); cout <<" after sort x: "; print(x);
  sort(x.begin(), x.end(), comp);  
  cout << " after sort with comp: ";  print(x);
  cout << "===sort using comp22; Ignore letter case" << endl;
  sort(x.begin(), x.end(), comp22);  print(x);
  cout << "===sort using comp33" << endl; 
  sort(x.begin(), x.end(), comp33);  print(x);
  cout << "vn: "; print(vn);
  sort(vn.begin( ), vn.end( ) );
  cout << "after sort vn: "; print(vn);
  cout << "vy: "; print(vy);  sort(vy.begin( ), vy.end( ) );
  cout << "after sort vy: "; print(vy);
  return 0;
}// main(
/******
C:\testc>g++ sortVec6.cpp
C:\testc>a
x: aaa, hello, DDT, bad, california, BBS,
 after sort x: BBS, DDT, aaa, bad, california, hello,
 after sort with comp: hello, california, bad, aaa, DDT, BBS,
===sort using comp22; Ignore letter case
aaa, bad, BBS, california, DDT, hello,
===sort using comp33
hello, DDT, california, BBS, bad, aaa,
vn: 55, 38, 49, 88, 58,
after sort vn: 38, 49, 55, 58, 88,
vy: 3.8, 4.9, 2, 58, 8.5,
after sort vy: 2, 3.8, 4.9, 8.5, 58,
***************************************************/
