//sortVec3.java  --- sorting Vector again,  with Comparator
//@CopyLeft by tsaiwn@csie.nctu.edu.tw
//In Java you should use Collections.sort( ) to sort a Vector
import java.util.*;
class sortVec3 {   java.io.PrintStream cout = System.out;
   public static void main(String xx[ ]) { new sortVec3( ); }
   sortVec3( ) {  main( ); }

 Sorter myObject = new Sorter( );  // this is a Comparator Object

 //template function to print Vector of any type 
 <T>void printV(Vector<T> aVector) {
   //Vector<int>::iterator it;
   Iterator<T> it = aVector.iterator( );  // Java
   cout.print("\n Vector contains:");    // print out content:
   for ( ; it.hasNext( ); ) cout.print(" "+  it.next( ) );
   cout.println( );
 }// printV(

int main ( ) {
  Integer myints[ ] = {32,71,12,45,26,80,53,33};   // Note Integer
  Vector<Integer> myVector = new Vector<Integer>(Arrays.asList(myints) ); 
        //Java Vector constructor accepts Collection, but NOT array
        //However, C++ STL vector do accepts array; see sortVec3.cpp
  printV(myVector);

  // using default comparison (operator< ):
  //sort(myVector.begin( ), myVector.end( ));   // C++ STL
  Collections.sort(myVector);    // must sort ALL data in Vector 
  /// in Java, Vector is NOT an array and can NOT use Arrays.sort( )
  printV(myVector);

  //sort(myVector.begin()+4, myVector.end(), compare); 
  // in C++ we can use compare function to sort part of the array
  /// Java must sort ALL, and Java can NOT pass compare function
  Soppp compare = new Soppp( );   // a Comparator Object
  Collections.sort(myVector,     // Java must sort whole Collection 
          Collections.reverseOrder(compare));  // note the Comparator
  printV(myVector);

  // using an Object as comparator       //(12 26 32 33 45 53 71 80)
  //sort(myVector.begin(), myVector.end(), myObject); 
  Collections.sort(myVector, myObject);
  printV(myVector);
  cout.print("Now sort all data with comp222 ...\n");
  //sort(myVector.begin( ), myVector.end( ), comp222);   // C++ STL
  Sotr2<Integer> comp222 = new Sotr2<Integer>( ); 
      //Note that Java can NOT pass compare function
  Collections.sort(myVector, comp222);    // comp222 is a Comparator here
  printV(myVector);

  Double y[ ]={3.8, 4.9, 2.5, 40.0, 55.0};
  Vector<Double> vd = new Vector<Double>(Arrays.asList(y));
  cout.print(" Vector of Double vd: "); printV(vd);
  Sotr2<Double> comp333 = new Sotr2<Double>( ); 
  //sort(vd.begin( ), vd.end( ), (bool(*)(double,double))comp222);
  Collections.sort(vd, comp333);   // comp333 is a Comparator<Double>
  cout.print(" after sort vd: "); printV(vd);
  return 0;
}//main(
 // the following defines a Comparator class "Sorter"
 class Sorter implements Comparator<Integer> { 
   //bool operator( ) (int i,int j) { cout << " S "; return (i<j);}
   public int compare(Integer i,Integer j) { 
      System.out.print(" S "); 
      return (i-j);    // auto unbox
   }
 }   // class Sorter : a Comparator
}// class
class Soppp implements Comparator<Integer> { 
   //bool compare (int i,int j) { cout << " ha "; return (i<j); }
  public int compare(Integer i,Integer j) { System.out.print(" ha "); 
      return i.compareTo(j);   //return (i-j);   // auto unbox
  } // Ascending
}// class Soppp
class Sotr2<T> implements Comparator<T> { 
   //bool comp222(int i,int j) { cout << " C "; return (j<i); } //Descending
  public int compare(T i,T j) {  System.out.print(" C "); 
     //return (j-i);     // auto unbox
     //return j.compareTo(i);
     //Comparable a = (Comparable<T>) i;
     return ((Comparable<T>)j).compareTo( i );
  } //Descending
}//Sotr2
/******
D:\COURSE\OOP\ppnt>javac sortVec3.java
Note: sortVec3.java uses unchecked or unsafe operations.
Note: Recompile with -Xlint:unchecked for details.

D:\COURSE\OOP\ppnt>java sortVec3

 Vector contains: 32 71 12 45 26 80 53 33

 Vector contains: 12 26 32 33 45 53 71 80
 ha  ha  ha  ha  ha  ha  ha  ha  ha  ha  ha  ha  ha  ha  ha  ha  ha
 Vector contains: 80 71 53 45 33 32 26 12
 S  S  S  S  S  S  S  S  S  S  S  S  S  S  S  S  S
 Vector contains: 12 26 32 33 45 53 71 80
Now sort all data with comp222 ...
 C  C  C  C  C  C  C  C  C  C  C  C  C  C  C  C  C
 Vector contains: 80 71 53 45 33 32 26 12
 Vector of Double vd:
 Vector contains: 3.8 4.9 2.5 40.0 55.0
 C  C  C  C  C  C  C  C  C  after sort vd:
 Vector contains: 55.0 40.0 4.9 3.8 2.5

D:\COURSE\OOP\ppnt>
**********************/
