/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.shared.target;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.internal.core.target.IUBundleContainer;
import org.eclipse.pde.internal.core.target.TargetDefinition;
import org.eclipse.pde.internal.core.target.provisional.IBundleContainer;
import org.eclipse.pde.internal.core.target.provisional.IResolvedBundle;
import org.eclipse.pde.internal.core.target.provisional.ITargetDefinition;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.shared.target.AddBundleContainerWizard;
import org.eclipse.pde.internal.ui.shared.target.EditBundleContainerWizard;
import org.eclipse.pde.internal.ui.shared.target.ITargetChangedListener;
import org.eclipse.pde.internal.ui.shared.target.Messages;
import org.eclipse.pde.internal.ui.shared.target.StyledBundleLabelProvider;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class TargetLocationsGroup {
    private TreeViewer fTreeViewer;
    private Button fAddButton;
    private Button fEditButton;
    private Button fRemoveButton;
    private Button fShowContentButton;
    private ITargetDefinition fTarget;
    private ListenerList fChangeListeners = new ListenerList();

    public static TargetLocationsGroup createInForm(Composite parent, FormToolkit toolkit) {
        TargetLocationsGroup contentTable = new TargetLocationsGroup();
        contentTable.createFormContents(parent, toolkit);
        return contentTable;
    }

    public static TargetLocationsGroup createInDialog(Composite parent) {
        TargetLocationsGroup contentTable = new TargetLocationsGroup();
        contentTable.createDialogContents(parent);
        return contentTable;
    }

    private TargetLocationsGroup() {
    }

    public void addTargetChangedListener(ITargetChangedListener listener) {
        this.fChangeListeners.add((Object)listener);
    }

    private void createFormContents(Composite parent, FormToolkit toolkit) {
        Composite comp = toolkit.createComposite(parent);
        comp.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 2));
        comp.setLayoutData((Object)new GridData(1808));
        Tree atree = toolkit.createTree(comp, 770);
        atree.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(1808);
        atree.setLayoutData((Object)gd);
        atree.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127 && TargetLocationsGroup.this.fRemoveButton.getEnabled()) {
                    TargetLocationsGroup.this.handleRemove();
                }
            }
        });
        Composite buttonComp = toolkit.createComposite(comp);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonComp.setLayout((Layout)layout);
        buttonComp.setLayoutData((Object)new GridData(1040));
        this.fAddButton = toolkit.createButton(buttonComp, Messages.BundleContainerTable_0, 8);
        this.fEditButton = toolkit.createButton(buttonComp, Messages.BundleContainerTable_1, 8);
        this.fRemoveButton = toolkit.createButton(buttonComp, Messages.BundleContainerTable_2, 8);
        this.fShowContentButton = toolkit.createButton(comp, Messages.TargetLocationsGroup_1, 32);
        this.initializeTreeViewer(atree);
        this.initializeButtons();
        toolkit.paintBordersFor(comp);
    }

    private void createDialogContents(Composite parent) {
        Composite comp = SWTFactory.createComposite(parent, 2, 1, 1808, 0, 0);
        Tree atree = new Tree(comp, 2818);
        atree.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(1808);
        gd.widthHint = 200;
        atree.setLayoutData((Object)gd);
        atree.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127 && TargetLocationsGroup.this.fRemoveButton.getEnabled()) {
                    TargetLocationsGroup.this.handleRemove();
                }
            }
        });
        Composite buttonComp = SWTFactory.createComposite(comp, 2, 1, 1808);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonComp.setLayout((Layout)layout);
        buttonComp.setLayoutData((Object)new GridData(1040));
        this.fAddButton = SWTFactory.createPushButton(buttonComp, Messages.BundleContainerTable_0, null);
        this.fEditButton = SWTFactory.createPushButton(buttonComp, Messages.BundleContainerTable_1, null);
        this.fRemoveButton = SWTFactory.createPushButton(buttonComp, Messages.BundleContainerTable_2, null);
        this.fShowContentButton = SWTFactory.createCheckButton(comp, Messages.TargetLocationsGroup_1, null, false, 2);
        this.initializeTreeViewer(atree);
        this.initializeButtons();
    }

    private void initializeTreeViewer(Tree tree) {
        this.fTreeViewer = new TreeViewer(tree);
        this.fTreeViewer.setContentProvider((IContentProvider)new BundleContainerContentProvider());
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new StyledBundleLabelProvider(true, false));
        this.fTreeViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof IStatus && !(e2 instanceof IStatus)) {
                    return 1;
                }
                if (e2 instanceof IStatus && !(e1 instanceof IStatus)) {
                    return -1;
                }
                return super.compare(viewer, e1, e2);
            }
        });
        this.fTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TargetLocationsGroup.this.updateButtons();
            }
        });
        this.fTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!event.getSelection().isEmpty()) {
                    TargetLocationsGroup.this.handleEdit();
                }
            }
        });
        this.fTreeViewer.setAutoExpandLevel(-1);
    }

    private void initializeButtons() {
        this.fAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetLocationsGroup.this.handleAdd();
            }
        });
        this.fAddButton.setLayoutData((Object)new GridData());
        SWTFactory.setButtonDimensionHint(this.fAddButton);
        this.fEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetLocationsGroup.this.handleEdit();
            }
        });
        this.fEditButton.setLayoutData((Object)new GridData());
        this.fEditButton.setEnabled(false);
        SWTFactory.setButtonDimensionHint(this.fEditButton);
        this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetLocationsGroup.this.handleRemove();
            }
        });
        this.fRemoveButton.setLayoutData((Object)new GridData());
        this.fRemoveButton.setEnabled(false);
        SWTFactory.setButtonDimensionHint(this.fRemoveButton);
        this.fShowContentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetLocationsGroup.this.fTreeViewer.refresh();
                TargetLocationsGroup.this.fTreeViewer.expandAll();
            }
        });
        this.fShowContentButton.setLayoutData((Object)new GridData());
        SWTFactory.setButtonDimensionHint(this.fShowContentButton);
    }

    public void setInput(ITargetDefinition target) {
        this.fTarget = target;
        this.fTreeViewer.setInput((Object)this.fTarget);
        this.updateButtons();
    }

    private void handleAdd() {
        AddBundleContainerWizard wizard = new AddBundleContainerWizard(this.fTarget);
        Shell parent = this.fTreeViewer.getTree().getShell();
        WizardDialog dialog = new WizardDialog(parent, (IWizard)wizard);
        if (dialog.open() != 1) {
            this.contentsChanged(false);
            this.fTreeViewer.refresh();
            this.updateButtons();
        }
    }

    private void handleEdit() {
        IStructuredSelection selection = (IStructuredSelection)this.fTreeViewer.getSelection();
        if (!selection.isEmpty()) {
            IBundleContainer newContainer;
            EditBundleContainerWizard wizard;
            Shell parent;
            WizardDialog dialog;
            Object parent2;
            TreeItem[] treeSelection;
            Object selected = selection.getFirstElement();
            IBundleContainer oldContainer = null;
            if (selected instanceof IBundleContainer) {
                oldContainer = (IBundleContainer)selected;
            } else if (selected instanceof IUWrapper) {
                oldContainer = ((IUWrapper)selected).getParent();
            } else if (selected instanceof IResolvedBundle && (treeSelection = this.fTreeViewer.getTree().getSelection()).length > 0 && (parent2 = treeSelection[0].getParentItem().getData()) instanceof IBundleContainer) {
                oldContainer = (IBundleContainer)parent2;
            }
            if (oldContainer != null && (dialog = new WizardDialog(parent = this.fTreeViewer.getTree().getShell(), (IWizard)(wizard = new EditBundleContainerWizard(this.fTarget, oldContainer)))).open() == 0 && (newContainer = wizard.getBundleContainer()) != null) {
                IBundleContainer[] containers = this.fTarget.getBundleContainers();
                ArrayList<IBundleContainer> newContainers = new ArrayList<IBundleContainer>(containers.length);
                int i = 0;
                while (i < containers.length) {
                    if (!containers[i].equals(oldContainer)) {
                        newContainers.add(containers[i]);
                    }
                    ++i;
                }
                newContainers.add(newContainer);
                this.fTarget.setBundleContainers(newContainers.toArray(new IBundleContainer[newContainers.size()]));
                this.contentsChanged(false);
                this.fTreeViewer.refresh();
                this.updateButtons();
                this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)newContainer), true);
            }
        }
    }

    private void handleRemove() {
        IStructuredSelection selection = (IStructuredSelection)this.fTreeViewer.getSelection();
        IBundleContainer[] containers = this.fTarget.getBundleContainers();
        if (!selection.isEmpty() && containers != null && containers.length > 0) {
            ArrayList toRemove = new ArrayList();
            boolean removedSite = false;
            boolean removedContainer = false;
            Iterator iterator = selection.iterator();
            while (iterator.hasNext()) {
                Object currentSelection = iterator.next();
                if (currentSelection instanceof IBundleContainer) {
                    if (currentSelection instanceof IUBundleContainer) {
                        removedSite = true;
                    }
                    removedContainer = true;
                    toRemove.add(currentSelection);
                }
                if (!(currentSelection instanceof IUWrapper)) continue;
                toRemove.add(currentSelection);
            }
            if (removedContainer) {
                HashSet<IBundleContainer> newContainers = new HashSet<IBundleContainer>();
                newContainers.addAll(Arrays.asList(this.fTarget.getBundleContainers()));
                newContainers.removeAll(toRemove);
                if (newContainers.size() > 0) {
                    this.fTarget.setBundleContainers(newContainers.toArray(new IBundleContainer[newContainers.size()]));
                } else {
                    this.fTarget.setBundleContainers(null);
                }
                this.contentsChanged(removedSite);
                this.fTreeViewer.refresh(false);
                this.updateButtons();
            } else {
                iterator = toRemove.iterator();
                while (iterator.hasNext()) {
                    Object current = iterator.next();
                    if (!(current instanceof IUWrapper)) continue;
                    ((IUWrapper)current).getParent().removeInstallableUnit(((IUWrapper)current).getIU());
                }
                this.contentsChanged(removedSite);
                this.fTreeViewer.refresh(true);
                this.updateButtons();
            }
        }
    }

    private void updateButtons() {
        IStructuredSelection selection = (IStructuredSelection)this.fTreeViewer.getSelection();
        this.fEditButton.setEnabled(!selection.isEmpty() && (selection.getFirstElement() instanceof IBundleContainer || selection.getFirstElement() instanceof IUWrapper));
        boolean removeAllowed = false;
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object current = iter.next();
            if (current instanceof IBundleContainer) {
                removeAllowed = true;
                break;
            }
            if (!(current instanceof IUWrapper)) continue;
            removeAllowed = true;
            break;
        }
        this.fRemoveButton.setEnabled(removeAllowed);
    }

    private void contentsChanged(boolean force) {
        Object[] listeners = this.fChangeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ITargetChangedListener)listeners[i]).contentsChanged(this.fTarget, this, true, force);
            ++i;
        }
    }

    class BundleContainerContentProvider
    implements ITreeContentProvider {
        BundleContainerContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ITargetDefinition) {
                IBundleContainer[] containers = ((ITargetDefinition)parentElement).getBundleContainers();
                return containers != null ? containers : new Object[]{};
            }
            if (parentElement instanceof IBundleContainer) {
                IBundleContainer container = (IBundleContainer)parentElement;
                if (container.isResolved()) {
                    IStatus status = container.getStatus();
                    if (!status.isOK() && !status.isMultiStatus()) {
                        return new Object[]{status};
                    }
                    if (TargetLocationsGroup.this.fShowContentButton.getSelection()) {
                        return container.getBundles();
                    }
                    if (!status.isOK()) {
                        if (status.isMultiStatus()) {
                            return status.getChildren();
                        }
                    } else if (parentElement instanceof IUBundleContainer) {
                        try {
                            IProfile profile = ((TargetDefinition)TargetLocationsGroup.this.fTarget).getProfile();
                            IInstallableUnit[] units = ((IUBundleContainer)parentElement).getInstallableUnits(profile);
                            ArrayList<IUWrapper> wrappedUnits = new ArrayList<IUWrapper>(units.length);
                            int i = 0;
                            while (i < units.length) {
                                wrappedUnits.add(new IUWrapper(units[i], (IUBundleContainer)parentElement));
                                ++i;
                            }
                            return wrappedUnits.toArray();
                        }
                        catch (CoreException e) {
                            return new Object[]{e.getStatus()};
                        }
                    }
                }
            } else if (parentElement instanceof MultiStatus) {
                return ((MultiStatus)parentElement).getChildren();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof IUWrapper) {
                return ((IUWrapper)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof ITargetDefinition) {
                IStatus status;
                boolean hasContainerStatus = false;
                ArrayList<Object> result = new ArrayList<Object>();
                IBundleContainer[] containers = ((ITargetDefinition)inputElement).getBundleContainers();
                if (containers != null) {
                    int i = 0;
                    while (i < containers.length) {
                        result.add(containers[i]);
                        if (containers[i].getStatus() != null && !containers[i].getStatus().isOK()) {
                            hasContainerStatus = true;
                        }
                        ++i;
                    }
                }
                if (!hasContainerStatus && (status = ((ITargetDefinition)inputElement).getBundleStatus()) != null && !status.isOK()) {
                    result.add(status);
                }
                return result.toArray();
            }
            if (inputElement instanceof String) {
                return new Object[]{inputElement};
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class IUWrapper {
        private IInstallableUnit fIU;
        private IUBundleContainer fParent;

        public IUWrapper(IInstallableUnit unit, IUBundleContainer parent) {
            this.fIU = unit;
            this.fParent = parent;
        }

        public IInstallableUnit getIU() {
            return this.fIU;
        }

        public IUBundleContainer getParent() {
            return this.fParent;
        }
    }
}

