/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.product;

import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.iproduct.IArgumentsInfo;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ArgumentsSection
extends PDESection {
    private static final String[] TAB_LABELS = new String[5];
    private FormEntry fVMArgs;
    private FormEntry fProgramArgs;
    private CTabFolder fTabFolder;
    private int fLastTab;

    static {
        ArgumentsSection.TAB_LABELS[0] = PDEUIMessages.ArgumentsSection_allPlatforms;
        ArgumentsSection.TAB_LABELS[1] = "linux";
        ArgumentsSection.TAB_LABELS[2] = "macosx";
        ArgumentsSection.TAB_LABELS[3] = "solaris";
        ArgumentsSection.TAB_LABELS[4] = "win32";
    }

    public ArgumentsSection(PDEFormPage page, Composite parent) {
        super(page, parent, 128);
        this.createClient(this.getSection(), page.getEditor().getToolkit());
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        GridData data = new GridData(1808);
        section.setLayoutData((Object)data);
        section.setText(PDEUIMessages.ArgumentsSection_title);
        section.setDescription(PDEUIMessages.ArgumentsSection_desc);
        Composite client = toolkit.createComposite((Composite)section);
        client.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 1));
        client.setLayoutData((Object)new GridData(1808));
        this.fTabFolder = new CTabFolder(client, 0x800080);
        toolkit.adapt((Control)this.fTabFolder, true, true);
        GridData gd = new GridData(256);
        this.fTabFolder.setLayoutData((Object)gd);
        gd.heightHint = 2;
        toolkit.getColors().initializeSectionToolBarColors();
        Color selectedColor = toolkit.getColors().getColor("org.eclipse.ui.forms.TB_BG");
        this.fTabFolder.setSelectionBackground(new Color[]{selectedColor, toolkit.getColors().getBackground()}, new int[]{100}, true);
        this.fTabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ArgumentsSection.this.fProgramArgs.isDirty()) {
                    ArgumentsSection.this.fProgramArgs.commit();
                }
                if (ArgumentsSection.this.fVMArgs.isDirty()) {
                    ArgumentsSection.this.fVMArgs.commit();
                }
                ArgumentsSection.this.refresh();
            }
        });
        this.fTabFolder.setUnselectedImageVisible(false);
        IActionBars actionBars = this.getPage().getPDEEditor().getEditorSite().getActionBars();
        this.fProgramArgs = new FormEntry(client, toolkit, PDEUIMessages.ArgumentsSection_program, 66);
        this.fProgramArgs.getText().setLayoutData((Object)new GridData(1808));
        this.fProgramArgs.setFormEntryListener(new FormEntryAdapter(this, actionBars){

            public void textValueChanged(FormEntry entry) {
                IArgumentsInfo info = ArgumentsSection.this.getLauncherArguments();
                info.setProgramArguments(entry.getValue().trim(), ArgumentsSection.this.fLastTab);
            }
        });
        this.fProgramArgs.setEditable(this.isEditable());
        this.fVMArgs = new FormEntry(client, toolkit, PDEUIMessages.ArgumentsSection_vm, 66);
        this.fVMArgs.getText().setLayoutData((Object)new GridData(1808));
        this.fVMArgs.setFormEntryListener(new FormEntryAdapter(this, actionBars){

            public void textValueChanged(FormEntry entry) {
                IArgumentsInfo info = ArgumentsSection.this.getLauncherArguments();
                info.setVMArguments(entry.getValue().trim(), ArgumentsSection.this.fLastTab);
            }
        });
        this.fVMArgs.setEditable(this.isEditable());
        this.createTabs();
        toolkit.paintBordersFor(client);
        section.setClient((Control)client);
        this.getModel().addModelChangedListener((IModelChangedListener)this);
    }

    private void createTabs() {
        int i = 0;
        while (i < TAB_LABELS.length) {
            CTabItem item = new CTabItem(this.fTabFolder, 0);
            item.setText(TAB_LABELS[i]);
            item.setImage(PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_OPERATING_SYSTEM_OBJ));
            ++i;
        }
        this.fLastTab = 0;
        this.fTabFolder.setSelection(this.fLastTab);
    }

    public void refresh() {
        this.fLastTab = this.fTabFolder.getSelectionIndex();
        this.fProgramArgs.setValue(this.getLauncherArguments().getProgramArguments(this.fLastTab), true);
        this.fVMArgs.setValue(this.getLauncherArguments().getVMArguments(this.fLastTab), true);
        super.refresh();
    }

    public void commit(boolean onSave) {
        this.fProgramArgs.commit();
        this.fVMArgs.commit();
        super.commit(onSave);
    }

    public void cancelEdit() {
        this.fProgramArgs.cancelEdit();
        this.fVMArgs.cancelEdit();
        super.cancelEdit();
    }

    private IArgumentsInfo getLauncherArguments() {
        IArgumentsInfo info = this.getProduct().getLauncherArguments();
        if (info == null) {
            info = this.getModel().getFactory().createLauncherArguments();
            this.getProduct().setLauncherArguments(info);
        }
        return info;
    }

    private IProduct getProduct() {
        return this.getModel().getProduct();
    }

    private IProductModel getModel() {
        return (IProductModel)this.getPage().getPDEEditor().getAggregateModel();
    }

    public boolean canPaste(Clipboard clipboard) {
        Display d = this.getSection().getDisplay();
        return d.getFocusControl() instanceof Text;
    }

    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.handleModelEventWorldChanged(e);
        }
    }

    private void handleModelEventWorldChanged(IModelChangedEvent event) {
        this.refresh();
    }

    public void dispose() {
        IProductModel model = this.getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }
}

