/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ModelEntry;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.DependencyManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDEPreferencesManager;
import org.eclipse.pde.internal.launching.launcher.BundleLauncherHelper;
import org.eclipse.pde.internal.launching.launcher.LaunchValidationOperation;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.elements.NamedElement;
import org.eclipse.pde.internal.ui.launcher.FilteredCheckboxTree;
import org.eclipse.pde.internal.ui.launcher.PluginStatusDialog;
import org.eclipse.pde.internal.ui.util.PersistablePluginObject;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.util.SourcePluginFilter;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.pde.ui.launcher.AbstractLauncherTab;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;
import org.eclipse.ui.dialogs.PatternFilter;

public abstract class AbstractPluginBlock {
    protected AbstractLauncherTab fTab;
    private FilteredCheckboxTree fPluginFilteredTree;
    protected CheckboxTreeViewer fPluginTreeViewer;
    protected NamedElement fWorkspacePlugins;
    protected NamedElement fExternalPlugins;
    private IPluginModelBase[] fExternalModels;
    private IPluginModelBase[] fWorkspaceModels;
    protected int fNumExternalChecked;
    protected int fNumWorkspaceChecked;
    private Button fIncludeOptionalButton;
    protected Button fAddWorkspaceButton;
    private Button fAutoValidate;
    private Button fSelectAllButton;
    private Button fDeselectButton;
    private Button fWorkingSetButton;
    private Button fAddRequiredButton;
    private Button fDefaultsButton;
    private Button fFilterButton;
    private Listener fListener = new Listener();
    private Label fCounter;
    private LaunchValidationOperation fOperation;
    private Button fValidateButton;
    private boolean viewerEnabled = true;
    private HashMap levelColumnCache = new HashMap();
    private HashMap autoColumnCache = new HashMap();
    private TreeEditor levelColumnEditor = null;
    private TreeEditor autoColumnEditor = null;
    private boolean fIsDisposed = false;
    private PluginStatusDialog fDialog;

    public AbstractPluginBlock(AbstractLauncherTab tab) {
        this.fTab = tab;
        PDEPlugin.getDefault().getLabelProvider().connect(this);
    }

    protected IPluginModelBase[] getExternalModels() {
        if (this.fExternalModels == null) {
            PDEPreferencesManager pref = PDECore.getDefault().getPreferencesManager();
            String saved = pref.getString("checkedPlugins");
            if (saved.equals("[savedNone]")) {
                this.fExternalModels = new IPluginModelBase[0];
                return this.fExternalModels;
            }
            IPluginModelBase[] models = PluginRegistry.getExternalModels();
            if (saved.equals("[savedAll]")) {
                this.fExternalModels = models;
                return this.fExternalModels;
            }
            ArrayList<IPluginModelBase> list = new ArrayList<IPluginModelBase>(models.length);
            int i = 0;
            while (i < models.length) {
                if (models[i].isEnabled()) {
                    list.add(models[i]);
                }
                ++i;
            }
            this.fExternalModels = list.toArray(new IPluginModelBase[list.size()]);
        }
        return this.fExternalModels;
    }

    protected IPluginModelBase[] getWorkspaceModels() {
        if (this.fWorkspaceModels == null) {
            IPluginModelBase[] models = PluginRegistry.getWorkspaceModels();
            ArrayList<IPluginModelBase> list = new ArrayList<IPluginModelBase>(models.length);
            int i = 0;
            while (i < models.length) {
                if (models[i].getBundleDescription() != null) {
                    list.add(models[i]);
                }
                ++i;
            }
            this.fWorkspaceModels = list.toArray(new IPluginModelBase[list.size()]);
        }
        return this.fWorkspaceModels;
    }

    protected void updateCounter() {
        if (this.fCounter != null) {
            int checked = this.fNumExternalChecked + this.fNumWorkspaceChecked;
            int total = this.getWorkspaceModels().length + this.getExternalModels().length;
            this.fCounter.setText(NLS.bind((String)PDEUIMessages.AbstractPluginBlock_counter, (Object)new Integer(checked), (Object)new Integer(total)));
        }
    }

    public void createControl(Composite parent, int span, int indent) {
        this.createPluginViewer(parent, span - 1, indent);
        this.createButtonContainer(parent, this.fPluginFilteredTree.getTreeLocationOffset());
        this.fIncludeOptionalButton = this.createButton(parent, span, indent, NLS.bind((String)PDEUIMessages.AdvancedLauncherTab_includeOptional, (Object)this.fTab.getName().toLowerCase(Locale.ENGLISH)));
        this.fAddWorkspaceButton = this.createButton(parent, span, indent, NLS.bind((String)PDEUIMessages.AdvancedLauncherTab_addNew, (Object)this.fTab.getName().toLowerCase(Locale.ENGLISH)));
        GridData gd = new GridData(768);
        gd.horizontalSpan = span;
        Label label = new Label(parent, 258);
        label.setLayoutData((Object)gd);
        this.fAutoValidate = this.createButton(parent, span - 1, indent, NLS.bind((String)PDEUIMessages.PluginsTabToolBar_auto_validate, (Object)this.fTab.getName().replaceAll("&", "").toLowerCase(Locale.ENGLISH)));
        this.fValidateButton = new Button(parent, 8);
        this.fValidateButton.setLayoutData((Object)new GridData(128));
        this.fValidateButton.setText(NLS.bind((String)PDEUIMessages.PluginsTabToolBar_validate, (Object)this.fTab.getName().replaceAll("&", "")));
        SWTUtil.setButtonDimensionHint(this.fValidateButton);
        this.fValidateButton.addSelectionListener((SelectionListener)this.fListener);
    }

    private Button createButton(Composite parent, int span, int indent, String text) {
        Button button = new Button(parent, 32);
        button.setText(text);
        GridData gd = new GridData();
        gd.horizontalSpan = span;
        gd.horizontalIndent = indent;
        button.setLayoutData((Object)gd);
        button.addSelectionListener((SelectionListener)this.fListener);
        button.setFont(parent.getFont());
        return button;
    }

    protected ILabelProvider getLabelProvider() {
        return new OSGiLabelProvider();
    }

    protected void createPluginViewer(Composite composite, int span, int indent) {
        PatternFilter patternFilter = new PatternFilter();
        patternFilter.setIncludeLeadingWildcard(true);
        this.fPluginFilteredTree = new FilteredCheckboxTree(composite, this.getTreeViewerStyle(), patternFilter);
        this.fPluginTreeViewer = (CheckboxTreeViewer)this.fPluginFilteredTree.getViewer();
        ((FilteredCheckboxTree.FilterableCheckboxTreeViewer)this.fPluginTreeViewer).addPreRefreshNotifier(new FilteredCheckboxTree.PreRefreshNotifier(){
            boolean previousFilter = false;

            public void preRefresh(FilteredCheckboxTree.FilterableCheckboxTreeViewer viewer, boolean filtered) {
                AbstractPluginBlock.this.refreshTreeView(AbstractPluginBlock.this.fPluginTreeViewer);
                if (this.previousFilter != filtered) {
                    if (AbstractPluginBlock.this.viewerEnabled) {
                        AbstractPluginBlock.this.fWorkingSetButton.setEnabled(!filtered);
                        AbstractPluginBlock.this.fAddRequiredButton.setEnabled(!filtered);
                        AbstractPluginBlock.this.fDefaultsButton.setEnabled(!filtered);
                    }
                    AbstractPluginBlock.this.fPluginTreeViewer.setChecked((Object)AbstractPluginBlock.this.fWorkspacePlugins, AbstractPluginBlock.this.fNumWorkspaceChecked > 0);
                    AbstractPluginBlock.this.fPluginTreeViewer.setGrayed((Object)AbstractPluginBlock.this.fWorkspacePlugins, AbstractPluginBlock.this.fNumWorkspaceChecked > 0 && AbstractPluginBlock.this.fNumWorkspaceChecked < AbstractPluginBlock.this.getWorkspaceModels().length);
                    AbstractPluginBlock.this.fPluginTreeViewer.setChecked((Object)AbstractPluginBlock.this.fExternalPlugins, AbstractPluginBlock.this.fNumExternalChecked > 0);
                    AbstractPluginBlock.this.fPluginTreeViewer.setGrayed((Object)AbstractPluginBlock.this.fExternalPlugins, AbstractPluginBlock.this.fNumExternalChecked > 0 && AbstractPluginBlock.this.fNumExternalChecked < AbstractPluginBlock.this.getExternalModels().length);
                }
                this.previousFilter = filtered;
            }
        });
        this.fPluginTreeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (!event.getChecked()) {
                    return;
                }
                TreeItem[] items = AbstractPluginBlock.this.fPluginTreeViewer.getTree().getItems();
                int i = 0;
                while (i < items.length) {
                    if (event.getElement() == items[i].getData()) {
                        AbstractPluginBlock.this.fFilterButton.setSelection(false);
                        AbstractPluginBlock.this.handleFilterButton();
                        return;
                    }
                    ++i;
                }
            }
        });
        this.fPluginTreeViewer.setContentProvider((IContentProvider)new PluginContentProvider());
        this.fPluginTreeViewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.fPluginTreeViewer.setAutoExpandLevel(2);
        this.fPluginTreeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                if (element instanceof IPluginModelBase) {
                    AbstractPluginBlock.this.handleCheckStateChanged(event);
                } else {
                    AbstractPluginBlock.this.handleGroupStateChanged(element, event.getChecked());
                }
                AbstractPluginBlock.this.fTab.updateLaunchConfigurationDialog();
            }
        });
        this.fPluginTreeViewer.setComparator((ViewerComparator)new ListUtil.PluginComparator(){

            public int category(Object obj) {
                if (obj == AbstractPluginBlock.this.fWorkspacePlugins) {
                    return -1;
                }
                return 0;
            }
        });
        GridData gd = new GridData(1808);
        gd.horizontalSpan = span;
        gd.horizontalIndent = indent;
        this.fPluginFilteredTree.setLayoutData(gd);
        Image siteImage = PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_SITE_OBJ);
        this.fWorkspacePlugins = new NamedElement(PDEUIMessages.AdvancedLauncherTab_workspacePlugins, siteImage);
        this.fExternalPlugins = new NamedElement(PDEUIMessages.PluginsTab_target, siteImage);
        this.fPluginTreeViewer.addFilter((ViewerFilter)new Filter());
        this.fPluginTreeViewer.addFilter((ViewerFilter)new SourcePluginFilter());
        Tree tree = this.fPluginTreeViewer.getTree();
        TreeColumn column1 = new TreeColumn(tree, 16384);
        column1.setText(this.fTab.getName());
        column1.setWidth(400);
        TreeColumn column2 = new TreeColumn(tree, 0x1000000);
        column2.setText(PDEUIMessages.EquinoxPluginBlock_levelColumn);
        column2.setWidth(80);
        TreeColumn column3 = new TreeColumn(tree, 0x1000000);
        column3.setText(PDEUIMessages.EquinoxPluginBlock_autoColumn);
        column3.setWidth(80);
        tree.setHeaderVisible(true);
        tree.setFont(composite.getFont());
        this.fPluginFilteredTree.getFilterControl().setFont(composite.getFont());
        this.createEditors();
    }

    private void createEditors() {
        final Tree tree = this.fPluginTreeViewer.getTree();
        this.levelColumnEditor = new TreeEditor(tree);
        this.levelColumnEditor.horizontalAlignment = 0x1000000;
        this.levelColumnEditor.minimumWidth = 60;
        if (Util.isMac()) {
            this.levelColumnEditor.minimumHeight = 27;
        }
        this.autoColumnEditor = new TreeEditor(tree);
        this.autoColumnEditor.horizontalAlignment = 0x1000000;
        this.autoColumnEditor.grabHorizontal = true;
        this.autoColumnEditor.minimumWidth = 60;
        tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem item;
                Control oldEditor = AbstractPluginBlock.this.levelColumnEditor.getEditor();
                if (oldEditor != null && !oldEditor.isDisposed()) {
                    oldEditor.dispose();
                }
                if ((oldEditor = AbstractPluginBlock.this.autoColumnEditor.getEditor()) != null && !oldEditor.isDisposed()) {
                    oldEditor.dispose();
                }
                if ((item = (TreeItem)e.item) != null && !AbstractPluginBlock.this.isEditable(item)) {
                    return;
                }
                if (item != null && !AbstractPluginBlock.this.isFragment(item)) {
                    Spinner spinner = new Spinner((Composite)tree, 2048);
                    spinner.setMinimum(0);
                    String level = item.getText(1);
                    int defaultLevel = level.length() == 0 || "default".equals(level) ? 0 : Integer.parseInt(level);
                    spinner.setSelection(defaultLevel);
                    spinner.addModifyListener(new ModifyListener(this, item, spinner){
                        final /* synthetic */ 5 this$1;
                        private final /* synthetic */ TreeItem val$item;
                        private final /* synthetic */ Spinner val$spinner;
                        {
                            this.this$1 = var1_1;
                            this.val$item = treeItem;
                            this.val$spinner = spinner;
                        }

                        public void modifyText(ModifyEvent e) {
                            if (this.val$item.getChecked()) {
                                int selection = this.val$spinner.getSelection();
                                this.val$item.setText(1, selection == 0 ? "default" : Integer.toString(selection));
                                AbstractPluginBlock.access$0(5.access$0(this.this$1)).put(this.val$item.getData(), this.val$item.getText(1));
                                5.access$0(this.this$1).fTab.updateLaunchConfigurationDialog();
                            }
                        }
                    });
                    AbstractPluginBlock.this.levelColumnEditor.setEditor((Control)spinner, item, 1);
                    CCombo combo = new CCombo((Composite)tree, 2056);
                    combo.setItems(new String[]{"default", Boolean.toString(true), Boolean.toString(false)});
                    combo.setText(item.getText(2));
                    combo.pack();
                    combo.addSelectionListener((SelectionListener)new SelectionAdapter(this, item, combo){
                        final /* synthetic */ 5 this$1;
                        private final /* synthetic */ TreeItem val$item;
                        private final /* synthetic */ CCombo val$combo;
                        {
                            this.this$1 = var1_1;
                            this.val$item = treeItem;
                            this.val$combo = cCombo;
                        }

                        public void widgetSelected(SelectionEvent e) {
                            if (this.val$item.getChecked()) {
                                this.val$item.setText(2, this.val$combo.getText());
                                AbstractPluginBlock.access$1(5.access$0(this.this$1)).put(this.val$item.getData(), this.val$item.getText(2));
                                5.access$0(this.this$1).fTab.updateLaunchConfigurationDialog();
                            }
                        }
                    });
                    AbstractPluginBlock.this.autoColumnEditor.setEditor((Control)combo, item, 2);
                }
            }

            static /* synthetic */ AbstractPluginBlock access$0(5 var0) {
                return var0.AbstractPluginBlock.this;
            }
        });
    }

    private boolean isEditable(TreeItem item) {
        Object obj = item.getData();
        if (obj instanceof IPluginModelBase) {
            IPluginModelBase model = (IPluginModelBase)obj;
            String systemBundleId = PDECore.getDefault().getModelManager().getSystemBundleId();
            if (!systemBundleId.equals(model.getPluginBase().getId())) {
                return this.fPluginTreeViewer.getChecked((Object)model);
            }
        }
        return false;
    }

    private boolean isFragment(TreeItem item) {
        Object obj = item.getData();
        if (obj instanceof IPluginModelBase) {
            return ((IPluginModelBase)obj).isFragmentModel();
        }
        return false;
    }

    private void createButtonContainer(Composite parent, int vOffset) {
        Composite composite = SWTFactory.createComposite(parent, 1, 1, 1040);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginTop = vOffset;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1040));
        this.fSelectAllButton = this.createButton(composite, PDEUIMessages.AdvancedLauncherTab_selectAll, 8);
        this.fDeselectButton = this.createButton(composite, PDEUIMessages.AdvancedLauncherTab_deselectAll, 8);
        this.fWorkingSetButton = this.createButton(composite, PDEUIMessages.AdvancedLauncherTab_workingSet, 8);
        this.fAddRequiredButton = this.createButton(composite, NLS.bind((String)PDEUIMessages.AdvancedLauncherTab_subset, (Object)this.fTab.getName()), 8);
        this.fDefaultsButton = this.createButton(composite, PDEUIMessages.AdvancedLauncherTab_defaults, 8);
        this.fFilterButton = this.createButton(composite, PDEUIMessages.AdvancedLauncherTab_selectedBundles, 32);
        GridData filterButtonGridData = new GridData(1816);
        this.fFilterButton.setLayoutData((Object)filterButtonGridData);
        this.fCounter = SWTFactory.createLabel(composite, "", 1);
        this.fCounter.setLayoutData((Object)new GridData(776));
        this.updateCounter();
    }

    protected int getTreeViewerStyle() {
        return 67584;
    }

    private Button createButton(Composite composite, String text, int style) {
        Button button = new Button(composite, style);
        button.setText(text);
        button.setLayoutData((Object)new GridData(4, 128, true, false));
        SWTUtil.setButtonDimensionHint(button);
        button.addSelectionListener((SelectionListener)this.fListener);
        return button;
    }

    protected void handleCheckStateChanged(CheckStateChangedEvent event) {
        IPluginModelBase model = (IPluginModelBase)event.getElement();
        if (model.getUnderlyingResource() == null) {
            this.fNumExternalChecked = event.getChecked() ? ++this.fNumExternalChecked : --this.fNumExternalChecked;
        } else {
            this.fNumWorkspaceChecked = event.getChecked() ? ++this.fNumWorkspaceChecked : --this.fNumWorkspaceChecked;
        }
        this.adjustGroupState();
        this.resetText((IPluginModelBase)event.getElement());
    }

    protected void setText(IPluginModelBase model, String value) {
        Widget widget = this.fPluginTreeViewer.testFindItem((Object)model);
        if (widget instanceof TreeItem) {
            TreeItem item = (TreeItem)widget;
            int index = value == null ? -1 : value.indexOf(58);
            String levelValue = index == -1 ? "" : value.substring(0, index);
            String autoValue = null;
            String modelName = model.getBundleDescription().getSymbolicName();
            item.setText(1, levelValue);
            if (model.isFragmentModel()) {
                autoValue = "false";
                item.setText(2, autoValue);
            } else if ("org.eclipse.core.runtime".equals(modelName) || "org.eclipse.equinox.ds".equals(modelName)) {
                autoValue = "true";
                item.setText(2, autoValue);
            } else {
                autoValue = index == -1 ? "" : value.substring(index + 1);
                item.setText(2, autoValue);
            }
            this.levelColumnCache.put(model, levelValue);
            this.autoColumnCache.put(model, autoValue);
        }
    }

    protected void resetText(IPluginModelBase model) {
        String levelText = "";
        String autoText = "";
        String systemBundleId = PDECore.getDefault().getModelManager().getSystemBundleId();
        boolean isSystemBundle = systemBundleId.equals(model.getPluginBase().getId());
        if (model.isFragmentModel()) {
            autoText = "false";
        } else if ("org.eclipse.core.runtime".equals(model.getPluginBase().getId()) || "org.eclipse.equinox.ds".equals(model.getPluginBase().getId())) {
            autoText = "true";
        }
        Widget widget = this.fPluginTreeViewer.testFindItem((Object)model);
        if (this.fPluginTreeViewer.getChecked((Object)model)) {
            if (this.levelColumnCache.containsKey(model) && !isSystemBundle) {
                levelText = (String)this.levelColumnCache.get(model);
                String string = levelText = levelText.length() > 0 ? levelText : "default";
            }
            if (this.autoColumnCache.containsKey(model) && !isSystemBundle) {
                autoText = (String)this.autoColumnCache.get(model);
                String string = autoText = autoText.length() > 0 ? autoText : "default";
            }
        }
        if (levelText != null) {
            this.levelColumnCache.put(model, levelText);
            if (widget instanceof TreeItem) {
                ((TreeItem)widget).setText(1, levelText);
            }
        }
        if (autoText != null) {
            this.autoColumnCache.put(model, autoText);
            if (widget instanceof TreeItem) {
                ((TreeItem)widget).setText(2, autoText);
            }
        }
    }

    protected void handleGroupStateChanged(Object group, boolean checked) {
        NamedElement namedElement;
        TreeItem item;
        this.fPluginTreeViewer.setSubtreeChecked(group, checked);
        this.fPluginTreeViewer.setGrayed(group, false);
        Object[] checkedChildren = ((FilteredCheckboxTree.FilterableCheckboxTreeViewer)this.fPluginTreeViewer).getCheckedChildren(group);
        int numberOfChildren = 0;
        if (checkedChildren != null) {
            numberOfChildren = checkedChildren.length;
        }
        if (group == this.fWorkspacePlugins) {
            this.fNumWorkspaceChecked = numberOfChildren;
        } else if (group == this.fExternalPlugins) {
            this.fNumExternalChecked = numberOfChildren;
        }
        if (group instanceof NamedElement && (item = (TreeItem)this.fPluginTreeViewer.testFindItem((Object)(namedElement = (NamedElement)group))) != null) {
            TreeItem[] children = item.getItems();
            if (children == null) {
                return;
            }
            int i = 0;
            while (i < children.length) {
                TreeItem childItem = children[i];
                Object child = childItem.getData();
                if (child instanceof IPluginModelBase) {
                    this.resetText((IPluginModelBase)child);
                }
                ++i;
            }
        }
    }

    protected void toggleGroups(boolean select) {
        this.handleGroupStateChanged(this.fWorkspacePlugins, select);
        this.handleGroupStateChanged(this.fExternalPlugins, select);
    }

    protected void handleFilterButton() {
        this.fPluginTreeViewer.refresh();
        this.fPluginTreeViewer.expandAll();
    }

    private void handleWorkingSets() {
        IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSetSelectionDialog dialog = workingSetManager.createWorkingSetSelectionDialog(this.getShell(), true);
        if (dialog.open() == 0) {
            String[] ids = this.getPluginIDs(dialog.getSelection());
            int i = 0;
            while (i < ids.length) {
                IPluginModelBase model = PluginRegistry.findModel((String)ids[i]);
                if (model != null && !this.fPluginTreeViewer.getChecked((Object)model)) {
                    this.setChecked(model, true);
                    if (model.getUnderlyingResource() == null) {
                        ++this.fNumExternalChecked;
                    } else {
                        ++this.fNumWorkspaceChecked;
                    }
                }
                ++i;
            }
            this.adjustGroupState();
        }
    }

    protected void setChecked(IPluginModelBase model, boolean checked) {
        this.fPluginTreeViewer.setChecked((Object)model, checked);
        this.resetText(model);
    }

    private String[] getPluginIDs(IWorkingSet[] workingSets) {
        HashSet<String> set = new HashSet<String>();
        int i = 0;
        while (i < workingSets.length) {
            IAdaptable[] elements = workingSets[i].getElements();
            int j = 0;
            while (j < elements.length) {
                IAdaptable element = elements[j];
                if (element instanceof PersistablePluginObject) {
                    set.add(((PersistablePluginObject)element).getPluginID());
                } else {
                    IPluginModelBase model;
                    if (element instanceof IJavaProject) {
                        element = ((IJavaProject)element).getProject();
                    }
                    if (element instanceof IProject && (model = PluginRegistry.findModel((IProject)((IProject)element))) != null) {
                        set.add(model.getPluginBase().getId());
                    }
                }
                ++j;
            }
            ++i;
        }
        return set.toArray(new String[set.size()]);
    }

    public void initializeFrom(ILaunchConfiguration config, boolean enableTable) throws CoreException {
        this.levelColumnCache = new HashMap();
        this.autoColumnCache = new HashMap();
        this.fPluginFilteredTree.resetFilter();
        this.fIncludeOptionalButton.setSelection(config.getAttribute("includeOptional", true));
        this.fAddWorkspaceButton.setSelection(config.getAttribute("automaticAdd", true));
        this.fAutoValidate.setSelection(config.getAttribute("automaticValidate", false));
        if (!enableTable) {
            this.fPluginTreeViewer.setInput(null);
        } else if (this.fPluginTreeViewer.getInput() == null) {
            this.fPluginTreeViewer.setUseHashlookup(true);
            this.fPluginTreeViewer.setInput((Object)PDEPlugin.getDefault());
            this.fPluginTreeViewer.reveal((Object)this.fWorkspacePlugins);
        }
        this.fFilterButton.setSelection(config.getAttribute("show_selected_only", false));
    }

    protected void addRequiredPlugins() {
        Object[] checked = this.fPluginTreeViewer.getCheckedElements();
        ArrayList<Object> toCheck = new ArrayList<Object>(checked.length);
        int i = 0;
        while (i < checked.length) {
            if (checked[i] instanceof IPluginModelBase) {
                toCheck.add(checked[i]);
            }
            ++i;
        }
        Set additionalIds = DependencyManager.getDependencies((Object[])checked, (boolean)this.fIncludeOptionalButton.getSelection(), (String[])new String[]{"org.eclipse.ui.workbench.compatibility"});
        Iterator it = additionalIds.iterator();
        while (it.hasNext()) {
            IPluginModelBase model;
            ModelEntry entry;
            String id = (String)it.next();
            if (this.findPlugin(id) != null || (entry = PluginRegistry.findEntry((String)id)) == null || (model = entry.getModel()) == null) continue;
            toCheck.add(model);
        }
        checked = toCheck.toArray();
        this.setCheckedElements(checked);
        this.fNumExternalChecked = 0;
        this.fNumWorkspaceChecked = 0;
        int i2 = 0;
        while (i2 < checked.length) {
            if (((IPluginModelBase)checked[i2]).getUnderlyingResource() != null) {
                ++this.fNumWorkspaceChecked;
            } else {
                ++this.fNumExternalChecked;
            }
            ++i2;
        }
        this.adjustGroupState();
    }

    protected IPluginModelBase findPlugin(String id) {
        ModelEntry entry = PluginRegistry.findEntry((String)id);
        if (entry != null) {
            IPluginModelBase model = entry.getModel();
            if (this.fPluginTreeViewer.getChecked((Object)model)) {
                return model;
            }
            IPluginModelBase[] models = entry.getWorkspaceModels();
            int i = 0;
            while (i < models.length) {
                if (this.fPluginTreeViewer.getChecked((Object)models[i])) {
                    return models[i];
                }
                ++i;
            }
            models = entry.getExternalModels();
            i = 0;
            while (i < models.length) {
                if (this.fPluginTreeViewer.getChecked((Object)models[i])) {
                    return models[i];
                }
                ++i;
            }
            return null;
        }
        return null;
    }

    protected void setCheckedElements(Object[] checked) {
        this.fPluginTreeViewer.setCheckedElements(checked);
        this.updateGroup(this.fWorkspacePlugins);
        this.updateGroup(this.fExternalPlugins);
    }

    private void updateGroup(Object group) {
        Widget item = this.fPluginTreeViewer.testFindItem(group);
        if (item instanceof TreeItem) {
            TreeItem[] items = ((TreeItem)item).getItems();
            int i = 0;
            while (i < items.length) {
                Object model;
                TreeItem child = items[i];
                if (child.getChecked() == (child.getText(1).length() == 0) && (model = items[i].getData()) instanceof IPluginModelBase) {
                    this.resetText((IPluginModelBase)model);
                }
                ++i;
            }
        }
    }

    protected void adjustGroupState() {
        this.fPluginTreeViewer.setChecked((Object)this.fExternalPlugins, this.fNumExternalChecked > 0);
        this.fPluginTreeViewer.setGrayed((Object)this.fExternalPlugins, this.fNumExternalChecked > 0 && this.fNumExternalChecked < this.getExternalModels().length);
        this.fPluginTreeViewer.setChecked((Object)this.fWorkspacePlugins, this.fNumWorkspaceChecked > 0);
        this.fPluginTreeViewer.setGrayed((Object)this.fWorkspacePlugins, this.fNumWorkspaceChecked > 0 && this.fNumWorkspaceChecked < this.getWorkspaceModels().length);
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("includeOptional", this.fIncludeOptionalButton.getSelection());
        config.setAttribute("automaticAdd", this.fAddWorkspaceButton.getSelection());
        config.setAttribute("automaticValidate", this.fAutoValidate.getSelection());
        config.setAttribute("show_selected_only", this.fFilterButton.getSelection());
        this.savePluginState(config);
        this.updateCounter();
    }

    protected abstract void savePluginState(ILaunchConfigurationWorkingCopy var1);

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("includeOptional", true);
        config.setAttribute("automaticAdd", true);
        config.setAttribute("automaticValidate", false);
        config.setAttribute("show_selected_only", false);
    }

    public void enableViewer(boolean enable) {
        this.viewerEnabled = enable;
        this.fPluginFilteredTree.setEnabled(enable);
        this.fAddRequiredButton.setEnabled(enable);
        this.fDefaultsButton.setEnabled(enable);
        this.fWorkingSetButton.setEnabled(enable);
        this.fSelectAllButton.setEnabled(enable);
        this.fDeselectButton.setEnabled(enable);
        this.fIncludeOptionalButton.setEnabled(enable);
        this.fAddWorkspaceButton.setEnabled(enable);
        this.fCounter.setEnabled(enable);
        this.fFilterButton.setEnabled(enable);
    }

    public void dispose() {
        PDEPlugin.getDefault().getLabelProvider().disconnect(this);
        this.fIsDisposed = true;
    }

    protected boolean isEnabled() {
        return this.fPluginTreeViewer.getTree().isEnabled();
    }

    protected void handleRestoreDefaults() {
        TreeSet<String> wtable = new TreeSet<String>();
        this.fNumWorkspaceChecked = 0;
        this.fNumExternalChecked = 0;
        int i = 0;
        while (i < this.getWorkspaceModels().length) {
            IPluginModelBase model = this.getWorkspaceModels()[i];
            ++this.fNumWorkspaceChecked;
            String id = model.getPluginBase().getId();
            if (id != null) {
                wtable.add(model.getPluginBase().getId());
            }
            ++i;
        }
        this.fPluginTreeViewer.setSubtreeChecked((Object)this.fWorkspacePlugins, true);
        this.fNumExternalChecked = 0;
        IPluginModelBase[] externalModels = this.getExternalModels();
        int i2 = 0;
        while (i2 < externalModels.length) {
            IPluginModelBase model = externalModels[i2];
            boolean masked = wtable.contains(model.getPluginBase().getId());
            if (!masked && model.isEnabled()) {
                this.fPluginTreeViewer.setChecked((Object)model, true);
                ++this.fNumExternalChecked;
            }
            ++i2;
        }
        this.adjustGroupState();
        Object[] selected = this.fPluginTreeViewer.getCheckedElements();
        int i3 = 0;
        while (i3 < selected.length) {
            if (selected[i3] instanceof IPluginModelBase) {
                this.resetText((IPluginModelBase)selected[i3]);
            }
            ++i3;
        }
    }

    protected Shell getShell() {
        try {
            Control c = this.fTab.getControl();
            if (!c.isDisposed()) {
                return c.getShell();
            }
        }
        catch (SWTException sWTException) {}
        return PDEPlugin.getActiveWorkbenchShell();
    }

    public void handleValidate() {
        if (this.fOperation == null) {
            this.fOperation = this.createValidationOperation();
        }
        try {
            this.fOperation.run((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            PDEPlugin.log(e);
        }
        if (this.fDialog == null) {
            if (this.fOperation.hasErrors()) {
                this.fDialog = new PluginStatusDialog(this.getShell(), 2160);
                this.fDialog.setInput(this.fOperation.getInput());
                this.fDialog.open();
                this.fDialog = null;
            } else if (this.fOperation.isEmpty()) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)PDEUIMessages.PluginStatusDialog_pluginValidation, (String)NLS.bind((String)PDEUIMessages.AbstractLauncherToolbar_noSelection, (Object)this.fTab.getName().toLowerCase(Locale.ENGLISH)));
            } else {
                MessageDialog.openInformation((Shell)this.getShell(), (String)PDEUIMessages.PluginStatusDialog_pluginValidation, (String)PDEUIMessages.AbstractLauncherToolbar_noProblems);
            }
        } else if (this.fOperation.getInput().size() > 0) {
            this.fDialog.refresh(this.fOperation.getInput());
        } else {
            HashMap<String, IStatus> input = new HashMap<String, IStatus>(1);
            input.put(PDEUIMessages.AbstractLauncherToolbar_noProblems, Status.OK_STATUS);
            this.fDialog.refresh(input);
        }
    }

    protected abstract LaunchValidationOperation createValidationOperation();

    protected void refreshTreeView(CheckboxTreeViewer treeView) {
        if (treeView.getTree().getItemCount() > 0) {
            treeView.getTree().setSelection(treeView.getTree().getItem(0));
        } else {
            treeView.setSelection((ISelection)new StructuredSelection((Object)StructuredSelection.EMPTY));
        }
        if (this.levelColumnEditor != null && this.levelColumnEditor.getEditor() != null && !this.levelColumnEditor.getEditor().isDisposed()) {
            this.levelColumnEditor.getEditor().dispose();
        }
        if (this.autoColumnEditor != null && this.autoColumnEditor.getEditor() != null && !this.autoColumnEditor.getEditor().isDisposed()) {
            this.autoColumnEditor.getEditor().dispose();
        }
    }

    protected void appendToBuffer(StringBuffer buffer, IPluginModelBase model) {
        if (buffer.length() > 0) {
            buffer.append(",");
        }
        String startLevel = null;
        String autoStart = null;
        if (this.fPluginTreeViewer.getChecked((Object)model)) {
            startLevel = this.levelColumnCache.get(model) != null ? this.levelColumnCache.get(model).toString() : null;
            autoStart = this.autoColumnCache.get(model) != null ? this.autoColumnCache.get(model).toString() : null;
        }
        String value = BundleLauncherHelper.writeBundleEntry((IPluginModelBase)model, startLevel, autoStart);
        buffer.append(value);
    }

    protected void resetGroup(NamedElement group) {
        Widget widget = this.fPluginTreeViewer.testFindItem((Object)group);
        if (widget instanceof TreeItem) {
            TreeItem[] items = ((TreeItem)widget).getItems();
            int i = 0;
            while (i < items.length) {
                Object model;
                if (!items[i].getChecked() && (model = items[i].getData()) instanceof IPluginModelBase) {
                    this.resetText((IPluginModelBase)model);
                }
                ++i;
            }
        }
    }

    class Filter
    extends ViewerFilter {
        Filter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (AbstractPluginBlock.this.fFilterButton.getSelection()) {
                return AbstractPluginBlock.this.fPluginTreeViewer.getChecked(element);
            }
            return true;
        }
    }

    class Listener
    extends SelectionAdapter {
        Listener() {
        }

        private void filterAffectingControl(SelectionEvent e) {
            boolean resetFilterButton = false;
            Object source = e.getSource();
            if (AbstractPluginBlock.this.fFilterButton.getSelection()) {
                AbstractPluginBlock.this.fFilterButton.setSelection(false);
                AbstractPluginBlock.this.handleFilterButton();
                resetFilterButton = true;
            }
            if (source == AbstractPluginBlock.this.fSelectAllButton) {
                AbstractPluginBlock.this.toggleGroups(true);
            } else if (source == AbstractPluginBlock.this.fDeselectButton) {
                AbstractPluginBlock.this.toggleGroups(false);
            } else if (source == AbstractPluginBlock.this.fWorkingSetButton) {
                AbstractPluginBlock.this.handleWorkingSets();
            } else if (source == AbstractPluginBlock.this.fAddRequiredButton) {
                AbstractPluginBlock.this.addRequiredPlugins();
            } else if (source == AbstractPluginBlock.this.fDefaultsButton) {
                AbstractPluginBlock.this.handleRestoreDefaults();
            }
            if (resetFilterButton) {
                resetFilterButton = false;
                AbstractPluginBlock.this.fFilterButton.setSelection(true);
                AbstractPluginBlock.this.handleFilterButton();
            }
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == AbstractPluginBlock.this.fFilterButton) {
                AbstractPluginBlock.this.handleFilterButton();
            } else if (source == AbstractPluginBlock.this.fSelectAllButton || source == AbstractPluginBlock.this.fDeselectButton || source == AbstractPluginBlock.this.fWorkingSetButton || source == AbstractPluginBlock.this.fAddRequiredButton || source == AbstractPluginBlock.this.fDefaultsButton) {
                this.filterAffectingControl(e);
            } else if (source == AbstractPluginBlock.this.fValidateButton) {
                AbstractPluginBlock.this.handleValidate();
            }
            if (!AbstractPluginBlock.this.fIsDisposed) {
                AbstractPluginBlock.this.fTab.updateLaunchConfigurationDialog();
            }
        }
    }

    class OSGiLabelProvider
    extends PDELabelProvider {
        OSGiLabelProvider() {
        }

        public Image getColumnImage(Object obj, int index) {
            return index == 0 ? super.getColumnImage(obj, index) : null;
        }

        public String getColumnText(Object obj, int index) {
            switch (index) {
                case 0: {
                    return super.getColumnText(obj, index);
                }
                case 1: {
                    if (AbstractPluginBlock.this.levelColumnCache != null && AbstractPluginBlock.this.levelColumnCache.containsKey(obj)) {
                        return (String)AbstractPluginBlock.this.levelColumnCache.get(obj);
                    }
                    return "";
                }
                case 2: {
                    if (AbstractPluginBlock.this.autoColumnCache != null && AbstractPluginBlock.this.autoColumnCache.containsKey(obj)) {
                        return (String)AbstractPluginBlock.this.autoColumnCache.get(obj);
                    }
                    return "";
                }
            }
            return "";
        }
    }

    class PluginContentProvider
    extends DefaultContentProvider
    implements ITreeContentProvider {
        PluginContentProvider() {
        }

        public boolean hasChildren(Object parent) {
            return !(parent instanceof IPluginModelBase);
        }

        public Object[] getChildren(Object parent) {
            if (parent == AbstractPluginBlock.this.fExternalPlugins) {
                return AbstractPluginBlock.this.getExternalModels();
            }
            if (parent == AbstractPluginBlock.this.fWorkspacePlugins) {
                return AbstractPluginBlock.this.getWorkspaceModels();
            }
            return new Object[0];
        }

        public Object getParent(Object child) {
            if (child instanceof IPluginModelBase) {
                IResource resource = ((IPluginModelBase)child).getUnderlyingResource();
                return resource == null ? AbstractPluginBlock.this.fExternalPlugins : AbstractPluginBlock.this.fWorkspacePlugins;
            }
            return null;
        }

        public Object[] getElements(Object input) {
            ArrayList<NamedElement> list = new ArrayList<NamedElement>();
            if (AbstractPluginBlock.this.getWorkspaceModels().length > 0) {
                list.add(AbstractPluginBlock.this.fWorkspacePlugins);
            }
            if (AbstractPluginBlock.this.getExternalModels().length > 0) {
                list.add(AbstractPluginBlock.this.fExternalPlugins);
            }
            return list.toArray();
        }
    }
}

