/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.NamingConventions;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.TokenScanner;
import org.eclipse.jdt.internal.corext.refactoring.ParameterInfo;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.CreateCompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.CreatePackageChange;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.resource.ResourceChange;
import org.eclipse.text.edits.TextEdit;

public class ParameterObjectFactory {
    private String fClassName;
    private boolean fCreateGetter;
    private boolean fCreateSetter;
    private String fEnclosingType;
    private String fPackage;
    private List fVariables;

    public TypeDeclaration createClassDeclaration(String declaringType, CompilationUnitRewrite cuRewrite, CreationListener listener) throws CoreException {
        AST ast = cuRewrite.getAST();
        if (listener == null) {
            listener = new CreationListener();
        }
        TypeDeclaration typeDeclaration = ast.newTypeDeclaration();
        typeDeclaration.setName(ast.newSimpleName(this.fClassName));
        List body = typeDeclaration.bodyDeclarations();
        Iterator iter = this.fVariables.iterator();
        while (iter.hasNext()) {
            ParameterInfo pi = (ParameterInfo)iter.next();
            if (!this.isValidField(pi)) continue;
            FieldDeclaration declaration = this.createField(pi, cuRewrite);
            listener.fieldCreated(cuRewrite, declaration, pi);
            body.add(declaration);
        }
        MethodDeclaration constructor = this.createConstructor(declaringType, cuRewrite, listener);
        listener.constructorCreated(cuRewrite, constructor);
        body.add(constructor);
        Iterator iter2 = this.fVariables.iterator();
        while (iter2.hasNext()) {
            ParameterInfo pi = (ParameterInfo)iter2.next();
            if (this.fCreateGetter && this.isValidField(pi) && listener.isCreateGetter(pi)) {
                MethodDeclaration getter = this.createGetter(pi, declaringType, cuRewrite);
                listener.getterCreated(cuRewrite, getter, pi);
                body.add(getter);
            }
            if (!this.fCreateSetter || !this.isValidField(pi) || !listener.isCreateSetter(pi)) continue;
            MethodDeclaration setter = this.createSetter(pi, declaringType, cuRewrite);
            listener.setterCreated(cuRewrite, setter, pi);
            body.add(setter);
        }
        listener.typeCreated(cuRewrite, typeDeclaration);
        return typeDeclaration;
    }

    private MethodDeclaration createConstructor(String declaringTypeName, CompilationUnitRewrite cuRewrite, CreationListener listener) throws CoreException {
        String comment;
        AST ast = cuRewrite.getAST();
        ICompilationUnit unit = cuRewrite.getCu();
        IJavaProject project = unit.getJavaProject();
        MethodDeclaration methodDeclaration = ast.newMethodDeclaration();
        methodDeclaration.setName(ast.newSimpleName(this.fClassName));
        methodDeclaration.setConstructor(true);
        methodDeclaration.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
        String lineDelimiter = StubUtility.getLineDelimiterUsed((IJavaElement)unit);
        if (this.createComments(project) && (comment = CodeGeneration.getMethodComment(unit, declaringTypeName, methodDeclaration, null, lineDelimiter)) != null) {
            Javadoc doc = (Javadoc)cuRewrite.getASTRewrite().createStringPlaceholder(comment, 29);
            methodDeclaration.setJavadoc(doc);
        }
        List parameters = methodDeclaration.parameters();
        Block block = ast.newBlock();
        methodDeclaration.setBody(block);
        List statements = block.statements();
        ArrayList<ParameterInfo> validParameter = new ArrayList<ParameterInfo>();
        Iterator iter = this.fVariables.iterator();
        while (iter.hasNext()) {
            ParameterInfo pi = (ParameterInfo)iter.next();
            if (!this.isValidField(pi) || !listener.isUseInConstructor(pi)) continue;
            validParameter.add(pi);
        }
        ArrayList<String> usedParameter = new ArrayList<String>();
        Iterator iter2 = validParameter.iterator();
        while (iter2.hasNext()) {
            SimpleName leftHandSide;
            ParameterInfo pi = (ParameterInfo)iter2.next();
            SingleVariableDeclaration svd = ast.newSingleVariableDeclaration();
            ITypeBinding typeBinding = pi.getNewTypeBinding();
            if (!iter2.hasNext() && typeBinding.isArray() && pi.isOldVarargs()) {
                int dimensions = typeBinding.getDimensions();
                typeBinding = dimensions == 1 ? typeBinding.getComponentType() : typeBinding.createArrayType(dimensions - 1);
                svd.setVarargs(true);
            }
            String paramName = this.getParameterName(pi, project, usedParameter);
            usedParameter.add(paramName);
            Type fieldType = ParameterObjectFactory.importBinding(typeBinding, cuRewrite);
            svd.setType(fieldType);
            svd.setName(ast.newSimpleName(paramName));
            parameters.add(svd);
            if (paramName.equals(pi.getNewName()) || StubUtility.useThisForFieldAccess(project)) {
                FieldAccess fieldAccess = ast.newFieldAccess();
                fieldAccess.setName(ast.newSimpleName(pi.getNewName()));
                fieldAccess.setExpression((Expression)ast.newThisExpression());
                leftHandSide = fieldAccess;
            } else {
                leftHandSide = ast.newSimpleName(pi.getNewName());
            }
            Assignment assignment = ast.newAssignment();
            assignment.setLeftHandSide((Expression)leftHandSide);
            assignment.setRightHandSide((Expression)ast.newSimpleName(paramName));
            statements.add(ast.newExpressionStatement((Expression)assignment));
        }
        return methodDeclaration;
    }

    private String getParameterName(ParameterInfo pi, IJavaProject project, ArrayList usedParameter) {
        String fieldName = pi.getNewName();
        String strippedName = NamingConventions.getBaseName((int)2, (String)fieldName, (IJavaProject)project);
        String[] suggestions = StubUtility.getVariableNameSuggestions(4, project, strippedName, 0, usedParameter, true);
        return suggestions[0];
    }

    public static Type importBinding(ITypeBinding typeBinding, CompilationUnitRewrite cuRewrite) {
        int declaredModifiers = typeBinding.getDeclaredModifiers();
        AST ast = cuRewrite.getAST();
        if (Modifier.isPrivate((int)declaredModifiers) || Modifier.isProtected((int)declaredModifiers)) {
            return ast.newSimpleType((Name)ast.newSimpleName(typeBinding.getName()));
        }
        Type type = cuRewrite.getImportRewrite().addImport(typeBinding, cuRewrite.getAST());
        cuRewrite.getImportRemover().registerAddedImports(type);
        return type;
    }

    private FieldDeclaration createField(ParameterInfo pi, CompilationUnitRewrite cuRewrite) throws CoreException {
        String comment;
        AST ast = cuRewrite.getAST();
        ICompilationUnit unit = cuRewrite.getCu();
        VariableDeclarationFragment fragment = ast.newVariableDeclarationFragment();
        String lineDelim = StubUtility.getLineDelimiterUsed((IJavaElement)unit);
        SimpleName fieldName = ast.newSimpleName(pi.getNewName());
        fragment.setName(fieldName);
        FieldDeclaration declaration = ast.newFieldDeclaration(fragment);
        if (this.createComments(unit.getJavaProject()) && (comment = StubUtility.getFieldComment(unit, pi.getNewTypeName(), pi.getNewName(), lineDelim)) != null) {
            Javadoc doc = (Javadoc)cuRewrite.getASTRewrite().createStringPlaceholder(comment, 29);
            declaration.setJavadoc(doc);
        }
        ArrayList<Modifier> modifiers = new ArrayList<Modifier>();
        if (this.fCreateGetter) {
            modifiers.add(ast.newModifier(Modifier.ModifierKeyword.PRIVATE_KEYWORD));
        } else {
            modifiers.add(ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
        }
        declaration.modifiers().addAll(modifiers);
        declaration.setType(ParameterObjectFactory.importBinding(pi.getNewTypeBinding(), cuRewrite));
        return declaration;
    }

    public Expression createFieldReadAccess(ParameterInfo pi, String paramName, AST ast, IJavaProject project, boolean useSuper, Expression qualifier) {
        Expression completeQualifier = this.generateQualifier(paramName, ast, useSuper, qualifier);
        if (this.fCreateGetter) {
            MethodInvocation mi = ast.newMethodInvocation();
            mi.setName(ast.newSimpleName(this.getGetterName(pi, ast, project)));
            mi.setExpression(completeQualifier);
            return mi;
        }
        return this.createFieldAccess(pi, ast, completeQualifier);
    }

    public Expression createFieldWriteAccess(ParameterInfo pi, String paramName, AST ast, IJavaProject project, Expression assignedValue, boolean useSuper, Expression qualifier) {
        Expression completeQualifier = this.generateQualifier(paramName, ast, useSuper, qualifier);
        if (this.fCreateSetter) {
            MethodInvocation mi = ast.newMethodInvocation();
            mi.setName(ast.newSimpleName(this.getSetterName(pi, ast, project)));
            mi.setExpression(completeQualifier);
            mi.arguments().add(assignedValue);
            return mi;
        }
        return this.createFieldAccess(pi, ast, completeQualifier);
    }

    private Expression generateQualifier(String paramName, AST ast, boolean useSuper, Expression qualifier) {
        SimpleName paramSimpleName = ast.newSimpleName(paramName);
        if (useSuper) {
            SuperFieldAccess sf = ast.newSuperFieldAccess();
            sf.setName(paramSimpleName);
            if (qualifier instanceof Name) {
                sf.setQualifier((Name)qualifier);
            }
            return sf;
        }
        if (qualifier != null) {
            FieldAccess parameterAccess = ast.newFieldAccess();
            parameterAccess.setExpression(qualifier);
            parameterAccess.setName(paramSimpleName);
            return parameterAccess;
        }
        return paramSimpleName;
    }

    private Expression createFieldAccess(ParameterInfo pi, AST ast, Expression qualifier) {
        if (qualifier instanceof Name) {
            Name name = (Name)qualifier;
            return ast.newName(JavaModelUtil.concatenateName(name.getFullyQualifiedName(), pi.getNewName()));
        }
        FieldAccess fa = ast.newFieldAccess();
        fa.setName(ast.newSimpleName(pi.getNewName()));
        fa.setExpression(qualifier);
        return fa;
    }

    private MethodDeclaration createGetter(ParameterInfo pi, String declaringType, CompilationUnitRewrite cuRewrite) throws CoreException {
        String comment;
        AST ast = cuRewrite.getAST();
        ICompilationUnit cu = cuRewrite.getCu();
        IJavaProject project = cu.getJavaProject();
        MethodDeclaration methodDeclaration = ast.newMethodDeclaration();
        String fieldName = pi.getNewName();
        String getterName = this.getGetterName(pi, ast, project);
        String lineDelim = StubUtility.getLineDelimiterUsed((IJavaElement)cu);
        String bareFieldname = NamingConventions.getBaseName((int)2, (String)fieldName, (IJavaProject)project);
        if (this.createComments(project) && (comment = CodeGeneration.getGetterComment(cu, declaringType, getterName, fieldName, pi.getNewTypeName(), bareFieldname, lineDelim)) != null) {
            methodDeclaration.setJavadoc((Javadoc)cuRewrite.getASTRewrite().createStringPlaceholder(comment, 29));
        }
        methodDeclaration.setName(ast.newSimpleName(getterName));
        methodDeclaration.setReturnType2(ParameterObjectFactory.importBinding(pi.getNewTypeBinding(), cuRewrite));
        methodDeclaration.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
        Block block = ast.newBlock();
        methodDeclaration.setBody(block);
        boolean useThis = StubUtility.useThisForFieldAccess(project);
        if (useThis) {
            fieldName = "this." + fieldName;
        }
        String bodyContent = CodeGeneration.getGetterMethodBodyContent(cu, declaringType, getterName, fieldName, lineDelim);
        ASTNode getterBody = cuRewrite.getASTRewrite().createStringPlaceholder(bodyContent, 21);
        block.statements().add(getterBody);
        return methodDeclaration;
    }

    public ExpressionStatement createInitializer(ParameterInfo pi, String paramName, CompilationUnitRewrite cuRewrite) {
        AST ast = cuRewrite.getAST();
        VariableDeclarationFragment fragment = ast.newVariableDeclarationFragment();
        fragment.setName(ast.newSimpleName(pi.getOldName()));
        fragment.setInitializer(this.createFieldReadAccess(pi, paramName, ast, cuRewrite.getCu().getJavaProject(), false, null));
        VariableDeclarationExpression declaration = ast.newVariableDeclarationExpression(fragment);
        IVariableBinding variable = pi.getOldBinding();
        declaration.setType(ParameterObjectFactory.importBinding(pi.getNewTypeBinding(), cuRewrite));
        int modifiers = variable.getModifiers();
        List newModifiers = ast.newModifiers(modifiers);
        declaration.modifiers().addAll(newModifiers);
        return ast.newExpressionStatement((Expression)declaration);
    }

    private MethodDeclaration createSetter(ParameterInfo pi, String declaringType, CompilationUnitRewrite cuRewrite) throws CoreException {
        String comment;
        AST ast = cuRewrite.getAST();
        ICompilationUnit cu = cuRewrite.getCu();
        IJavaProject project = cu.getJavaProject();
        MethodDeclaration methodDeclaration = ast.newMethodDeclaration();
        String fieldName = pi.getNewName();
        String setterName = this.getSetterName(pi, ast, project);
        String lineDelim = StubUtility.getLineDelimiterUsed((IJavaElement)cu);
        String bareFieldname = NamingConventions.getBaseName((int)2, (String)fieldName, (IJavaProject)project);
        String paramName = StubUtility.suggestArgumentName(project, bareFieldname, null);
        if (this.createComments(project) && (comment = CodeGeneration.getSetterComment(cu, declaringType, setterName, fieldName, pi.getNewTypeName(), paramName, bareFieldname, lineDelim)) != null) {
            methodDeclaration.setJavadoc((Javadoc)cuRewrite.getASTRewrite().createStringPlaceholder(comment, 29));
        }
        methodDeclaration.setName(ast.newSimpleName(setterName));
        methodDeclaration.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
        SingleVariableDeclaration variable = ast.newSingleVariableDeclaration();
        variable.setType(ParameterObjectFactory.importBinding(pi.getNewTypeBinding(), cuRewrite));
        variable.setName(ast.newSimpleName(paramName));
        methodDeclaration.parameters().add(variable);
        Block block = ast.newBlock();
        methodDeclaration.setBody(block);
        boolean useThis = StubUtility.useThisForFieldAccess(project);
        if (useThis || fieldName.equals(paramName)) {
            fieldName = "this." + fieldName;
        }
        String bodyContent = CodeGeneration.getSetterMethodBodyContent(cu, declaringType, setterName, fieldName, paramName, lineDelim);
        ASTNode setterBody = cuRewrite.getASTRewrite().createStringPlaceholder(bodyContent, 21);
        block.statements().add(setterBody);
        return methodDeclaration;
    }

    public Type createType(boolean asTopLevelClass, CompilationUnitRewrite cuRewrite, int position) {
        String qualifier = asTopLevelClass ? this.fPackage : this.fEnclosingType;
        String concatenateName = JavaModelUtil.concatenateName(qualifier, this.fClassName);
        ImportRewrite importRewrite = cuRewrite.getImportRewrite();
        ContextSensitiveImportRewriteContext context = this.createParameterClassAwareContext(asTopLevelClass, cuRewrite, position);
        String addedImport = importRewrite.addImport(concatenateName, (ImportRewrite.ImportRewriteContext)context);
        cuRewrite.getImportRemover().registerAddedImport(addedImport);
        AST ast = cuRewrite.getAST();
        return ast.newSimpleType(ast.newName(addedImport));
    }

    ContextSensitiveImportRewriteContext createParameterClassAwareContext(final boolean asTopLevelClass, CompilationUnitRewrite cuRewrite, int position) {
        ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext(cuRewrite.getRoot(), position, cuRewrite.getImportRewrite()){

            public int findInContext(String qualifier, String name, int kind) {
                String parameterClassName = ParameterObjectFactory.this.getClassName();
                if (kind == 1 && parameterClassName.equals(name)) {
                    String parameterClassQualifier;
                    String string = parameterClassQualifier = asTopLevelClass ? ParameterObjectFactory.this.getPackage() : ParameterObjectFactory.this.getEnclosingType();
                    if (super.findInContext(qualifier, "", kind) == 1) {
                        if (parameterClassQualifier.equals(qualifier)) {
                            return 1;
                        }
                        return 3;
                    }
                }
                return super.findInContext(qualifier, name, kind);
            }
        };
        return context;
    }

    public String getClassName() {
        return this.fClassName;
    }

    public String getEnclosingType() {
        return this.fEnclosingType;
    }

    private String getGetterName(ParameterInfo pi, AST ast, IJavaProject project) {
        ITypeBinding type = pi.getNewTypeBinding();
        boolean isBoolean = ast.resolveWellKnownType("boolean").isEqualTo((IBinding)type) || ast.resolveWellKnownType("java.lang.Boolean").isEqualTo((IBinding)type);
        return NamingConventions.suggestGetterName((IJavaProject)project, (String)pi.getNewName(), (int)1, (boolean)isBoolean, null);
    }

    public String getPackage() {
        return this.fPackage;
    }

    public ParameterInfo getParameterInfo(String identifier) {
        Iterator iter = this.fVariables.iterator();
        while (iter.hasNext()) {
            ParameterInfo pi = (ParameterInfo)iter.next();
            if (!pi.getOldName().equals(identifier)) continue;
            return pi;
        }
        return null;
    }

    private String getSetterName(ParameterInfo pi, AST ast, IJavaProject project) {
        ITypeBinding type = pi.getNewTypeBinding();
        boolean isBoolean = ast.resolveWellKnownType("boolean").isEqualTo((IBinding)type) || ast.resolveWellKnownType("java.lang.Boolean").isEqualTo((IBinding)type);
        return NamingConventions.suggestSetterName((IJavaProject)project, (String)pi.getNewName(), (int)1, (boolean)isBoolean, null);
    }

    public boolean isCreateGetter() {
        return this.fCreateGetter;
    }

    public boolean isCreateSetter() {
        return this.fCreateSetter;
    }

    private boolean isValidField(ParameterInfo pi) {
        return pi.isCreateField() && !pi.isAdded();
    }

    public void moveDown(ParameterInfo selected) {
        int idx = this.fVariables.indexOf(selected);
        Assert.isTrue((idx >= 0 && idx < this.fVariables.size() - 1 ? 1 : 0) != 0);
        int nextIdx = idx + 1;
        ParameterInfo next = (ParameterInfo)this.fVariables.get(nextIdx);
        if (next.isAdded()) {
            Assert.isTrue((++nextIdx <= this.fVariables.size() - 1 ? 1 : 0) != 0);
            next = (ParameterInfo)this.fVariables.get(nextIdx);
        }
        this.fVariables.set(idx, next);
        this.fVariables.set(nextIdx, selected);
    }

    public void moveUp(ParameterInfo selected) {
        int idx = this.fVariables.indexOf(selected);
        Assert.isTrue((idx > 0 ? 1 : 0) != 0);
        int prevIdx = idx - 1;
        ParameterInfo prev = (ParameterInfo)this.fVariables.get(prevIdx);
        if (prev.isAdded()) {
            Assert.isTrue((--prevIdx >= 0 ? 1 : 0) != 0);
            prev = (ParameterInfo)this.fVariables.get(prevIdx);
        }
        this.fVariables.set(idx, prev);
        this.fVariables.set(prevIdx, selected);
    }

    public void setClassName(String className) {
        this.fClassName = className;
    }

    public void setCreateGetter(boolean createGetter) {
        this.fCreateGetter = createGetter;
    }

    public void setCreateSetter(boolean createSetter) {
        this.fCreateSetter = createSetter;
    }

    public void setEnclosingType(String enclosingType) {
        this.fEnclosingType = enclosingType;
    }

    public void setPackage(String typeQualifier) {
        this.fPackage = typeQualifier;
    }

    public void setVariables(List parameters) {
        this.fVariables = parameters;
    }

    public void updateParameterPosition(ParameterInfo parameterObjectReference) {
        this.fVariables.remove(parameterObjectReference);
        ListIterator<ParameterInfo> iterator = this.fVariables.listIterator();
        while (iterator.hasNext()) {
            ParameterInfo pi = (ParameterInfo)iterator.next();
            if (!this.isValidField(pi)) continue;
            iterator.add(parameterObjectReference);
            return;
        }
    }

    private boolean createComments(IJavaProject project) {
        return StubUtility.doAddComments(project);
    }

    public List createTopLevelParameterObject(IPackageFragmentRoot packageFragmentRoot, CreationListener listener) throws CoreException {
        ICompilationUnit unit;
        ArrayList<ResourceChange> changes = new ArrayList<ResourceChange>();
        IPackageFragment packageFragment = packageFragmentRoot.getPackageFragment(this.getPackage());
        if (!packageFragment.exists()) {
            changes.add(new CreatePackageChange(packageFragment));
        }
        Assert.isTrue((!(unit = packageFragment.getCompilationUnit(String.valueOf(this.getClassName()) + ".java")).exists() ? 1 : 0) != 0);
        IJavaProject javaProject = unit.getJavaProject();
        ICompilationUnit workingCopy = unit.getWorkingCopy(null);
        try {
            String lineDelimiter = StubUtility.getLineDelimiterUsed(javaProject);
            String fileComment = this.getFileComment(workingCopy, lineDelimiter);
            String typeComment = this.getTypeComment(workingCopy, lineDelimiter);
            String content = CodeGeneration.getCompilationUnitContent(workingCopy, fileComment, typeComment, "class " + this.getClassName() + "{}", lineDelimiter);
            workingCopy.getBuffer().setContents(content);
            CompilationUnitRewrite cuRewrite = new CompilationUnitRewrite(workingCopy);
            ASTRewrite rewriter = cuRewrite.getASTRewrite();
            CompilationUnit root = cuRewrite.getRoot();
            AST ast = cuRewrite.getAST();
            ImportRewrite importRewrite = cuRewrite.getImportRewrite();
            ListRewrite types = rewriter.getListRewrite((ASTNode)root, CompilationUnit.TYPES_PROPERTY);
            ASTNode dummyType = (ASTNode)types.getOriginalList().get(0);
            String newTypeName = JavaModelUtil.concatenateName(this.getPackage(), this.getClassName());
            TypeDeclaration classDeclaration = this.createClassDeclaration(newTypeName, cuRewrite, listener);
            classDeclaration.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
            Javadoc javadoc = (Javadoc)dummyType.getStructuralProperty((StructuralPropertyDescriptor)TypeDeclaration.JAVADOC_PROPERTY);
            rewriter.set((ASTNode)classDeclaration, (StructuralPropertyDescriptor)TypeDeclaration.JAVADOC_PROPERTY, (Object)javadoc, null);
            types.replace(dummyType, (ASTNode)classDeclaration, null);
            String charset = ResourceUtil.getFile(unit).getCharset(false);
            Document document = new Document(content);
            try {
                rewriter.rewriteAST().apply((IDocument)document);
                TextEdit rewriteImports = importRewrite.rewriteImports(null);
                rewriteImports.apply((IDocument)document);
            }
            catch (BadLocationException e) {
                throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), RefactoringCoreMessages.IntroduceParameterObjectRefactoring_parameter_object_creation_error, (Throwable)e));
            }
            String docContent = document.get();
            CreateCompilationUnitChange compilationUnitChange = new CreateCompilationUnitChange(unit, docContent, charset);
            changes.add(compilationUnitChange);
        }
        finally {
            workingCopy.discardWorkingCopy();
        }
        return changes;
    }

    public List createTopLevelParameterObject(IPackageFragmentRoot packageFragmentRoot) throws CoreException {
        return this.createTopLevelParameterObject(packageFragmentRoot, null);
    }

    protected String getFileComment(ICompilationUnit parentCU, String lineDelimiter) throws CoreException {
        if (StubUtility.doAddComments(parentCU.getJavaProject())) {
            return CodeGeneration.getFileComment(parentCU, lineDelimiter);
        }
        return null;
    }

    protected String getTypeComment(ICompilationUnit parentCU, String lineDelimiter) throws CoreException {
        if (StubUtility.doAddComments(parentCU.getJavaProject())) {
            StringBuffer typeName = new StringBuffer();
            typeName.append(this.getClassName());
            String[] typeParamNames = new String[]{};
            String comment = CodeGeneration.getTypeComment(parentCU, typeName.toString(), typeParamNames, lineDelimiter);
            if (comment != null && this.isValidComment(comment)) {
                return comment;
            }
        }
        return null;
    }

    private boolean isValidComment(String template) {
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)false);
        scanner.setSource(template.toCharArray());
        try {
            int next = scanner.getNextToken();
            while (TokenScanner.isComment(next)) {
                next = scanner.getNextToken();
            }
            return next == 158;
        }
        catch (InvalidInputException invalidInputException) {
            return false;
        }
    }

    public static class CreationListener {
        public void getterCreated(CompilationUnitRewrite cuRewrite, MethodDeclaration getter, ParameterInfo pi) {
        }

        public void setterCreated(CompilationUnitRewrite cuRewrite, MethodDeclaration setter, ParameterInfo pi) {
        }

        public void fieldCreated(CompilationUnitRewrite cuRewrite, FieldDeclaration field, ParameterInfo pi) {
        }

        public void constructorCreated(CompilationUnitRewrite cuRewrite, MethodDeclaration constructor) {
        }

        public void typeCreated(CompilationUnitRewrite cuRewrite, TypeDeclaration declaration) {
        }

        protected static ASTNode moveNode(CompilationUnitRewrite cuRewrite, ASTNode node) {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            if (rewrite.getAST() != node.getAST()) {
                String str = ASTNodes.getNodeSource(node, true, true);
                if (str != null) {
                    return rewrite.createStringPlaceholder(str, node.getNodeType());
                }
                return ASTNode.copySubtree((AST)rewrite.getAST(), (ASTNode)node);
            }
            return rewrite.createMoveTarget(node);
        }

        public boolean isCreateSetter(ParameterInfo pi) {
            return !Modifier.isFinal((int)pi.getOldBinding().getModifiers());
        }

        public boolean isCreateGetter(ParameterInfo pi) {
            return true;
        }

        public boolean isUseInConstructor(ParameterInfo pi) {
            return true;
        }
    }
}

