/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import java.io.IOException;
import java.net.URL;
import java.nio.channels.OverlappingFileLockException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Hits;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.IHelpResource;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.search.AnalyzerDescriptor;
import org.eclipse.help.internal.search.ISearchHitCollector;
import org.eclipse.help.internal.search.ISearchQuery;
import org.eclipse.help.internal.search.IndexingOperation;
import org.eclipse.help.internal.search.LuceneSearchParticipantAdapter;
import org.eclipse.help.internal.search.PluginVersionInfo;
import org.eclipse.help.internal.search.ProgressDistributor;
import org.eclipse.help.internal.search.QueryTooComplexException;
import org.eclipse.help.internal.search.SearchHit;
import org.eclipse.help.internal.search.SearchIndex;
import org.eclipse.help.internal.search.SearchIndexWithIndexingProgress;
import org.eclipse.help.internal.search.SearchProgressMonitor;
import org.eclipse.help.internal.util.URLCoder;
import org.eclipse.help.search.LuceneSearchParticipant;
import org.eclipse.help.search.SearchParticipant;
import org.osgi.framework.Bundle;

public class LocalSearchManager {
    private static final String LUCENE_SEARCH_PARTICIPANT_XP_FULLNAME = "org.eclipse.help.base.luceneSearchParticipants";
    private static final String SEARCH_PARTICIPANT_XP_FULLNAME = "org.eclipse.help.base.searchParticipant";
    private static final String SEARCH_PARTICIPANT_XP_NAME = "searchParticipant";
    private static final String BINDING_XP_NAME = "binding";
    private static final Object PARTICIPANTS_NOT_FOUND = new Object();
    private Map indexes = new HashMap();
    private Map analyzerDescriptors = new HashMap();
    private Map searchParticipantsById = new HashMap();
    private Map searchParticipantsByPlugin = new HashMap();
    private ArrayList globalSearchParticipants;

    public static List asList(Hits hits) {
        ArrayList<SearchHit> list = new ArrayList<SearchHit>(hits.length());
        int i = 0;
        while (i < hits.length()) {
            try {
                Document doc = hits.doc(i);
                float score = hits.score(i);
                String href = doc.get("name");
                String summary = doc.get("summary");
                String id = doc.get("id");
                String participantId = doc.get("participantId");
                String label = doc.get("raw_title");
                boolean isPotentialHit = doc.get("filters") != null;
                list.add(new SearchHit(href, label, summary, score, null, id, participantId, isPotentialHit));
            }
            catch (IOException e) {
                HelpBasePlugin.logError("An error occured while reading search hits", e);
            }
            ++i;
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchIndexWithIndexingProgress getIndex(String locale) {
        Map map = this.indexes;
        synchronized (map) {
            Object index = this.indexes.get(locale);
            if (index == null) {
                index = new SearchIndexWithIndexingProgress(locale, this.getAnalyzer(locale), HelpPlugin.getTocManager());
                this.indexes.put(locale, index);
            }
            return (SearchIndexWithIndexingProgress)index;
        }
    }

    private AnalyzerDescriptor getAnalyzer(String locale) {
        AnalyzerDescriptor analyzerDesc = (AnalyzerDescriptor)this.analyzerDescriptors.get(locale);
        if (analyzerDesc != null) {
            return analyzerDesc;
        }
        analyzerDesc = new AnalyzerDescriptor(locale);
        this.analyzerDescriptors.put(locale, analyzerDesc);
        String lang = analyzerDesc.getLang();
        if (locale != null && !locale.equals(lang)) {
            this.analyzerDescriptors.put(lang, analyzerDesc);
        }
        return analyzerDesc;
    }

    public static String trimQuery(String href) {
        int qloc = href.indexOf(63);
        if (qloc != -1) {
            return href.substring(0, qloc);
        }
        return href;
    }

    public boolean isIndexable(String url) {
        ArrayList list = this.getParticipantDescriptors(LocalSearchManager.getPluginId(url = LocalSearchManager.trimQuery(url)));
        if (list == null) {
            return false;
        }
        int dotLoc = url.lastIndexOf(46);
        String ext = url.substring(dotLoc + 1);
        int i = 0;
        while (i < list.size()) {
            ParticipantDescriptor desc = (ParticipantDescriptor)list.get(i);
            if (desc.matches(ext)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isParticipantEnabled(boolean headless) {
        if (!headless) {
            return BaseHelpSystem.getMode() == 0;
        }
        return true;
    }

    public static String getPluginId(String href) {
        IProduct product;
        int i;
        if ((href = LocalSearchManager.trimQuery(href)).charAt(0) == '/') {
            href = href.substring(1);
        }
        String pluginId = (i = href.indexOf(47)) == -1 ? "" : href.substring(0, i);
        if ("PRODUCT_PLUGIN".equals(pluginId = URLCoder.decode((String)pluginId)) && (product = Platform.getProduct()) != null) {
            pluginId = product.getDefiningBundle().getSymbolicName();
        }
        return pluginId;
    }

    public SearchParticipant getGlobalParticipant(String participantId) {
        ParticipantDescriptor desc = this.getGlobalParticipantDescriptor(participantId);
        return desc != null ? desc.getParticipant() : null;
    }

    public IHelpResource getParticipantCategory(String participantId) {
        ParticipantDescriptor desc = this.getGlobalParticipantDescriptor(participantId);
        return desc != null ? desc.getCategory() : null;
    }

    public URL getParticipantIconURL(String participantId) {
        ParticipantDescriptor desc = this.getGlobalParticipantDescriptor(participantId);
        return desc != null ? desc.getIconURL() : null;
    }

    private ParticipantDescriptor getGlobalParticipantDescriptor(String participantId) {
        if (this.globalSearchParticipants == null) {
            this.createGlobalSearchParticipants();
        }
        int i = 0;
        while (i < this.globalSearchParticipants.size()) {
            ParticipantDescriptor desc = (ParticipantDescriptor)this.globalSearchParticipants.get(i);
            if (desc.getId().equals(participantId)) {
                return desc;
            }
            ++i;
        }
        return null;
    }

    public SearchParticipant getParticipant(String participantId) {
        ParticipantDescriptor desc = (ParticipantDescriptor)this.searchParticipantsById.get(participantId);
        if (desc != null) {
            return desc.getParticipant();
        }
        return null;
    }

    public SearchParticipant getParticipant(String pluginId, String fileName) {
        ArrayList list = this.getParticipantDescriptors(pluginId);
        if (list == null) {
            return null;
        }
        int dotLoc = fileName.lastIndexOf(46);
        String ext = fileName.substring(dotLoc + 1);
        int i = 0;
        while (i < list.size()) {
            ParticipantDescriptor desc = (ParticipantDescriptor)list.get(i);
            if (desc.matches(ext)) {
                return desc.getParticipant();
            }
            ++i;
        }
        return null;
    }

    public boolean isParticipantBound(String pluginId, String participantId) {
        ArrayList list = this.getParticipantDescriptors(pluginId);
        if (list != null) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                ParticipantDescriptor desc = (ParticipantDescriptor)iter.next();
                if (!participantId.equals(desc.getId())) continue;
                return true;
            }
        }
        return false;
    }

    public Set getPluginsWithSearchParticipants() {
        HashSet set = new HashSet();
        this.addSearchBindings(set);
        this.addLuceneSearchBindings(set);
        SearchParticipant[] gps = this.getGlobalParticipants();
        int i = 0;
        while (i < gps.length) {
            block3: {
                Set ids;
                try {
                    ids = gps[i].getContributingPlugins();
                }
                catch (Throwable t) {
                    HelpBasePlugin.logError("Error getting the contributing plugins from help search participant: " + gps[i].getClass().getName() + ". skipping this one.", t);
                    break block3;
                }
                set.addAll(ids);
            }
            ++i;
        }
        return set;
    }

    private void addSearchBindings(HashSet set) {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(SEARCH_PARTICIPANT_XP_FULLNAME);
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (element.getName().equals(BINDING_XP_NAME) || element.getName().equals(SEARCH_PARTICIPANT_XP_NAME)) {
                set.add(element.getContributor().getName());
            }
            ++i;
        }
    }

    private void addLuceneSearchBindings(HashSet set) {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(LUCENE_SEARCH_PARTICIPANT_XP_FULLNAME);
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (element.getName().equals(BINDING_XP_NAME) || element.getName().equals(SEARCH_PARTICIPANT_XP_NAME)) {
                set.add(element.getContributor().getName());
            }
            ++i;
        }
    }

    public void clearSearchParticipants() {
        Iterator iter = this.searchParticipantsById.values().iterator();
        while (iter.hasNext()) {
            ParticipantDescriptor desc = (ParticipantDescriptor)iter.next();
            desc.clear();
        }
    }

    private ArrayList createSearchParticipants(String pluginId) {
        ArrayList list = null;
        list = this.getBindingsForPlugin(pluginId, list, SEARCH_PARTICIPANT_XP_FULLNAME);
        list = this.getBindingsForPlugin(pluginId, list, LUCENE_SEARCH_PARTICIPANT_XP_FULLNAME);
        return list;
    }

    private ArrayList getBindingsForPlugin(String pluginId, ArrayList list, String extensionPointName) {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(extensionPointName);
        ArrayList<IConfigurationElement> binding = null;
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (element.getContributor().getName().equals(pluginId)) {
                if (BINDING_XP_NAME.equals(element.getName())) {
                    String refId = element.getAttribute("participantId");
                    int j = 0;
                    while (j < elements.length) {
                        IConfigurationElement rel = elements[j];
                        if (rel.getName().equals(SEARCH_PARTICIPANT_XP_NAME)) {
                            String id = rel.getAttribute("id");
                            if (rel.getAttribute("extensions") != null && id != null && id.equals(refId)) {
                                if (binding == null) {
                                    binding = new ArrayList<IConfigurationElement>();
                                }
                                binding.add(rel);
                                break;
                            }
                        }
                        ++j;
                    }
                } else if (SEARCH_PARTICIPANT_XP_NAME.equals(element.getName()) && element.getAttribute("extensions") != null && LocalSearchManager.isParticipantEnabled(String.valueOf(true).equals(element.getAttribute("headless")))) {
                    if (list == null) {
                        list = new ArrayList<ParticipantDescriptor>();
                    }
                    ParticipantDescriptor desc = new ParticipantDescriptor(element);
                    list.add(desc);
                    this.searchParticipantsById.put(desc.getId(), desc);
                }
            }
            ++i;
        }
        if (binding != null) {
            list = this.addBoundDescriptors(list, binding);
        }
        return list;
    }

    private ArrayList addBoundDescriptors(ArrayList list, ArrayList binding) {
        int i = 0;
        while (i < binding.size()) {
            IConfigurationElement refEl = (IConfigurationElement)binding.get(i);
            Collection collection = this.searchParticipantsByPlugin.values();
            boolean found = false;
            Iterator iter = collection.iterator();
            block1: while (iter.hasNext()) {
                if (found) break;
                Object entry = iter.next();
                if (entry == PARTICIPANTS_NOT_FOUND) continue;
                ArrayList participants = (ArrayList)entry;
                int j = 0;
                while (j < participants.size()) {
                    ParticipantDescriptor desc = (ParticipantDescriptor)participants.get(j);
                    if (desc.contains(refEl)) {
                        if (list == null) {
                            list = new ArrayList();
                        }
                        list.add(desc);
                        found = true;
                        continue block1;
                    }
                    ++j;
                }
            }
            if (!found) {
                if (list == null) {
                    list = new ArrayList<ParticipantDescriptor>();
                }
                ParticipantDescriptor d = new ParticipantDescriptor(refEl);
                list.add(d);
                this.searchParticipantsById.put(d.getId(), d);
            }
            ++i;
        }
        return list;
    }

    public SearchParticipant[] getGlobalParticipants() {
        if (this.globalSearchParticipants == null) {
            this.createGlobalSearchParticipants();
        }
        ArrayList<SearchParticipant> result = new ArrayList<SearchParticipant>();
        int i = 0;
        while (i < this.globalSearchParticipants.size()) {
            ParticipantDescriptor desc = (ParticipantDescriptor)this.globalSearchParticipants.get(i);
            SearchParticipant p = desc.getParticipant();
            if (p != null) {
                result.add(p);
            }
            ++i;
        }
        return result.toArray(new SearchParticipant[result.size()]);
    }

    private void createGlobalSearchParticipants() {
        this.globalSearchParticipants = new ArrayList();
        this.addSearchParticipants();
        this.addLuceneSearchParticipants();
    }

    private void addSearchParticipants() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(SEARCH_PARTICIPANT_XP_FULLNAME);
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (element.getName().equals(SEARCH_PARTICIPANT_XP_NAME) && element.getAttribute("extensions") == null && LocalSearchManager.isParticipantEnabled(String.valueOf(true).equals(element.getAttribute("headless")))) {
                ParticipantDescriptor desc = new ParticipantDescriptor(element);
                this.globalSearchParticipants.add(desc);
            }
            ++i;
        }
    }

    private void addLuceneSearchParticipants() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(LUCENE_SEARCH_PARTICIPANT_XP_FULLNAME);
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (element.getName().equals(SEARCH_PARTICIPANT_XP_NAME) && element.getAttribute("extensions") == null && LocalSearchManager.isParticipantEnabled(String.valueOf(true).equals(element.getAttribute("headless")))) {
                ParticipantDescriptor desc = new ParticipantDescriptor(element);
                this.globalSearchParticipants.add(desc);
            }
            ++i;
        }
    }

    private ArrayList getParticipantDescriptors(String pluginId) {
        Object result = this.searchParticipantsByPlugin.get(pluginId);
        if (result == null) {
            result = this.createSearchParticipants(pluginId);
            if (result == null) {
                result = PARTICIPANTS_NOT_FOUND;
            }
            this.searchParticipantsByPlugin.put(pluginId, result);
        }
        if (result == PARTICIPANTS_NOT_FOUND) {
            return null;
        }
        return (ArrayList)result;
    }

    public void search(ISearchQuery searchQuery, ISearchHitCollector collector, IProgressMonitor pm) throws QueryTooComplexException {
        SearchIndexWithIndexingProgress index = this.getIndex(searchQuery.getLocale());
        this.ensureIndexUpdated(pm, index);
        if (index.exists()) {
            index.search(searchQuery, collector);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void ensureIndexUpdated(IProgressMonitor pm, SearchIndexWithIndexingProgress index) throws OperationCanceledException {
        progressDistrib = index.getProgressDistributor();
        progressDistrib.addMonitor(pm);
        configurationLocked = false;
        try {
            if (1 == BaseHelpSystem.getMode()) ** GOTO lbl-1000
            try {
                configurationLocked = index.tryLock();
                if (!configurationLocked) {
                    pm.beginTask("", 1);
                    pm.worked(1);
                    pm.done();
lbl12:
                    // 2 sources

                    return;
                }
                ** GOTO lbl-1000
            }
            catch (OverlappingFileLockException v0) {
                if (index.isClosed() || !index.needsUpdating()) {
                    pm.beginTask("", 1);
                    pm.worked(1);
                    pm.done();
                    ** continue;
                }
                if (pm instanceof SearchProgressMonitor) {
                    ((SearchProgressMonitor)pm).started();
                }
                this.updateIndex(pm, index, progressDistrib);
            }
        }
        finally {
            progressDistrib.removeMonitor(pm);
            if (configurationLocked) {
                index.releaseLock();
            }
        }
    }

    private synchronized void updateIndex(IProgressMonitor pm, SearchIndex index, ProgressDistributor progressDistrib) {
        if (index.isClosed() || !index.needsUpdating()) {
            pm.beginTask("", 1);
            pm.worked(1);
            pm.done();
            return;
        }
        try {
            PluginVersionInfo versions = index.getDocPlugins();
            if (versions == null) {
                pm.beginTask("", 1);
                pm.worked(1);
                pm.done();
                return;
            }
            IndexingOperation indexer = new IndexingOperation(index);
            indexer.execute(progressDistrib);
            return;
        }
        catch (OperationCanceledException e) {
            progressDistrib.operationCanceled();
            throw e;
        }
        catch (IndexingOperation.IndexingException e) {
            String msg = "Error indexing documents";
            HelpBasePlugin.logError(msg, e);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Map map = this.indexes;
        synchronized (map) {
            Iterator it = this.indexes.values().iterator();
            while (it.hasNext()) {
                ((SearchIndex)it.next()).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void tocsChanged() {
        ArrayList activeIndexes = new ArrayList();
        Map map = this.indexes;
        synchronized (map) {
            activeIndexes.addAll(this.indexes.values());
        }
        Iterator it = activeIndexes.iterator();
        while (it.hasNext()) {
            SearchIndexWithIndexingProgress ix = (SearchIndexWithIndexingProgress)it.next();
            ix.close();
            Map map2 = this.indexes;
            synchronized (map2) {
                this.indexes.remove(ix.getLocale());
                ProgressDistributor pm = ix.getProgressDistributor();
                pm.beginTask("", 1);
                pm.worked(1);
                pm.done();
                SearchProgressMonitor.reinit(ix.getLocale());
            }
        }
    }

    private static class ParticipantDescriptor
    implements IHelpResource {
        private IConfigurationElement element;
        private SearchParticipant participant;

        public ParticipantDescriptor(IConfigurationElement element) {
            this.element = element;
        }

        public String getId() {
            return this.element.getAttribute("id");
        }

        public boolean matches(String extension) {
            String ext = this.element.getAttribute("extensions");
            if (ext == null) {
                return false;
            }
            StringTokenizer stok = new StringTokenizer(ext, ",");
            while (stok.hasMoreTokens()) {
                String token = stok.nextToken().trim();
                if (!token.equalsIgnoreCase(extension)) continue;
                return true;
            }
            return false;
        }

        public IHelpResource getCategory() {
            return this;
        }

        public SearchParticipant getParticipant() {
            if (this.participant == null) {
                try {
                    Object obj = this.element.createExecutableExtension("participant");
                    if (obj instanceof SearchParticipant) {
                        this.participant = (SearchParticipant)obj;
                        this.participant.init(this.getId());
                    } else if (obj instanceof LuceneSearchParticipant) {
                        LuceneSearchParticipant luceneParticipant = (LuceneSearchParticipant)obj;
                        this.participant = new LuceneSearchParticipantAdapter(luceneParticipant);
                        this.participant.init(this.getId());
                    }
                }
                catch (Throwable t) {
                    HelpPlugin.logError((String)"Exception occurred creating Lucene search participant.", (Throwable)t);
                }
            }
            return this.participant;
        }

        public boolean contains(IConfigurationElement el) {
            return this.element.equals((Object)el);
        }

        public String getHref() {
            return null;
        }

        public String getLabel() {
            return this.element.getAttribute("name");
        }

        public URL getIconURL() {
            String relativePath = this.element.getAttribute("icon");
            if (relativePath == null) {
                return null;
            }
            String bundleId = this.element.getContributor().getName();
            Bundle bundle = Platform.getBundle((String)bundleId);
            if (bundle == null) {
                return null;
            }
            return FileLocator.find((Bundle)bundle, (IPath)new Path(relativePath), null);
        }

        public void clear() {
            if (this.participant != null) {
                try {
                    this.participant.clear();
                }
                catch (Throwable t) {
                    HelpBasePlugin.logError("Error occured in search participant's clear() operation: " + this.participant.getClass().getName(), t);
                }
            }
        }
    }
}

