/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Hashtable;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class HitTestSample
extends JApplet {
    private static final Color STRONG_CARET_COLOR = Color.red;
    private static final Color WEAK_CARET_COLOR = Color.black;
    private TextLayout textLayout;
    private int insertionIndex;
    private static final FontRenderContext DEFAULT_FRC = new FontRenderContext(null, false, false);
    private static final Hashtable map = new Hashtable();
    private static AttributedString helloWorld;
    Dimension preferredSize = new Dimension(400, 250);
    HitPane hitPane;

    static {
        map.put(TextAttribute.SIZE, new Float(18.0));
        helloWorld = new AttributedString("Hello World", map);
    }

    public void buildUI(Container container, AttributedCharacterIterator attributedCharacterIterator) {
        this.textLayout = new TextLayout(attributedCharacterIterator, DEFAULT_FRC);
        this.insertionIndex = 0;
        this.hitPane = new HitPane();
        container.add((Component)this.hitPane, "Center");
        this.hitPane.addMouseListener(new HitTestMouseListener());
    }

    private Point2D computeLayoutOrigin() {
        Dimension dimension = this.getPreferredSize();
        Point2D.Float float_ = new Point2D.Float();
        float_.x = ((float)dimension.width - this.textLayout.getAdvance()) / 2.0f;
        float_.y = ((float)dimension.height - this.textLayout.getDescent() + this.textLayout.getAscent()) / 2.0f;
        return float_;
    }

    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    public void init() {
        AttributedCharacterIterator attributedCharacterIterator = helloWorld.getIterator();
        this.buildUI(this.getContentPane(), attributedCharacterIterator);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("HitTestSample");
        AttributedCharacterIterator attributedCharacterIterator = helloWorld.getIterator();
        HitTestSample hitTestSample = new HitTestSample();
        hitTestSample.buildUI(jFrame.getContentPane(), attributedCharacterIterator);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        ((Component)jFrame).setSize(new Dimension(400, 250));
        ((Component)jFrame).setVisible(true);
    }

    class HitPane
    extends JPanel {
        HitPane() {
        }

        public void HitPane() {
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            this.setBackground(Color.white);
            Graphics2D graphics2D = (Graphics2D)graphics;
            Point2D point2D = HitTestSample.this.computeLayoutOrigin();
            graphics2D.translate(point2D.getX(), point2D.getY());
            HitTestSample.this.textLayout.draw(graphics2D, 0.0f, 0.0f);
            Shape[] shapeArray = HitTestSample.this.textLayout.getCaretShapes(HitTestSample.this.insertionIndex);
            graphics2D.setColor(STRONG_CARET_COLOR);
            graphics2D.draw(shapeArray[0]);
            if (shapeArray[1] != null) {
                graphics2D.setColor(WEAK_CARET_COLOR);
                graphics2D.draw(shapeArray[1]);
            }
        }
    }

    private class HitTestMouseListener
    extends MouseAdapter {
        HitTestMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Point2D point2D = HitTestSample.this.computeLayoutOrigin();
            float f = (float)((double)mouseEvent.getX() - point2D.getX());
            float f2 = (float)((double)mouseEvent.getY() - point2D.getY());
            TextHitInfo textHitInfo = HitTestSample.this.textLayout.hitTestChar(f, f2);
            HitTestSample.this.insertionIndex = textHitInfo.getInsertionIndex();
            HitTestSample.this.hitPane.repaint();
        }
    }
}

