/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;

public class InternalFrameEventDemo
extends JFrame
implements InternalFrameListener,
ActionListener {
    JTextArea display;
    JDesktopPane desktop = new JDesktopPane();
    JInternalFrame displayWindow;
    JInternalFrame listenedToWindow;
    static final String SHOW = "show";
    static final String CLEAR = "clear";
    String newline = "\n";
    static final int desktopWidth = 500;
    static final int desktopHeight = 300;

    public InternalFrameEventDemo(String string) {
        super(string);
        this.desktop.putClientProperty("JDesktopPane.dragMode", "outline");
        this.desktop.setPreferredSize(new Dimension(500, 300));
        this.setContentPane(this.desktop);
        this.createDisplayWindow();
        this.desktop.add(this.displayWindow);
        Dimension dimension = this.displayWindow.getSize();
        this.displayWindow.setSize(500, dimension.height);
    }

    protected void createDisplayWindow() {
        JButton jButton = new JButton("Show internal frame");
        jButton.setActionCommand(SHOW);
        jButton.addActionListener(this);
        JButton jButton2 = new JButton("Clear event info");
        jButton2.setActionCommand(CLEAR);
        jButton2.addActionListener(this);
        this.display = new JTextArea(3, 30);
        this.display.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.display);
        jScrollPane.setPreferredSize(new Dimension(200, 75));
        jScrollPane.setMinimumSize(new Dimension(10, 10));
        this.displayWindow = new JInternalFrame("Event Watcher", true, false, false, true);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        jButton.setAlignmentX(0.5f);
        jPanel.add(jButton);
        jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        jPanel.add(jScrollPane);
        jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        jButton2.setAlignmentX(0.5f);
        jPanel.add(jButton2);
        this.displayWindow.setContentPane(jPanel);
        this.displayWindow.pack();
        this.displayWindow.setVisible(true);
    }

    public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
        this.displayMessage("Internal frame closing", internalFrameEvent);
    }

    public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
        this.displayMessage("Internal frame closed", internalFrameEvent);
    }

    public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
        this.displayMessage("Internal frame opened", internalFrameEvent);
    }

    public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
        this.displayMessage("Internal frame iconified", internalFrameEvent);
    }

    public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
        this.displayMessage("Internal frame deiconified", internalFrameEvent);
    }

    public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
        this.displayMessage("Internal frame activated", internalFrameEvent);
    }

    public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
        this.displayMessage("Internal frame deactivated", internalFrameEvent);
    }

    void displayMessage(String string, InternalFrameEvent internalFrameEvent) {
        String string2 = string + ": " + internalFrameEvent.getSource();
        this.display.append(string2 + this.newline);
        this.display.setCaretPosition(this.display.getDocument().getLength());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (SHOW.equals(actionEvent.getActionCommand())) {
            if (this.listenedToWindow == null) {
                this.listenedToWindow = new JInternalFrame("Event Generator", true, true, true, true);
                this.listenedToWindow.setDefaultCloseOperation(1);
                this.listenedToWindow.addInternalFrameListener(this);
                this.desktop.add(this.listenedToWindow);
                this.listenedToWindow.setSize(300, 100);
                this.listenedToWindow.setLocation(250 - this.listenedToWindow.getWidth() / 2, 300 - this.listenedToWindow.getHeight());
            }
            this.listenedToWindow.setVisible(true);
        } else {
            this.display.setText("");
        }
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        InternalFrameEventDemo internalFrameEventDemo = new InternalFrameEventDemo("InternalFrameEventDemo");
        internalFrameEventDemo.setDefaultCloseOperation(3);
        internalFrameEventDemo.pack();
        internalFrameEventDemo.setVisible(true);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InternalFrameEventDemo.createAndShowGUI();
            }
        });
    }
}

