/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.GridLayout;
import java.io.IOException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;

public class TreeDemo
extends JPanel
implements TreeSelectionListener {
    private JEditorPane htmlPane;
    private JTree tree;
    private URL helpURL;
    private static boolean DEBUG = false;
    private static boolean playWithLineStyle = false;
    private static String lineStyle = "Horizontal";
    private static boolean useSystemLookAndFeel = false;
    static /* synthetic */ Class class$TreeDemo;

    public TreeDemo() {
        super(new GridLayout(1, 0));
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("The Java Series");
        this.createNodes(defaultMutableTreeNode);
        this.tree = new JTree(defaultMutableTreeNode);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        if (playWithLineStyle) {
            System.out.println("line style = " + lineStyle);
            this.tree.putClientProperty("JTree.lineStyle", lineStyle);
        }
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        this.htmlPane = new JEditorPane();
        this.htmlPane.setEditable(false);
        this.initHelp();
        JScrollPane jScrollPane2 = new JScrollPane(this.htmlPane);
        JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.setTopComponent(jScrollPane);
        jSplitPane.setBottomComponent(jScrollPane2);
        Dimension dimension = new Dimension(100, 50);
        jScrollPane2.setMinimumSize(dimension);
        jScrollPane.setMinimumSize(dimension);
        jSplitPane.setDividerLocation(100);
        jSplitPane.setPreferredSize(new Dimension(500, 300));
        this.add(jSplitPane);
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            return;
        }
        Object object = defaultMutableTreeNode.getUserObject();
        if (defaultMutableTreeNode.isLeaf()) {
            BookInfo bookInfo = (BookInfo)object;
            this.displayURL(bookInfo.bookURL);
            if (DEBUG) {
                System.out.print(bookInfo.bookURL + ":  \n    ");
            }
        } else {
            this.displayURL(this.helpURL);
        }
        if (DEBUG) {
            System.out.println(object.toString());
        }
    }

    private void initHelp() {
        String string = "TreeDemoHelp.html";
        this.helpURL = (class$TreeDemo == null ? (class$TreeDemo = TreeDemo.class$("TreeDemo")) : class$TreeDemo).getResource(string);
        if (this.helpURL == null) {
            System.err.println("Couldn't open help file: " + string);
        } else if (DEBUG) {
            System.out.println("Help URL is " + this.helpURL);
        }
        this.displayURL(this.helpURL);
    }

    private void displayURL(URL uRL) {
        try {
            if (uRL != null) {
                this.htmlPane.setPage(uRL);
            } else {
                this.htmlPane.setText("File Not Found");
                if (DEBUG) {
                    System.out.println("Attempted to display a null URL.");
                }
            }
        }
        catch (IOException iOException) {
            System.err.println("Attempted to read a bad URL: " + uRL);
        }
    }

    private void createNodes(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        DefaultMutableTreeNode defaultMutableTreeNode3 = null;
        defaultMutableTreeNode2 = new DefaultMutableTreeNode("Books for Java Programmers");
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode3 = new DefaultMutableTreeNode(new BookInfo("The Java Tutorial: A Short Course on the Basics", "tutorial.html"));
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        defaultMutableTreeNode3 = new DefaultMutableTreeNode(new BookInfo("The Java Tutorial Continued: The Rest of the JDK", "tutorialcont.html"));
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        defaultMutableTreeNode3 = new DefaultMutableTreeNode(new BookInfo("The JFC Swing Tutorial: A Guide to Constructing GUIs", "swingtutorial.html"));
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        defaultMutableTreeNode3 = new DefaultMutableTreeNode(new BookInfo("Effective Java Programming Language Guide", "bloch.html"));
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        defaultMutableTreeNode3 = new DefaultMutableTreeNode(new BookInfo("The Java Programming Language", "arnold.html"));
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        defaultMutableTreeNode3 = new DefaultMutableTreeNode(new BookInfo("The Java Developers Almanac", "chan.html"));
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        defaultMutableTreeNode2 = new DefaultMutableTreeNode("Books for Java Implementers");
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode3 = new DefaultMutableTreeNode(new BookInfo("The Java Virtual Machine Specification", "vm.html"));
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        defaultMutableTreeNode3 = new DefaultMutableTreeNode(new BookInfo("The Java Language Specification", "jls.html"));
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
    }

    private static void createAndShowGUI() {
        if (useSystemLookAndFeel) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception exception) {
                System.err.println("Couldn't use system look and feel.");
            }
        }
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame jFrame = new JFrame("TreeDemo");
        jFrame.setDefaultCloseOperation(3);
        TreeDemo treeDemo = new TreeDemo();
        treeDemo.setOpaque(true);
        jFrame.setContentPane(treeDemo);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TreeDemo.createAndShowGUI();
            }
        });
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class BookInfo {
        public String bookName;
        public URL bookURL;

        public BookInfo(String string, String string2) {
            this.bookName = string;
            this.bookURL = (class$TreeDemo == null ? (class$TreeDemo = TreeDemo.class$("TreeDemo")) : class$TreeDemo).getResource(string2);
            if (this.bookURL == null) {
                System.err.println("Couldn't find file: " + string2);
            }
        }

        public String toString() {
            return this.bookName;
        }
    }
}

