/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class TextComponentDemo
extends JFrame {
    JTextPane textPane;
    AbstractDocument doc;
    static final int MAX_CHARACTERS = 300;
    JTextArea changeLog;
    String newline = "\n";
    HashMap actions;
    protected UndoAction undoAction;
    protected RedoAction redoAction;
    protected UndoManager undo = new UndoManager();

    public TextComponentDemo() {
        super("TextComponentDemo");
        this.textPane = new JTextPane();
        this.textPane.setCaretPosition(0);
        this.textPane.setMargin(new Insets(5, 5, 5, 5));
        StyledDocument styledDocument = this.textPane.getStyledDocument();
        if (styledDocument instanceof AbstractDocument) {
            this.doc = (AbstractDocument)((Object)styledDocument);
            this.doc.setDocumentFilter(new DocumentSizeFilter(300));
        } else {
            System.err.println("Text pane's document isn't an AbstractDocument!");
            System.exit(-1);
        }
        JScrollPane jScrollPane = new JScrollPane(this.textPane);
        jScrollPane.setPreferredSize(new Dimension(200, 200));
        this.changeLog = new JTextArea(5, 30);
        this.changeLog.setEditable(false);
        JScrollPane jScrollPane2 = new JScrollPane(this.changeLog);
        JSplitPane jSplitPane = new JSplitPane(0, jScrollPane, jScrollPane2);
        jSplitPane.setOneTouchExpandable(true);
        JPanel jPanel = new JPanel(new GridLayout(1, 1));
        CaretListenerLabel caretListenerLabel = new CaretListenerLabel("Caret Status");
        jPanel.add(caretListenerLabel);
        this.getContentPane().add((Component)jSplitPane, "Center");
        this.getContentPane().add((Component)jPanel, "Last");
        this.createActionTable(this.textPane);
        JMenu jMenu = this.createEditMenu();
        JMenu jMenu2 = this.createStyleMenu();
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        this.setJMenuBar(jMenuBar);
        this.addBindings();
        this.initDocument();
        this.doc.addUndoableEditListener(new MyUndoableEditListener());
        this.textPane.addCaretListener(caretListenerLabel);
        this.doc.addDocumentListener(new MyDocumentListener());
    }

    protected void addBindings() {
        InputMap inputMap = this.textPane.getInputMap();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(66, 2);
        inputMap.put(keyStroke, "caret-backward");
        keyStroke = KeyStroke.getKeyStroke(70, 2);
        inputMap.put(keyStroke, "caret-forward");
        keyStroke = KeyStroke.getKeyStroke(80, 2);
        inputMap.put(keyStroke, "caret-up");
        keyStroke = KeyStroke.getKeyStroke(78, 2);
        inputMap.put(keyStroke, "caret-down");
    }

    protected JMenu createEditMenu() {
        JMenu jMenu = new JMenu("Edit");
        this.undoAction = new UndoAction();
        jMenu.add(this.undoAction);
        this.redoAction = new RedoAction();
        jMenu.add(this.redoAction);
        jMenu.addSeparator();
        jMenu.add(this.getActionByName("cut-to-clipboard"));
        jMenu.add(this.getActionByName("copy-to-clipboard"));
        jMenu.add(this.getActionByName("paste-from-clipboard"));
        jMenu.addSeparator();
        jMenu.add(this.getActionByName("select-all"));
        return jMenu;
    }

    protected JMenu createStyleMenu() {
        JMenu jMenu = new JMenu("Style");
        StyledEditorKit.StyledTextAction styledTextAction = new StyledEditorKit.BoldAction();
        styledTextAction.putValue("Name", "Bold");
        jMenu.add(styledTextAction);
        styledTextAction = new StyledEditorKit.ItalicAction();
        styledTextAction.putValue("Name", "Italic");
        jMenu.add(styledTextAction);
        styledTextAction = new StyledEditorKit.UnderlineAction();
        styledTextAction.putValue("Name", "Underline");
        jMenu.add(styledTextAction);
        jMenu.addSeparator();
        jMenu.add(new StyledEditorKit.FontSizeAction("12", 12));
        jMenu.add(new StyledEditorKit.FontSizeAction("14", 14));
        jMenu.add(new StyledEditorKit.FontSizeAction("18", 18));
        jMenu.addSeparator();
        jMenu.add(new StyledEditorKit.FontFamilyAction("Serif", "Serif"));
        jMenu.add(new StyledEditorKit.FontFamilyAction("SansSerif", "SansSerif"));
        jMenu.addSeparator();
        jMenu.add(new StyledEditorKit.ForegroundAction("Red", Color.red));
        jMenu.add(new StyledEditorKit.ForegroundAction("Green", Color.green));
        jMenu.add(new StyledEditorKit.ForegroundAction("Blue", Color.blue));
        jMenu.add(new StyledEditorKit.ForegroundAction("Black", Color.black));
        return jMenu;
    }

    protected void initDocument() {
        String[] stringArray = new String[]{"Use the mouse to place the caret.", "Use the edit menu to cut, copy, paste, and select text.", "Also to undo and redo changes.", "Use the style menu to change the style of the text.", "Use these emacs key bindings to move the caret:", "ctrl-f, ctrl-b, ctrl-n, ctrl-p."};
        SimpleAttributeSet[] simpleAttributeSetArray = this.initAttributes(stringArray.length);
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                this.doc.insertString(this.doc.getLength(), stringArray[i] + this.newline, simpleAttributeSetArray[i]);
            }
        }
        catch (BadLocationException badLocationException) {
            System.err.println("Couldn't insert initial text.");
        }
    }

    protected SimpleAttributeSet[] initAttributes(int n) {
        SimpleAttributeSet[] simpleAttributeSetArray = new SimpleAttributeSet[n];
        simpleAttributeSetArray[0] = new SimpleAttributeSet();
        StyleConstants.setFontFamily(simpleAttributeSetArray[0], "SansSerif");
        StyleConstants.setFontSize(simpleAttributeSetArray[0], 16);
        simpleAttributeSetArray[1] = new SimpleAttributeSet(simpleAttributeSetArray[0]);
        StyleConstants.setBold(simpleAttributeSetArray[1], true);
        simpleAttributeSetArray[2] = new SimpleAttributeSet(simpleAttributeSetArray[0]);
        StyleConstants.setItalic(simpleAttributeSetArray[2], true);
        simpleAttributeSetArray[3] = new SimpleAttributeSet(simpleAttributeSetArray[0]);
        StyleConstants.setFontSize(simpleAttributeSetArray[3], 20);
        simpleAttributeSetArray[4] = new SimpleAttributeSet(simpleAttributeSetArray[0]);
        StyleConstants.setFontSize(simpleAttributeSetArray[4], 12);
        simpleAttributeSetArray[5] = new SimpleAttributeSet(simpleAttributeSetArray[0]);
        StyleConstants.setForeground(simpleAttributeSetArray[5], Color.red);
        return simpleAttributeSetArray;
    }

    private void createActionTable(JTextComponent jTextComponent) {
        this.actions = new HashMap();
        Action[] actionArray = jTextComponent.getActions();
        for (int i = 0; i < actionArray.length; ++i) {
            Action action = actionArray[i];
            this.actions.put(action.getValue("Name"), action);
        }
    }

    private Action getActionByName(String string) {
        return (Action)this.actions.get(string);
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        TextComponentDemo textComponentDemo = new TextComponentDemo();
        textComponentDemo.setDefaultCloseOperation(3);
        textComponentDemo.pack();
        textComponentDemo.setVisible(true);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TextComponentDemo.createAndShowGUI();
            }
        });
    }

    class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super("Redo");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                TextComponentDemo.this.undo.redo();
            }
            catch (CannotRedoException cannotRedoException) {
                System.out.println("Unable to redo: " + cannotRedoException);
                cannotRedoException.printStackTrace();
            }
            this.updateRedoState();
            TextComponentDemo.this.undoAction.updateUndoState();
        }

        protected void updateRedoState() {
            if (TextComponentDemo.this.undo.canRedo()) {
                this.setEnabled(true);
                this.putValue("Name", TextComponentDemo.this.undo.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Redo");
            }
        }
    }

    class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super("Undo");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                TextComponentDemo.this.undo.undo();
            }
            catch (CannotUndoException cannotUndoException) {
                System.out.println("Unable to undo: " + cannotUndoException);
                cannotUndoException.printStackTrace();
            }
            this.updateUndoState();
            TextComponentDemo.this.redoAction.updateRedoState();
        }

        protected void updateUndoState() {
            if (TextComponentDemo.this.undo.canUndo()) {
                this.setEnabled(true);
                this.putValue("Name", TextComponentDemo.this.undo.getUndoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Undo");
            }
        }
    }

    protected class MyDocumentListener
    implements DocumentListener {
        protected MyDocumentListener() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.displayEditInfo(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.displayEditInfo(documentEvent);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.displayEditInfo(documentEvent);
        }

        private void displayEditInfo(DocumentEvent documentEvent) {
            Document document = documentEvent.getDocument();
            int n = documentEvent.getLength();
            TextComponentDemo.this.changeLog.append(documentEvent.getType().toString() + ": " + n + " character" + (n == 1 ? ". " : "s. ") + " Text length = " + document.getLength() + "." + TextComponentDemo.this.newline);
        }
    }

    protected class MyUndoableEditListener
    implements UndoableEditListener {
        protected MyUndoableEditListener() {
        }

        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            TextComponentDemo.this.undo.addEdit(undoableEditEvent.getEdit());
            TextComponentDemo.this.undoAction.updateUndoState();
            TextComponentDemo.this.redoAction.updateRedoState();
        }
    }

    protected class CaretListenerLabel
    extends JLabel
    implements CaretListener {
        public CaretListenerLabel(String string) {
            super(string);
        }

        public void caretUpdate(CaretEvent caretEvent) {
            this.displaySelectionInfo(caretEvent.getDot(), caretEvent.getMark());
        }

        protected void displaySelectionInfo(int n, int n2) {
            SwingUtilities.invokeLater(new Runnable(this, n, n2){
                private final /* synthetic */ int val$dot;
                private final /* synthetic */ int val$mark;
                private final /* synthetic */ CaretListenerLabel this$1;
                {
                    this.this$1 = caretListenerLabel;
                    this.val$dot = n;
                    this.val$mark = n2;
                }

                public void run() {
                    if (this.val$dot == this.val$mark) {
                        try {
                            Rectangle rectangle = CaretListenerLabel.access$000((CaretListenerLabel)this.this$1).textPane.modelToView(this.val$dot);
                            this.this$1.setText("caret: text position: " + this.val$dot + ", view location = [" + rectangle.x + ", " + rectangle.y + "]" + CaretListenerLabel.access$000((CaretListenerLabel)this.this$1).newline);
                        }
                        catch (BadLocationException badLocationException) {
                            this.this$1.setText("caret: text position: " + this.val$dot + CaretListenerLabel.access$000((CaretListenerLabel)this.this$1).newline);
                        }
                    } else if (this.val$dot < this.val$mark) {
                        this.this$1.setText("selection from: " + this.val$dot + " to " + this.val$mark + CaretListenerLabel.access$000((CaretListenerLabel)this.this$1).newline);
                    } else {
                        this.this$1.setText("selection from: " + this.val$mark + " to " + this.val$dot + CaretListenerLabel.access$000((CaretListenerLabel)this.this$1).newline);
                    }
                }
            });
        }

        static /* synthetic */ TextComponentDemo access$000(CaretListenerLabel caretListenerLabel) {
            return caretListenerLabel.TextComponentDemo.this;
        }
    }
}

