/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class ProgressBarDemo
extends JPanel
implements ActionListener {
    public static final int ONE_SECOND = 1000;
    private JProgressBar progressBar;
    private Timer timer;
    private JButton startButton;
    private LongTask task = new LongTask();
    private JTextArea taskOutput;
    private String newline = "\n";

    public ProgressBarDemo() {
        super(new BorderLayout());
        this.startButton = new JButton("Start");
        this.startButton.setActionCommand("start");
        this.startButton.addActionListener(this);
        this.progressBar = new JProgressBar(0, this.task.getLengthOfTask());
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        this.taskOutput = new JTextArea(5, 20);
        this.taskOutput.setMargin(new Insets(5, 5, 5, 5));
        this.taskOutput.setEditable(false);
        this.taskOutput.setCursor(null);
        JPanel jPanel = new JPanel();
        jPanel.add(this.startButton);
        jPanel.add(this.progressBar);
        this.add((Component)jPanel, "First");
        this.add((Component)new JScrollPane(this.taskOutput), "Center");
        this.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.timer = new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProgressBarDemo.this.progressBar.setValue(ProgressBarDemo.this.task.getCurrent());
                String string = ProgressBarDemo.this.task.getMessage();
                if (string != null) {
                    ProgressBarDemo.this.taskOutput.append(string + ProgressBarDemo.this.newline);
                    ProgressBarDemo.this.taskOutput.setCaretPosition(ProgressBarDemo.this.taskOutput.getDocument().getLength());
                }
                if (ProgressBarDemo.this.task.isDone()) {
                    Toolkit.getDefaultToolkit().beep();
                    ProgressBarDemo.this.timer.stop();
                    ProgressBarDemo.this.startButton.setEnabled(true);
                    ProgressBarDemo.this.setCursor(null);
                    ProgressBarDemo.this.progressBar.setValue(ProgressBarDemo.this.progressBar.getMinimum());
                }
            }
        });
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.startButton.setEnabled(false);
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.task.go();
        this.timer.start();
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame jFrame = new JFrame("ProgressBarDemo");
        jFrame.setDefaultCloseOperation(3);
        ProgressBarDemo progressBarDemo = new ProgressBarDemo();
        progressBarDemo.setOpaque(true);
        jFrame.setContentPane(progressBarDemo);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ProgressBarDemo.createAndShowGUI();
            }
        });
    }
}

