/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ListDemo
extends JPanel
implements ListSelectionListener {
    private JList list;
    private DefaultListModel listModel = new DefaultListModel();
    private static final String hireString = "Hire";
    private static final String fireString = "Fire";
    private JButton fireButton;
    private JTextField employeeName;

    public ListDemo() {
        super(new BorderLayout());
        this.listModel.addElement("Alan Sommerer");
        this.listModel.addElement("Alison Huml");
        this.listModel.addElement("Kathy Walrath");
        this.listModel.addElement("Lisa Friendly");
        this.listModel.addElement("Mary Campione");
        this.listModel.addElement("Sharon Zakhour");
        this.list = new JList(this.listModel);
        this.list.setSelectionMode(0);
        this.list.setSelectedIndex(0);
        this.list.addListSelectionListener(this);
        this.list.setVisibleRowCount(5);
        JScrollPane jScrollPane = new JScrollPane(this.list);
        JButton jButton = new JButton(hireString);
        HireListener hireListener = new HireListener(jButton);
        jButton.setActionCommand(hireString);
        jButton.addActionListener(hireListener);
        jButton.setEnabled(false);
        this.fireButton = new JButton(fireString);
        this.fireButton.setActionCommand(fireString);
        this.fireButton.addActionListener(new FireListener());
        this.employeeName = new JTextField(10);
        this.employeeName.addActionListener(hireListener);
        this.employeeName.getDocument().addDocumentListener(hireListener);
        String string = this.listModel.getElementAt(this.list.getSelectedIndex()).toString();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        jPanel.add(this.fireButton);
        jPanel.add(Box.createHorizontalStrut(5));
        jPanel.add(new JSeparator(1));
        jPanel.add(Box.createHorizontalStrut(5));
        jPanel.add(this.employeeName);
        jPanel.add(jButton);
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)jScrollPane, "Center");
        this.add((Component)jPanel, "Last");
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            if (this.list.getSelectedIndex() == -1) {
                this.fireButton.setEnabled(false);
            } else {
                this.fireButton.setEnabled(true);
            }
        }
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame jFrame = new JFrame("ListDemo");
        jFrame.setDefaultCloseOperation(3);
        ListDemo listDemo = new ListDemo();
        listDemo.setOpaque(true);
        jFrame.setContentPane(listDemo);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ListDemo.createAndShowGUI();
            }
        });
    }

    class HireListener
    implements ActionListener,
    DocumentListener {
        private boolean alreadyEnabled = false;
        private JButton button;

        public HireListener(JButton jButton) {
            this.button = jButton;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = ListDemo.this.employeeName.getText();
            if (string.equals("") || this.alreadyInList(string)) {
                Toolkit.getDefaultToolkit().beep();
                ListDemo.this.employeeName.requestFocusInWindow();
                ListDemo.this.employeeName.selectAll();
                return;
            }
            int n = ListDemo.this.list.getSelectedIndex();
            n = n == -1 ? 0 : ++n;
            ListDemo.this.listModel.insertElementAt(ListDemo.this.employeeName.getText(), n);
            ListDemo.this.employeeName.requestFocusInWindow();
            ListDemo.this.employeeName.setText("");
            ListDemo.this.list.setSelectedIndex(n);
            ListDemo.this.list.ensureIndexIsVisible(n);
        }

        protected boolean alreadyInList(String string) {
            return ListDemo.this.listModel.contains(string);
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.enableButton();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.handleEmptyTextField(documentEvent);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            if (!this.handleEmptyTextField(documentEvent)) {
                this.enableButton();
            }
        }

        private void enableButton() {
            if (!this.alreadyEnabled) {
                this.button.setEnabled(true);
            }
        }

        private boolean handleEmptyTextField(DocumentEvent documentEvent) {
            if (documentEvent.getDocument().getLength() <= 0) {
                this.button.setEnabled(false);
                this.alreadyEnabled = false;
                return true;
            }
            return false;
        }
    }

    class FireListener
    implements ActionListener {
        FireListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = ListDemo.this.list.getSelectedIndex();
            ListDemo.this.listModel.remove(n);
            int n2 = ListDemo.this.listModel.getSize();
            if (n2 == 0) {
                ListDemo.this.fireButton.setEnabled(false);
            } else {
                if (n == ListDemo.this.listModel.getSize()) {
                    --n;
                }
                ListDemo.this.list.setSelectedIndex(n);
                ListDemo.this.list.ensureIndexIsVisible(n);
            }
        }
    }
}

