/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.JFormattedTextField;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class IntegerEditor
extends DefaultCellEditor {
    JFormattedTextField ftf = (JFormattedTextField)this.getComponent();
    NumberFormat integerFormat;
    private Integer minimum;
    private Integer maximum;
    private boolean DEBUG = false;

    public IntegerEditor(int n, int n2) {
        super(new JFormattedTextField());
        this.minimum = new Integer(n);
        this.maximum = new Integer(n2);
        this.integerFormat = NumberFormat.getIntegerInstance();
        NumberFormatter numberFormatter = new NumberFormatter(this.integerFormat);
        numberFormatter.setFormat(this.integerFormat);
        numberFormatter.setMinimum(this.minimum);
        numberFormatter.setMaximum(this.maximum);
        this.ftf.setFormatterFactory(new DefaultFormatterFactory(numberFormatter));
        this.ftf.setValue(this.minimum);
        this.ftf.setHorizontalAlignment(11);
        this.ftf.setFocusLostBehavior(3);
        this.ftf.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "check");
        this.ftf.getActionMap().put("check", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!IntegerEditor.this.ftf.isEditValid()) {
                    if (IntegerEditor.this.userSaysRevert()) {
                        IntegerEditor.this.ftf.postActionEvent();
                    }
                } else {
                    try {
                        IntegerEditor.this.ftf.commitEdit();
                        IntegerEditor.this.ftf.postActionEvent();
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        JFormattedTextField jFormattedTextField = (JFormattedTextField)super.getTableCellEditorComponent(jTable, object, bl, n, n2);
        jFormattedTextField.setValue(object);
        return jFormattedTextField;
    }

    public Object getCellEditorValue() {
        JFormattedTextField jFormattedTextField = (JFormattedTextField)this.getComponent();
        Object object = jFormattedTextField.getValue();
        if (object instanceof Integer) {
            return object;
        }
        if (object instanceof Number) {
            return new Integer(((Number)object).intValue());
        }
        if (this.DEBUG) {
            System.out.println("getCellEditorValue: o isn't a Number");
        }
        try {
            return this.integerFormat.parseObject(object.toString());
        }
        catch (ParseException parseException) {
            System.err.println("getCellEditorValue: can't parse o: " + object);
            return null;
        }
    }

    public boolean stopCellEditing() {
        JFormattedTextField jFormattedTextField = (JFormattedTextField)this.getComponent();
        if (jFormattedTextField.isEditValid()) {
            try {
                jFormattedTextField.commitEdit();
            }
            catch (ParseException parseException) {}
        } else if (!this.userSaysRevert()) {
            return false;
        }
        return super.stopCellEditing();
    }

    protected boolean userSaysRevert() {
        Toolkit.getDefaultToolkit().beep();
        this.ftf.selectAll();
        Object[] objectArray = new Object[]{"Edit", "Revert"};
        int n = JOptionPane.showOptionDialog(SwingUtilities.getWindowAncestor(this.ftf), "The value must be an integer between " + this.minimum + " and " + this.maximum + ".\n" + "You can either continue editing " + "or revert to the last valid value.", "Invalid Text Entered", 0, 0, null, objectArray, objectArray[1]);
        if (n == 1) {
            this.ftf.setValue(this.ftf.getValue());
            return true;
        }
        return false;
    }
}

