/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JApplet;
import javax.swing.JPanel;

public class RaceApplet
extends JApplet
implements Runnable {
    private static final int NUMRUNNERS = 2;
    private static final int SPACING = 20;
    private Runner[] runners = new Runner[2];
    private Thread updateThread;

    public void init() {
        String string = this.getParameter("type");
        int n = 0;
        while (n < 2) {
            this.runners[n] = new Runner();
            if (string.compareTo("unfair") == 0) {
                this.runners[n].setPriority(n + 2);
            } else {
                this.runners[n].setPriority(2);
            }
            ++n;
        }
        if (this.updateThread == null) {
            this.updateThread = new Thread((Runnable)this, "Thread Race");
            this.updateThread.setPriority(4);
        }
        this.addMouseListener(new MyAdapter());
        this.setContentPane(new AppletContentPane());
    }

    public void run() {
        Thread thread = Thread.currentThread();
        while (this.updateThread == thread) {
            this.repaint();
            try {
                Thread.sleep(3L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void stop() {
        int n = 0;
        while (n < 2) {
            if (this.runners[n].isAlive()) {
                this.runners[n] = null;
            }
            ++n;
        }
        if (this.updateThread.isAlive()) {
            this.updateThread = null;
        }
    }

    static /* synthetic */ int access$0() {
        return 2;
    }

    static /* synthetic */ int access$2() {
        return 20;
    }

    class MyAdapter
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            if (!RaceApplet.this.updateThread.isAlive()) {
                RaceApplet.this.updateThread.start();
            }
            int n = 0;
            while (n < RaceApplet.access$0()) {
                if (!RaceApplet.this.runners[n].isAlive()) {
                    RaceApplet.this.runners[n].start();
                }
                ++n;
            }
        }

        MyAdapter() {
            RaceApplet.this = RaceApplet.this;
        }
    }

    class AppletContentPane
    extends JPanel {
        public void paintComponent(Graphics graphics) {
            int n;
            super.paintComponent(graphics);
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
            graphics.setColor(Color.black);
            int n2 = 0;
            while (n2 < RaceApplet.access$0()) {
                n = RaceApplet.this.runners[n2].getPriority();
                graphics.drawString(new Integer(n).toString(), 0, (n2 + 1) * RaceApplet.access$2());
                ++n2;
            }
            n = 0;
            while (n < RaceApplet.access$0()) {
                graphics.drawLine(RaceApplet.access$2(), (n + 1) * RaceApplet.access$2(), RaceApplet.access$2() + ((RaceApplet)RaceApplet.this).runners[n].tick / 23000, (n + 1) * RaceApplet.access$2());
                ++n;
            }
        }

        AppletContentPane() {
            RaceApplet.this = RaceApplet.this;
        }
    }
}

