/*
 * Decompiled with CFR 0.152.
 */
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class Philosopher
extends JLabel
implements Runnable {
    private Chopstick leftStick;
    private Chopstick rightStick;
    private boolean sated;
    private DiningPhilosophers parent;
    private int position;
    Thread philThread;

    public Philosopher(DiningPhilosophers diningPhilosophers, int n, ImageIcon imageIcon) {
        super(diningPhilosophers.names[n], imageIcon, 0);
        this.parent = diningPhilosophers;
        this.position = n;
        this.setVerticalTextPosition(3);
        this.setHorizontalTextPosition(0);
        this.rightStick = diningPhilosophers.chopsticks[n];
        this.leftStick = n == 0 ? diningPhilosophers.chopsticks[4] : diningPhilosophers.chopsticks[n - 1];
        this.sated = false;
        this.philThread = new Thread(this);
    }

    public void run() {
        try {
            while (true) {
                Thread.sleep((int)(Math.random() * (double)this.parent.grabDelay));
                this.setText("     ");
                this.rightStick.grab();
                this.setIcon(this.parent.imgs[1]);
                Thread.sleep((int)(Math.random() * (double)this.parent.grabDelay));
                this.leftStick.grab();
                this.setIcon(this.parent.imgs[2]);
                Thread.sleep((int)(Math.random() * (double)this.parent.grabDelay));
                this.rightStick.release();
                this.leftStick.release();
                this.setIcon(this.parent.imgs[0]);
                this.setText("Mmmm!");
                this.sated = true;
                Thread.sleep((int)(Math.random() * (double)this.parent.grabDelay * 4.0));
                this.sated = false;
            }
        }
        catch (InterruptedException interruptedException) {
            this.leftStick.releaseIfMine();
            this.rightStick.releaseIfMine();
            this.setIcon(this.parent.imgs[0]);
            this.setText(this.parent.names[this.position]);
            this.sated = false;
            this.philThread = new Thread(this);
            return;
        }
    }
}

