/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Container;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SpinnerDemo3
extends JPanel
implements ChangeListener {
    protected Calendar calendar;
    protected JSpinner dateSpinner;
    protected Color SPRING_COLOR = new Color(0, 204, 51);
    protected Color SUMMER_COLOR = Color.RED;
    protected Color FALL_COLOR = new Color(255, 153, 0);
    protected Color WINTER_COLOR = Color.CYAN;

    public SpinnerDemo3(boolean bl) {
        super(new SpringLayout());
        String[] stringArray = new String[]{"Month: ", "Year: ", "Another Date: "};
        int n = stringArray.length;
        this.calendar = Calendar.getInstance();
        JFormattedTextField jFormattedTextField = null;
        Object[] objectArray = SpinnerDemo3.getMonthStrings();
        SpinnerListModel spinnerListModel = null;
        spinnerListModel = bl ? new CyclingSpinnerListModel(objectArray) : new SpinnerListModel(objectArray);
        JSpinner jSpinner = SpinnerDemo3.addLabeledSpinner(this, stringArray[0], spinnerListModel);
        jFormattedTextField = this.getTextField(jSpinner);
        if (jFormattedTextField != null) {
            jFormattedTextField.setColumns(8);
            jFormattedTextField.setHorizontalAlignment(4);
        }
        int n2 = this.calendar.get(1);
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(n2, n2 - 100, n2 + 100, 1);
        if (spinnerListModel instanceof CyclingSpinnerListModel) {
            ((CyclingSpinnerListModel)spinnerListModel).setLinkedModel(spinnerNumberModel);
        }
        jSpinner = SpinnerDemo3.addLabeledSpinner(this, stringArray[1], spinnerNumberModel);
        jSpinner.setEditor(new JSpinner.NumberEditor(jSpinner, "#"));
        Date date = this.calendar.getTime();
        this.calendar.add(1, -100);
        Date date2 = this.calendar.getTime();
        this.calendar.add(1, 200);
        Date date3 = this.calendar.getTime();
        SpinnerDateModel spinnerDateModel = new SpinnerDateModel(date, date2, date3, 1);
        this.dateSpinner = jSpinner = SpinnerDemo3.addLabeledSpinner(this, stringArray[2], spinnerDateModel);
        jSpinner.setEditor(new JSpinner.DateEditor(jSpinner, "MM/yyyy"));
        jFormattedTextField = this.getTextField(jSpinner);
        if (jFormattedTextField != null) {
            jFormattedTextField.setHorizontalAlignment(4);
            jFormattedTextField.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 3));
        }
        jSpinner.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        this.setSeasonalColor(spinnerDateModel.getDate());
        this.dateSpinner.addChangeListener(this);
        SpringUtilities.makeCompactGrid(this, n, 2, 10, 10, 6, 10);
    }

    public JFormattedTextField getTextField(JSpinner jSpinner) {
        JComponent jComponent = jSpinner.getEditor();
        if (jComponent instanceof JSpinner.DefaultEditor) {
            return ((JSpinner.DefaultEditor)jComponent).getTextField();
        }
        System.err.println("Unexpected editor type: " + jSpinner.getEditor().getClass() + " isn't a descendant of DefaultEditor");
        return null;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        SpinnerModel spinnerModel = this.dateSpinner.getModel();
        if (spinnerModel instanceof SpinnerDateModel) {
            this.setSeasonalColor(((SpinnerDateModel)spinnerModel).getDate());
        }
    }

    protected void setSeasonalColor(Date date) {
        this.calendar.setTime(date);
        int n = this.calendar.get(2);
        JFormattedTextField jFormattedTextField = this.getTextField(this.dateSpinner);
        if (jFormattedTextField == null) {
            return;
        }
        switch (n) {
            case 2: 
            case 3: 
            case 4: {
                jFormattedTextField.setForeground(this.SPRING_COLOR);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                jFormattedTextField.setForeground(this.SUMMER_COLOR);
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                jFormattedTextField.setForeground(this.FALL_COLOR);
                break;
            }
            default: {
                jFormattedTextField.setForeground(this.WINTER_COLOR);
            }
        }
    }

    protected static String[] getMonthStrings() {
        int n;
        String[] stringArray = new DateFormatSymbols().getMonths();
        if (stringArray[n = stringArray.length - 1] == null || stringArray[n].length() <= 0) {
            String[] stringArray2 = new String[n];
            System.arraycopy(stringArray, 0, stringArray2, 0, n);
            return stringArray2;
        }
        return stringArray;
    }

    protected static JSpinner addLabeledSpinner(Container container, String string, SpinnerModel spinnerModel) {
        JLabel jLabel = new JLabel(string);
        container.add(jLabel);
        JSpinner jSpinner = new JSpinner(spinnerModel);
        jLabel.setLabelFor(jSpinner);
        container.add(jSpinner);
        return jSpinner;
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame jFrame = new JFrame("SpinnerDemo3");
        jFrame.setDefaultCloseOperation(3);
        SpinnerDemo3 spinnerDemo3 = new SpinnerDemo3(true);
        spinnerDemo3.setOpaque(true);
        jFrame.setContentPane(spinnerDemo3);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SpinnerDemo3.createAndShowGUI();
            }
        });
    }
}

