/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class GenealogyModel
implements TreeModel {
    private boolean showAncestors = false;
    private Vector treeModelListeners = new Vector();
    private Person rootPerson;

    public GenealogyModel(Person person) {
        this.rootPerson = person;
    }

    public void showAncestor(boolean bl, Object object) {
        this.showAncestors = bl;
        Person person = this.rootPerson;
        if (object != null) {
            this.rootPerson = (Person)object;
        }
        this.fireTreeStructureChanged(person);
    }

    protected void fireTreeStructureChanged(Person person) {
        int n = this.treeModelListeners.size();
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, new Object[]{person});
        for (int i = 0; i < n; ++i) {
            ((TreeModelListener)this.treeModelListeners.elementAt(i)).treeStructureChanged(treeModelEvent);
        }
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.treeModelListeners.addElement(treeModelListener);
    }

    public Object getChild(Object object, int n) {
        Person person = (Person)object;
        if (this.showAncestors) {
            if (n > 0 && person.getFather() != null) {
                return person.getMother();
            }
            return person.getFather();
        }
        return person.getChildAt(n);
    }

    public int getChildCount(Object object) {
        Person person = (Person)object;
        if (this.showAncestors) {
            int n = 0;
            if (person.getFather() != null) {
                ++n;
            }
            if (person.getMother() != null) {
                ++n;
            }
            return n;
        }
        return person.getChildCount();
    }

    public int getIndexOfChild(Object object, Object object2) {
        Person person = (Person)object;
        if (this.showAncestors) {
            int n = 0;
            Person person2 = person.getFather();
            if (person2 != null) {
                ++n;
                if (person2 == object2) {
                    return 0;
                }
            }
            if (person.getMother() != object2) {
                return n;
            }
            return -1;
        }
        return person.getIndexOfChild((Person)object2);
    }

    public Object getRoot() {
        return this.rootPerson;
    }

    public boolean isLeaf(Object object) {
        Person person = (Person)object;
        if (this.showAncestors) {
            return person.getFather() == null && person.getMother() == null;
        }
        return person.getChildCount() == 0;
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.treeModelListeners.removeElement(treeModelListener);
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
        System.out.println("*** valueForPathChanged : " + treePath + " --> " + object);
    }
}

