/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class GenealogyExample
extends JPanel
implements ActionListener {
    GenealogyTree tree;
    private static String SHOW_ANCESTOR_CMD = "showAncestor";

    public GenealogyExample() {
        super(new BorderLayout());
        JRadioButton jRadioButton = new JRadioButton("Show descendants", true);
        JRadioButton jRadioButton2 = new JRadioButton("Show ancestors");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        jRadioButton.addActionListener(this);
        jRadioButton2.addActionListener(this);
        jRadioButton2.setActionCommand(SHOW_ANCESTOR_CMD);
        JPanel jPanel = new JPanel();
        jPanel.add(jRadioButton);
        jPanel.add(jRadioButton2);
        this.tree = new GenealogyTree(this.getGenealogyGraph());
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        jScrollPane.setPreferredSize(new Dimension(200, 200));
        this.add((Component)jPanel, "First");
        this.add((Component)jScrollPane, "Center");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand() == SHOW_ANCESTOR_CMD) {
            this.tree.showAncestor(true);
        } else {
            this.tree.showAncestor(false);
        }
    }

    public Person getGenealogyGraph() {
        Person person = new Person("Jack (great-granddaddy)");
        Person person2 = new Person("Jean (great-granny)");
        Person person3 = new Person("Albert (great-granddaddy)");
        Person person4 = new Person("Rae (great-granny)");
        Person person5 = new Person("Paul (great-granddaddy)");
        Person person6 = new Person("Josie (great-granny)");
        Person person7 = new Person("Peter (grandpa)");
        Person person8 = new Person("Zoe (grandma)");
        Person person9 = new Person("Simon (grandpa)");
        Person person10 = new Person("James (grandpa)");
        Person person11 = new Person("Bertha (grandma)");
        Person person12 = new Person("Veronica (grandma)");
        Person person13 = new Person("Anne (grandma)");
        Person person14 = new Person("Renee (grandma)");
        Person person15 = new Person("Joseph (grandpa)");
        Person person16 = new Person("Isabelle (mom)");
        Person person17 = new Person("Frank (dad)");
        Person person18 = new Person("Louis (dad)");
        Person person19 = new Person("Laurence (dad)");
        Person person20 = new Person("Valerie (mom)");
        Person person21 = new Person("Marie (mom)");
        Person person22 = new Person("Helen (mom)");
        Person person23 = new Person("Mark (dad)");
        Person person24 = new Person("Oliver (dad)");
        Person person25 = new Person("Clement (boy)");
        Person person26 = new Person("Colin (boy)");
        Person.linkFamily(person, person2, new Person[]{person7, person8, person9, person10});
        Person.linkFamily(person3, person4, new Person[]{person11, person12, person13});
        Person.linkFamily(person5, person6, new Person[]{person14, person15});
        Person.linkFamily(person9, person12, new Person[]{person16, person17, person18});
        Person.linkFamily(person10, person11, new Person[]{person19, person20, person21});
        Person.linkFamily(person14, person13, new Person[]{person22, person23, person24});
        Person.linkFamily(person19, person22, new Person[]{person25, person26});
        return person;
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame jFrame = new JFrame("GenealogyExample");
        jFrame.setDefaultCloseOperation(3);
        GenealogyExample genealogyExample = new GenealogyExample();
        genealogyExample.setOpaque(true);
        jFrame.setContentPane(genealogyExample);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GenealogyExample.createAndShowGUI();
            }
        });
    }
}

