/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ListDataEventDemo
extends JPanel
implements ListSelectionListener {
    private JList list;
    private DefaultListModel listModel = new DefaultListModel();
    private static final String addString = "Add";
    private static final String deleteString = "Delete";
    private static final String upString = "Move up";
    private static final String downString = "Move down";
    private JButton addButton;
    private JButton deleteButton;
    private JButton upButton;
    private JButton downButton;
    private JTextField nameField;
    private JTextArea log;
    private static String newline = "\n";
    static /* synthetic */ Class class$ListDataEventDemo;

    public ListDataEventDemo() {
        super(new BorderLayout());
        this.listModel.addElement("Whistler, Canada");
        this.listModel.addElement("Jackson Hole, Wyoming");
        this.listModel.addElement("Squaw Valley, California");
        this.listModel.addElement("Telluride, Colorado");
        this.listModel.addElement("Taos, New Mexico");
        this.listModel.addElement("Snowbird, Utah");
        this.listModel.addElement("Chamonix, France");
        this.listModel.addElement("Banff, Canada");
        this.listModel.addElement("Arapahoe Basin, Colorado");
        this.listModel.addElement("Kirkwood, California");
        this.listModel.addElement("Sun Valley, Idaho");
        this.listModel.addListDataListener(new MyListDataListener());
        this.list = new JList(this.listModel);
        this.list.setSelectionMode(1);
        this.list.setSelectedIndex(0);
        this.list.addListSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.list);
        this.addButton = new JButton(addString);
        this.addButton.setActionCommand(addString);
        this.addButton.addActionListener(new AddButtonListener());
        this.deleteButton = new JButton(deleteString);
        this.deleteButton.setActionCommand(deleteString);
        this.deleteButton.addActionListener(new DeleteButtonListener());
        ImageIcon imageIcon = ListDataEventDemo.createImageIcon("Up16");
        if (imageIcon != null) {
            this.upButton = new JButton(imageIcon);
            this.upButton.setMargin(new Insets(0, 0, 0, 0));
        } else {
            this.upButton = new JButton(upString);
        }
        this.upButton.setToolTipText("Move the currently selected list item higher.");
        this.upButton.setActionCommand(upString);
        this.upButton.addActionListener(new UpDownListener());
        imageIcon = ListDataEventDemo.createImageIcon("Down16");
        if (imageIcon != null) {
            this.downButton = new JButton(imageIcon);
            this.downButton.setMargin(new Insets(0, 0, 0, 0));
        } else {
            this.downButton = new JButton(downString);
        }
        this.downButton.setToolTipText("Move the currently selected list item lower.");
        this.downButton.setActionCommand(downString);
        this.downButton.addActionListener(new UpDownListener());
        JPanel jPanel = new JPanel(new GridLayout(2, 1));
        jPanel.add(this.upButton);
        jPanel.add(this.downButton);
        this.nameField = new JTextField(15);
        this.nameField.addActionListener(new AddButtonListener());
        String string = this.listModel.getElementAt(this.list.getSelectedIndex()).toString();
        this.nameField.setText(string);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.nameField);
        jPanel2.add(this.addButton);
        jPanel2.add(this.deleteButton);
        jPanel2.add(jPanel);
        this.log = new JTextArea(10, 20);
        JScrollPane jScrollPane2 = new JScrollPane(this.log);
        JSplitPane jSplitPane = new JSplitPane(0, jScrollPane, jScrollPane2);
        jSplitPane.setResizeWeight(0.5);
        this.add((Component)jPanel2, "First");
        this.add((Component)jSplitPane, "Center");
    }

    private void swap(int n, int n2) {
        Object e = this.listModel.getElementAt(n);
        Object e2 = this.listModel.getElementAt(n2);
        this.listModel.set(n, e2);
        this.listModel.set(n2, e);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            if (this.list.getSelectedIndex() == -1) {
                this.deleteButton.setEnabled(false);
                this.upButton.setEnabled(false);
                this.downButton.setEnabled(false);
                this.nameField.setText("");
            } else if (this.list.getSelectedIndices().length > 1) {
                this.deleteButton.setEnabled(true);
                this.upButton.setEnabled(false);
                this.downButton.setEnabled(false);
            } else {
                this.deleteButton.setEnabled(true);
                this.upButton.setEnabled(true);
                this.downButton.setEnabled(true);
                this.nameField.setText(this.list.getSelectedValue().toString());
            }
        }
    }

    protected static ImageIcon createImageIcon(String string) {
        String string2;
        URL uRL = (class$ListDataEventDemo == null ? (class$ListDataEventDemo = ListDataEventDemo.class$("ListDataEventDemo")) : class$ListDataEventDemo).getResource(string2 = "toolbarButtonGraphics/navigation/" + string + ".gif");
        if (uRL == null) {
            System.err.println("Resource not found: " + string2);
            return null;
        }
        return new ImageIcon(uRL);
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame jFrame = new JFrame("ListDataEventDemo");
        jFrame.setDefaultCloseOperation(3);
        ListDataEventDemo listDataEventDemo = new ListDataEventDemo();
        listDataEventDemo.setOpaque(true);
        jFrame.setContentPane(listDataEventDemo);
        listDataEventDemo.setMinimumSize(new Dimension(listDataEventDemo.getPreferredSize().width, 100));
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ListDataEventDemo.createAndShowGUI();
            }
        });
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class UpDownListener
    implements ActionListener {
        UpDownListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = ListDataEventDemo.this.list.getSelectedIndex();
            if (actionEvent.getActionCommand().equals(ListDataEventDemo.upString)) {
                if (n != 0) {
                    ListDataEventDemo.this.swap(n, n - 1);
                    ListDataEventDemo.this.list.setSelectedIndex(n - 1);
                    ListDataEventDemo.this.list.ensureIndexIsVisible(n - 1);
                }
            } else if (n != ListDataEventDemo.this.listModel.getSize() - 1) {
                ListDataEventDemo.this.swap(n, n + 1);
                ListDataEventDemo.this.list.setSelectedIndex(n + 1);
                ListDataEventDemo.this.list.ensureIndexIsVisible(n + 1);
            }
        }
    }

    class AddButtonListener
    implements ActionListener {
        AddButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ListDataEventDemo.this.nameField.getText().equals("")) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            int n = ListDataEventDemo.this.list.getSelectedIndex();
            int n2 = ListDataEventDemo.this.listModel.getSize();
            if (n == -1 || n + 1 == n2) {
                ListDataEventDemo.this.listModel.addElement(ListDataEventDemo.this.nameField.getText());
                ListDataEventDemo.this.list.setSelectedIndex(n2);
            } else {
                ListDataEventDemo.this.listModel.insertElementAt(ListDataEventDemo.this.nameField.getText(), n + 1);
                ListDataEventDemo.this.list.setSelectedIndex(n + 1);
            }
        }
    }

    class DeleteButtonListener
    implements ActionListener {
        DeleteButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ListSelectionModel listSelectionModel = ListDataEventDemo.this.list.getSelectionModel();
            int n = listSelectionModel.getMinSelectionIndex();
            int n2 = listSelectionModel.getMaxSelectionIndex();
            ListDataEventDemo.this.listModel.removeRange(n, n2);
            int n3 = ListDataEventDemo.this.listModel.size();
            if (n3 == 0) {
                ListDataEventDemo.this.deleteButton.setEnabled(false);
                ListDataEventDemo.this.upButton.setEnabled(false);
                ListDataEventDemo.this.downButton.setEnabled(false);
            } else {
                if (n == ListDataEventDemo.this.listModel.getSize()) {
                    --n;
                }
                ListDataEventDemo.this.list.setSelectedIndex(n);
            }
        }
    }

    class MyListDataListener
    implements ListDataListener {
        MyListDataListener() {
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            ListDataEventDemo.this.log.append("contentsChanged: " + listDataEvent.getIndex0() + ", " + listDataEvent.getIndex1() + newline);
            ListDataEventDemo.this.log.setCaretPosition(ListDataEventDemo.this.log.getDocument().getLength());
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            ListDataEventDemo.this.log.append("intervalAdded: " + listDataEvent.getIndex0() + ", " + listDataEvent.getIndex1() + newline);
            ListDataEventDemo.this.log.setCaretPosition(ListDataEventDemo.this.log.getDocument().getLength());
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            ListDataEventDemo.this.log.append("intervalRemoved: " + listDataEvent.getIndex0() + ", " + listDataEvent.getIndex1() + newline);
            ListDataEventDemo.this.log.setCaretPosition(ListDataEventDemo.this.log.getDocument().getLength());
        }
    }
}

