/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class Framework
extends WindowAdapter {
    public int numWindows = 0;
    private Point lastLocation = null;
    private int maxX = 500;
    private int maxY = 500;

    public Framework() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.maxX = dimension.width - 50;
        this.maxY = dimension.height - 50;
        this.makeNewWindow();
    }

    public void makeNewWindow() {
        MyFrame myFrame = new MyFrame(this);
        ++this.numWindows;
        System.out.println("Number of windows: " + this.numWindows);
        if (this.lastLocation != null) {
            this.lastLocation.translate(40, 40);
            if (this.lastLocation.x > this.maxX || this.lastLocation.y > this.maxY) {
                this.lastLocation.setLocation(0, 0);
            }
            myFrame.setLocation(this.lastLocation);
        } else {
            this.lastLocation = myFrame.getLocation();
        }
        System.out.println("Frame location: " + this.lastLocation);
        myFrame.setVisible(true);
    }

    public void quit(JFrame jFrame) {
        if (this.quitConfirmed(jFrame)) {
            System.out.println("Quitting.");
            System.exit(0);
        }
        System.out.println("Quit operation not confirmed; staying alive.");
    }

    private boolean quitConfirmed(JFrame jFrame) {
        String string = "Quit";
        String string2 = "Cancel";
        Object[] objectArray = new Object[]{string, string2};
        int n = JOptionPane.showOptionDialog(jFrame, "Windows are still open.\nDo you really want to quit?", "Quit Confirmation", 0, 3, null, objectArray, string);
        return n == 0;
    }

    public void windowClosed(WindowEvent windowEvent) {
        --this.numWindows;
        System.out.println("Number of windows = " + this.numWindows);
        if (this.numWindows <= 0) {
            System.out.println("All windows gone.  Bye bye!");
            System.exit(0);
        }
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        Framework framework = new Framework();
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Framework.createAndShowGUI();
            }
        });
    }

    class MyFrame
    extends JFrame {
        protected Dimension defaultSize = new Dimension(200, 200);
        protected Framework framework = null;

        public MyFrame(Framework framework2) {
            super("New Frame");
            this.framework = framework2;
            this.setDefaultCloseOperation(2);
            this.addWindowListener(this.framework);
            JMenu jMenu = new JMenu("Window");
            jMenu.setMnemonic(87);
            JMenuItem jMenuItem = null;
            jMenuItem = new JMenuItem("Close");
            jMenuItem.setMnemonic(67);
            jMenuItem.addActionListener(new ActionListener(this, Framework.this){
                private final /* synthetic */ Framework val$this$0;
                private final /* synthetic */ MyFrame this$1;
                {
                    this.this$1 = myFrame;
                    this.val$this$0 = framework;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    System.out.println("Close window");
                    this.this$1.setVisible(false);
                    this.this$1.dispose();
                }
            });
            jMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("New");
            jMenuItem.setMnemonic(78);
            jMenuItem.addActionListener(new ActionListener(this){
                private final /* synthetic */ MyFrame this$1;
                {
                    this.this$1 = myFrame;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    System.out.println("New window");
                    this.this$1.framework.makeNewWindow();
                }
            });
            jMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Quit");
            jMenuItem.setMnemonic(81);
            jMenuItem.addActionListener(new ActionListener(this, Framework.this){
                private final /* synthetic */ Framework val$this$0;
                private final /* synthetic */ MyFrame this$1;
                {
                    this.this$1 = myFrame;
                    this.val$this$0 = framework;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    System.out.println("Quit request");
                    this.this$1.framework.quit(this.this$1);
                }
            });
            jMenu.add(jMenuItem);
            JMenuBar jMenuBar = new JMenuBar();
            jMenuBar.add(jMenu);
            this.setJMenuBar(jMenuBar);
            this.setSize(this.defaultSize);
        }
    }
}

