/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;

public class TumbleItem
extends JApplet
implements ActionListener {
    int loopslot = -1;
    String dir;
    Timer timer;
    int pause;
    int offset;
    int off;
    int speed;
    int nimgs;
    int width;
    JComponent contentPane;
    ImageIcon[] imgs;
    int maxWidth;
    boolean finishedLoading = false;
    JLabel statusLabel;
    static Color[] labelColor = new Color[]{Color.black, Color.black, Color.black, Color.black, Color.black, Color.white, Color.white, Color.white, Color.white, Color.white};

    public void init() {
        String string = this.getParameter("img");
        this.dir = string != null ? string : "images/tumble";
        string = this.getParameter("pause");
        this.pause = string != null ? Integer.valueOf(string) : 1900;
        string = this.getParameter("offset");
        this.offset = string != null ? Integer.valueOf(string) : 0;
        string = this.getParameter("speed");
        this.speed = string != null ? 1000 / Integer.valueOf(string) : 100;
        string = this.getParameter("nimgs");
        this.nimgs = string != null ? Integer.valueOf(string) : 16;
        string = this.getParameter("maxwidth");
        this.maxWidth = string != null ? Integer.valueOf(string) : 0;
        this.width = this.getSize().width;
        if (this.offset < 0) {
            this.off = this.width - this.maxWidth;
        }
        this.contentPane = new 1();
        this.contentPane.setBackground(Color.white);
        this.setContentPane(this.contentPane);
        this.statusLabel = new JLabel("Loading Images...", 0);
        this.statusLabel.setForeground(labelColor[0]);
        this.contentPane.setLayout(new BorderLayout());
        this.contentPane.add((Component)this.statusLabel, "Center");
        this.timer = new Timer(this.speed, this);
        this.timer.setInitialDelay(this.pause);
        this.timer.setCoalesce(false);
        this.imgs = new ImageIcon[this.nimgs];
        this.timer.start();
        2 var2_2 = new 2();
        var2_2.start();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ++this.loopslot;
        if (!this.finishedLoading) {
            int n = this.loopslot % labelColor.length;
            try {
                this.statusLabel.setForeground(labelColor[n]);
                return;
            }
            catch (NullPointerException nullPointerException) {
                return;
            }
        }
        if (this.loopslot >= this.nimgs) {
            this.loopslot = 0;
            this.off += this.offset;
            if (this.off < 0) {
                this.off = this.width - this.maxWidth;
            } else if (this.off + this.maxWidth > this.width) {
                this.off = 0;
            }
        }
        this.contentPane.repaint();
        if (this.loopslot == this.nimgs - 1) {
            this.timer.restart();
        }
    }

    public void start() {
        if (this.finishedLoading && this.nimgs > 1) {
            this.timer.restart();
        }
    }

    public void stop() {
        this.timer.stop();
    }

    protected URL getURL(URL uRL, String string) {
        URL uRL2 = null;
        try {
            uRL2 = new URL(uRL, string);
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("Couldn't create image: badly specified URL");
            return null;
        }
        return uRL2;
    }

    public String getAppletInfo() {
        return "Title: TumbleItem v1.2, 23 Jul 1997\nAuthor: James Gosling\nA simple Item class to play an image loop.";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"img", "string", "the directory containing the images to loop"}, {"pause", "int", "pause between complete loops; default is 3900"}, {"offset", "int", "offset of each image to simulate left (-) or right (+) motion; default is 0 (no motion)"}, {"speed", "int", "the speed at which the frames are looped; default is 100"}, {"nimgs", "int", "the number of images to be looped; default is 16"}, {"maxwidth", "int", "the maximum width of any image in the loop; default is 0"}};
        return stringArray;
    }

    private final class 1
    extends JPanel {
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (TumbleItem.this.finishedLoading && TumbleItem.this.loopslot > -1 && TumbleItem.this.loopslot < TumbleItem.this.nimgs) {
                TumbleItem.this.imgs[TumbleItem.this.loopslot].paintIcon(this, graphics, TumbleItem.this.off, 0);
            }
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends SwingWorker {
        public Object construct() {
            URL uRL = TumbleItem.this.getCodeBase();
            String string = String.valueOf(TumbleItem.this.dir) + "/T";
            int n = 0;
            while (n < TumbleItem.this.nimgs) {
                TumbleItem.this.imgs[n] = new ImageIcon(TumbleItem.this.getURL(uRL, String.valueOf(string) + (n + 1) + ".gif"));
                ++n;
            }
            TumbleItem.this.finishedLoading = true;
            return TumbleItem.this.imgs;
        }

        public void finished() {
            TumbleItem.this.contentPane.removeAll();
            TumbleItem.this.contentPane.repaint();
            TumbleItem.this.loopslot = -1;
        }

        /* synthetic */ 2() {
        }
    }
}

