/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class DiagonalLayout
implements LayoutManager {
    private int vgap;
    private int minWidth;
    private int minHeight;
    private int preferredWidth;
    private int preferredHeight;
    private boolean sizeUnknown = true;

    public DiagonalLayout() {
        this(5);
    }

    public DiagonalLayout(int n) {
        this.vgap = n;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    private void setSizes(Container container) {
        int n = container.getComponentCount();
        Dimension dimension = null;
        this.preferredWidth = 0;
        this.preferredHeight = 0;
        this.minWidth = 0;
        this.minHeight = 0;
        int n2 = 0;
        while (n2 < n) {
            Component component = container.getComponent(n2);
            if (component.isVisible()) {
                dimension = component.getPreferredSize();
                if (n2 > 0) {
                    this.preferredWidth += dimension.width / 2;
                    this.preferredHeight += this.vgap;
                } else {
                    this.preferredWidth = dimension.width;
                }
                this.preferredHeight += dimension.height;
                this.minWidth = Math.max(component.getMinimumSize().width, this.minWidth);
                this.minHeight = this.preferredHeight;
            }
            ++n2;
        }
    }

    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension = new Dimension(0, 0);
        container.getComponentCount();
        this.setSizes(container);
        Insets insets = container.getInsets();
        dimension.width = this.preferredWidth + insets.left + insets.right;
        dimension.height = this.preferredHeight + insets.top + insets.bottom;
        this.sizeUnknown = false;
        return dimension;
    }

    public Dimension minimumLayoutSize(Container container) {
        Dimension dimension = new Dimension(0, 0);
        container.getComponentCount();
        Insets insets = container.getInsets();
        dimension.width = this.minWidth + insets.left + insets.right;
        dimension.height = this.minHeight + insets.top + insets.bottom;
        this.sizeUnknown = false;
        return dimension;
    }

    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        int n = container.getSize().width - (insets.left + insets.right);
        int n2 = container.getSize().height - (insets.top + insets.bottom);
        int n3 = container.getComponentCount();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = insets.top;
        int n8 = 0;
        int n9 = 0;
        boolean bl = false;
        if (this.sizeUnknown) {
            this.setSizes(container);
        }
        if (n <= this.minWidth) {
            bl = true;
        }
        if (n != this.preferredWidth) {
            n8 = (n - this.preferredWidth) / (n3 - 1);
        }
        if (n2 > this.preferredHeight) {
            n9 = (n2 - this.preferredHeight) / (n3 - 1);
        }
        int n10 = 0;
        while (n10 < n3) {
            Component component = container.getComponent(n10);
            if (component.isVisible()) {
                Dimension dimension = component.getPreferredSize();
                if (n10 > 0) {
                    if (!bl) {
                        n6 += n4 / 2 + n8;
                    }
                    n7 += n5 + this.vgap + n9;
                }
                if (!bl && n6 + dimension.width > container.getSize().width - insets.right) {
                    n6 = container.getSize().width - insets.bottom - dimension.width;
                }
                container.getSize();
                component.setBounds(n6, n7, dimension.width, dimension.height);
                n4 = dimension.width;
                n5 = dimension.height;
            }
            ++n10;
        }
    }

    public String toString() {
        String string = "";
        return String.valueOf(this.getClass().getName()) + "[vgap=" + this.vgap + string + "]";
    }
}

