/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class SimpleTableSelectionDemo
extends JPanel {
    private boolean DEBUG = false;
    private boolean ALLOW_COLUMN_SELECTION = false;
    private boolean ALLOW_ROW_SELECTION = true;

    public SimpleTableSelectionDemo() {
        super(new GridLayout(1, 0));
        Object object;
        Object[] objectArray = new String[]{"First Name", "Last Name", "Sport", "# of Years", "Vegetarian"};
        Object[][] objectArray2 = new Object[][]{{"Mary", "Campione", "Snowboarding", new Integer(5), new Boolean(false)}, {"Alison", "Huml", "Rowing", new Integer(3), new Boolean(true)}, {"Kathy", "Walrath", "Knitting", new Integer(2), new Boolean(false)}, {"Sharon", "Zakhour", "Speed reading", new Integer(20), new Boolean(true)}, {"Philip", "Milne", "Pool", new Integer(10), new Boolean(false)}};
        final JTable jTable = new JTable(objectArray2, objectArray);
        jTable.setPreferredScrollableViewportSize(new Dimension(500, 70));
        jTable.setSelectionMode(0);
        if (this.ALLOW_ROW_SELECTION) {
            object = jTable.getSelectionModel();
            object.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (listSelectionEvent.getValueIsAdjusting()) {
                        return;
                    }
                    ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                    if (listSelectionModel.isSelectionEmpty()) {
                        System.out.println("No rows are selected.");
                    } else {
                        int n = listSelectionModel.getMinSelectionIndex();
                        System.out.println("Row " + n + " is now selected.");
                    }
                }
            });
        } else {
            jTable.setRowSelectionAllowed(false);
        }
        if (this.ALLOW_COLUMN_SELECTION) {
            if (this.ALLOW_ROW_SELECTION) {
                jTable.setCellSelectionEnabled(true);
            }
            jTable.setColumnSelectionAllowed(true);
            object = jTable.getColumnModel().getSelectionModel();
            object.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (listSelectionEvent.getValueIsAdjusting()) {
                        return;
                    }
                    ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                    if (listSelectionModel.isSelectionEmpty()) {
                        System.out.println("No columns are selected.");
                    } else {
                        int n = listSelectionModel.getMinSelectionIndex();
                        System.out.println("Column " + n + " is now selected.");
                    }
                }
            });
        }
        if (this.DEBUG) {
            jTable.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    SimpleTableSelectionDemo.this.printDebugData(jTable);
                }
            });
        }
        object = new JScrollPane(jTable);
        this.add((Component)object);
    }

    private void printDebugData(JTable jTable) {
        int n = jTable.getRowCount();
        int n2 = jTable.getColumnCount();
        TableModel tableModel = jTable.getModel();
        System.out.println("Value of data: ");
        for (int i = 0; i < n; ++i) {
            System.out.print("    row " + i + ":");
            for (int j = 0; j < n2; ++j) {
                System.out.print("  " + tableModel.getValueAt(i, j));
            }
            System.out.println();
        }
        System.out.println("--------------------------");
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame jFrame = new JFrame("SimpleTableSelectionDemo");
        jFrame.setDefaultCloseOperation(3);
        SimpleTableSelectionDemo simpleTableSelectionDemo = new SimpleTableSelectionDemo();
        simpleTableSelectionDemo.setOpaque(true);
        jFrame.setContentPane(simpleTableSelectionDemo);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SimpleTableSelectionDemo.createAndShowGUI();
            }
        });
    }
}

