/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.Timer;

public class MovingLabels
extends JApplet
implements ActionListener {
    int frameNumber = -1;
    Timer timer;
    boolean frozen = false;
    JLayeredPane layeredPane;
    JLabel bgLabel;
    JLabel fgLabel;
    int fgHeight;
    int fgWidth;
    int bgHeight;
    int bgWidth;
    static String fgFile = "images/rocketship.gif";
    static String bgFile = "images/starfield.gif";

    public void init() {
        Image image = this.getImage(this.getCodeBase(), bgFile);
        Image image2 = this.getImage(this.getCodeBase(), fgFile);
        this.buildUI(this.getContentPane(), image, image2);
    }

    void buildUI(Container container, Image image, Image image2) {
        ImageIcon imageIcon = new ImageIcon(image);
        ImageIcon imageIcon2 = new ImageIcon(image2);
        this.bgWidth = imageIcon.getIconWidth();
        this.bgHeight = imageIcon.getIconHeight();
        this.fgWidth = imageIcon2.getIconWidth();
        this.fgHeight = imageIcon2.getIconHeight();
        this.timer = new Timer(100, this);
        this.timer.setInitialDelay(0);
        this.timer.setCoalesce(true);
        this.bgLabel = new JLabel(imageIcon);
        this.bgLabel.setOpaque(true);
        this.bgLabel.setBounds(0, 0, this.bgWidth, this.bgHeight);
        this.fgLabel = new JLabel(imageIcon2);
        this.fgLabel.setBounds(0, 0, this.fgWidth, this.fgHeight);
        this.layeredPane = new JLayeredPane();
        this.layeredPane.setPreferredSize(new Dimension(this.bgWidth, this.bgHeight));
        this.layeredPane.addMouseListener(new 1());
        this.layeredPane.add((Component)this.bgLabel, new Integer(0));
        this.layeredPane.add((Component)this.fgLabel, new Integer(1));
        container.add((Component)this.layeredPane, "Center");
    }

    public void start() {
        this.startAnimation();
    }

    public void stop() {
        this.stopAnimation();
    }

    public synchronized void startAnimation() {
        if (!this.frozen && !this.timer.isRunning()) {
            this.timer.start();
        }
    }

    public synchronized void stopAnimation() {
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ++this.frameNumber;
        this.fgLabel.setLocation(this.frameNumber * 5 % (this.fgWidth + this.bgWidth) - this.fgWidth, (this.bgHeight - this.fgHeight) / 2);
    }

    public static void main(String[] stringArray) {
        Image image = Toolkit.getDefaultToolkit().getImage(bgFile);
        Image image2 = Toolkit.getDefaultToolkit().getImage(fgFile);
        MovingLabels movingLabels = new MovingLabels();
        JFrame jFrame = new JFrame("MovingLabels");
        jFrame.addWindowListener(movingLabels.new 2());
        movingLabels.buildUI(jFrame.getContentPane(), image, image2);
        ((Component)jFrame).setSize(500, 125);
        ((Component)jFrame).setVisible(true);
        movingLabels.startAnimation();
    }

    private final class 1
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            if (MovingLabels.this.frozen) {
                MovingLabels.this.frozen = false;
                MovingLabels.this.startAnimation();
                return;
            }
            MovingLabels.this.frozen = true;
            MovingLabels.this.stopAnimation();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends WindowAdapter {
        public void windowIconified(WindowEvent windowEvent) {
            MovingLabels.this.stopAnimation();
        }

        public void windowDeiconified(WindowEvent windowEvent) {
            MovingLabels.this.startAnimation();
        }

        public void windowClosing(WindowEvent windowEvent) {
            System.exit(0);
        }

        /* synthetic */ 2() {
        }
    }
}

