/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.net.URL;
import javax.jnlp.FileContents;
import javax.jnlp.FileOpenService;
import javax.jnlp.FileSaveService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class JWSFileChooserDemo
extends JPanel
implements ActionListener {
    private static final String newline = "\n";
    JButton openButton;
    JButton saveButton;
    JTextArea log = new JTextArea(5, 20);
    static /* synthetic */ Class class$JWSFileChooserDemo;

    public JWSFileChooserDemo() {
        super(new BorderLayout());
        this.log.setMargin(new Insets(5, 5, 5, 5));
        this.log.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.log);
        this.openButton = new JButton("Open a File...", JWSFileChooserDemo.createImageIcon("images/Open16.gif"));
        this.openButton.addActionListener(this);
        this.saveButton = new JButton("Save a File...", JWSFileChooserDemo.createImageIcon("images/Save16.gif"));
        this.saveButton.setEnabled(false);
        JPanel jPanel = new JPanel();
        jPanel.add(this.openButton);
        jPanel.add(this.saveButton);
        this.add((Component)jPanel, "First");
        this.add((Component)jScrollPane, "Center");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        FileContents fileContents;
        FileOpenService fileOpenService;
        if (actionEvent.getSource() == this.openButton) {
            fileOpenService = null;
            fileContents = null;
            try {
                fileOpenService = (FileOpenService)ServiceManager.lookup((String)"javax.jnlp.FileOpenService");
            }
            catch (UnavailableServiceException unavailableServiceException) {
                // empty catch block
            }
            if (fileOpenService != null) {
                try {
                    fileContents = fileOpenService.openFileDialog(null, null);
                }
                catch (Exception exception) {
                    this.log.append("Open command failed: " + exception.getLocalizedMessage() + newline);
                }
            }
            if (fileContents != null) {
                try {
                    this.log.append("Opened file: " + fileContents.getName() + "." + newline);
                }
                catch (IOException iOException) {
                    this.log.append("Problem opening file: " + iOException.getLocalizedMessage() + newline);
                }
            } else {
                this.log.append("User canceled open request.\n");
            }
        }
        if (actionEvent.getSource() == this.saveButton) {
            fileOpenService = null;
            fileContents = null;
            StringBufferInputStream stringBufferInputStream = new StringBufferInputStream("Saved by JWSFileChooserDemo");
            try {
                fileOpenService = (FileSaveService)ServiceManager.lookup((String)"javax.jnlp.FileSaveService");
            }
            catch (UnavailableServiceException unavailableServiceException) {
                // empty catch block
            }
            if (fileOpenService != null) {
                try {
                    fileContents = fileOpenService.saveFileDialog(null, null, (InputStream)stringBufferInputStream, "JWSFileChooserDemo.txt");
                }
                catch (Exception exception) {
                    this.log.append("Save command failed: " + exception.getLocalizedMessage() + newline);
                }
            }
            if (fileContents != null) {
                try {
                    this.log.append("Saved file: " + fileContents.getName() + "." + newline);
                }
                catch (IOException iOException) {
                    this.log.append("Problem saving file: " + iOException.getLocalizedMessage() + newline);
                }
            } else {
                this.log.append("User canceled save request.\n");
            }
        }
    }

    protected static ImageIcon createImageIcon(String string) {
        URL uRL = (class$JWSFileChooserDemo == null ? (class$JWSFileChooserDemo = JWSFileChooserDemo.class$("JWSFileChooserDemo")) : class$JWSFileChooserDemo).getResource(string);
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        System.err.println("Couldn't find file: " + string);
        return null;
    }

    public static void main(String[] stringArray) {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        JFrame jFrame = new JFrame("JWSFileChooserDemo");
        jFrame.setDefaultCloseOperation(3);
        JWSFileChooserDemo jWSFileChooserDemo = new JWSFileChooserDemo();
        jWSFileChooserDemo.setOpaque(true);
        jFrame.setContentPane(jWSFileChooserDemo);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

