/*
 * Decompiled with CFR 0.152.
 */
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.TransferHandler;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;

class FileAndTextTransferHandler
extends TransferHandler {
    private DataFlavor fileFlavor;
    private DataFlavor stringFlavor;
    private TabbedPaneController tpc;
    private JTextArea source;
    private boolean shouldRemove;
    protected String newline = "\n";
    Position p0 = null;
    Position p1 = null;

    FileAndTextTransferHandler(TabbedPaneController tabbedPaneController) {
        this.tpc = tabbedPaneController;
        this.fileFlavor = DataFlavor.javaFileListFlavor;
        this.stringFlavor = DataFlavor.stringFlavor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean importData(JComponent jComponent, Transferable transferable) {
        if (!this.canImport(jComponent, transferable.getTransferDataFlavors())) {
            return false;
        }
        try {
            if (this.hasFileFlavor(transferable.getTransferDataFlavors())) {
                String string = null;
                List list = (List)transferable.getTransferData(this.fileFlavor);
                int n = 0;
                while (n < list.size()) {
                    File file = (File)list.get(n);
                    JTextArea jTextArea = this.tpc.addTab(file.toString());
                    BufferedReader bufferedReader = null;
                    try {
                        bufferedReader = new BufferedReader(new FileReader(file));
                        while ((string = bufferedReader.readLine()) != null) {
                            jTextArea.append(string + this.newline);
                        }
                    }
                    catch (IOException iOException) {
                        System.out.println("importData: Unable to read from file " + file.toString());
                    }
                    finally {
                        if (bufferedReader != null) {
                            try {
                                bufferedReader.close();
                            }
                            catch (IOException iOException) {
                                System.out.println("importData: Unable to close file " + file.toString());
                            }
                        }
                    }
                    ++n;
                }
                return true;
            }
            if (this.hasStringFlavor(transferable.getTransferDataFlavors())) {
                JTextArea jTextArea = (JTextArea)jComponent;
                if (jTextArea.equals(this.source) && jTextArea.getCaretPosition() >= this.p0.getOffset() && jTextArea.getCaretPosition() <= this.p1.getOffset()) {
                    this.shouldRemove = false;
                    return true;
                }
                String string = (String)transferable.getTransferData(this.stringFlavor);
                jTextArea.replaceSelection(string);
                return true;
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            System.out.println("importData: unsupported data flavor");
        }
        catch (IOException iOException) {
            System.out.println("importData: I/O exception");
        }
        return false;
    }

    protected Transferable createTransferable(JComponent jComponent) {
        this.source = (JTextArea)jComponent;
        int n = this.source.getSelectionStart();
        int n2 = this.source.getSelectionEnd();
        Document document = this.source.getDocument();
        if (n == n2) {
            return null;
        }
        try {
            this.p0 = document.createPosition(n);
            this.p1 = document.createPosition(n2);
        }
        catch (BadLocationException badLocationException) {
            System.out.println("Can't create position - unable to remove text from source.");
        }
        this.shouldRemove = true;
        String string = this.source.getSelectedText();
        return new StringSelection(string);
    }

    public int getSourceActions(JComponent jComponent) {
        return 3;
    }

    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        if (this.shouldRemove && n == 2 && this.p0 != null && this.p1 != null && this.p0.getOffset() != this.p1.getOffset()) {
            try {
                JTextComponent jTextComponent = (JTextComponent)jComponent;
                jTextComponent.getDocument().remove(this.p0.getOffset(), this.p1.getOffset() - this.p0.getOffset());
            }
            catch (BadLocationException badLocationException) {
                System.out.println("Can't remove text from source.");
            }
        }
        this.source = null;
    }

    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        if (this.hasFileFlavor(dataFlavorArray)) {
            return true;
        }
        return this.hasStringFlavor(dataFlavorArray);
    }

    private boolean hasFileFlavor(DataFlavor[] dataFlavorArray) {
        int n = 0;
        while (n < dataFlavorArray.length) {
            if (this.fileFlavor.equals(dataFlavorArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean hasStringFlavor(DataFlavor[] dataFlavorArray) {
        int n = 0;
        while (n < dataFlavorArray.length) {
            if (this.stringFlavor.equals(dataFlavorArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

