/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SliderDemo
extends JPanel
implements ActionListener,
WindowListener,
ChangeListener {
    static final int FPS_MIN = 0;
    static final int FPS_MAX = 30;
    static final int FPS_INIT = 15;
    int frameNumber = 0;
    int NUM_FRAMES = 14;
    ImageIcon[] images = new ImageIcon[this.NUM_FRAMES];
    int delay;
    Timer timer;
    boolean frozen = false;
    JLabel picture;
    static /* synthetic */ Class class$SliderDemo;

    public SliderDemo() {
        this.setLayout(new BoxLayout(this, 3));
        this.delay = 66;
        JLabel jLabel = new JLabel("Frames Per Second", 0);
        jLabel.setAlignmentX(0.5f);
        JSlider jSlider = new JSlider(0, 0, 30, 15);
        jSlider.addChangeListener(this);
        jSlider.setMajorTickSpacing(10);
        jSlider.setMinorTickSpacing(1);
        jSlider.setPaintTicks(true);
        jSlider.setPaintLabels(true);
        jSlider.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        this.picture = new JLabel();
        this.picture.setHorizontalAlignment(0);
        this.picture.setAlignmentX(0.5f);
        this.picture.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        this.updatePicture(0);
        this.add(jLabel);
        this.add(jSlider);
        this.add(this.picture);
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.timer = new Timer(this.delay, this);
        this.timer.setInitialDelay(this.delay * 7);
        this.timer.setCoalesce(true);
    }

    void addWindowListener(Window window) {
        window.addWindowListener(this);
    }

    public void windowIconified(WindowEvent windowEvent) {
        this.stopAnimation();
    }

    public void windowDeiconified(WindowEvent windowEvent) {
        this.startAnimation();
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void stateChanged(ChangeEvent changeEvent) {
        JSlider jSlider = (JSlider)changeEvent.getSource();
        if (!jSlider.getValueIsAdjusting()) {
            int n = jSlider.getValue();
            if (n == 0) {
                if (!this.frozen) {
                    this.stopAnimation();
                }
            } else {
                this.delay = 1000 / n;
                this.timer.setDelay(this.delay);
                this.timer.setInitialDelay(this.delay * 10);
                if (this.frozen) {
                    this.startAnimation();
                }
            }
        }
    }

    public void startAnimation() {
        this.timer.start();
        this.frozen = false;
    }

    public void stopAnimation() {
        this.timer.stop();
        this.frozen = true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.frameNumber = this.frameNumber == this.NUM_FRAMES - 1 ? 0 : ++this.frameNumber;
        this.updatePicture(this.frameNumber);
        if (this.frameNumber == this.NUM_FRAMES - 1 || this.frameNumber == this.NUM_FRAMES / 2 - 1) {
            this.timer.restart();
        }
    }

    protected void updatePicture(int n) {
        if (this.images[this.frameNumber] == null) {
            this.images[this.frameNumber] = SliderDemo.createImageIcon("images/doggy/T" + this.frameNumber + ".gif");
        }
        if (this.images[this.frameNumber] != null) {
            this.picture.setIcon(this.images[this.frameNumber]);
        } else {
            this.picture.setText("image #" + this.frameNumber + " not found");
        }
    }

    protected static ImageIcon createImageIcon(String string) {
        URL uRL = (class$SliderDemo == null ? (class$SliderDemo = SliderDemo.class$("SliderDemo")) : class$SliderDemo).getResource(string);
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        System.err.println("Couldn't find file: " + string);
        return null;
    }

    public static void main(String[] stringArray) {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame jFrame = new JFrame("SliderDemo");
        jFrame.setDefaultCloseOperation(3);
        SliderDemo sliderDemo = new SliderDemo();
        sliderDemo.setOpaque(true);
        jFrame.setContentPane(sliderDemo);
        jFrame.pack();
        jFrame.setVisible(true);
        sliderDemo.startAnimation();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

