/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;

public class MenuLayoutDemo {
    public JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.setLayout(new BoxLayout(jMenuBar, 1));
        jMenuBar.add(this.createMenu("Menu 1"));
        jMenuBar.add(this.createMenu("Menu 2"));
        jMenuBar.add(this.createMenu("Menu 3"));
        jMenuBar.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, Color.BLACK));
        return jMenuBar;
    }

    public JMenu createMenu(String string) {
        HorizontalMenu horizontalMenu = new HorizontalMenu(string);
        horizontalMenu.add("Menu item #1 in " + string);
        horizontalMenu.add("Menu item #2 in " + string);
        horizontalMenu.add("Menu item #3 in " + string);
        HorizontalMenu horizontalMenu2 = new HorizontalMenu("Submenu");
        horizontalMenu2.add("Submenu item #1");
        horizontalMenu2.add("Submenu item #2");
        horizontalMenu.add(horizontalMenu2);
        return horizontalMenu;
    }

    public static void main(String[] stringArray) {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame jFrame = new JFrame("MenuLayoutDemo");
        jFrame.setDefaultCloseOperation(3);
        MenuLayoutDemo menuLayoutDemo = new MenuLayoutDemo();
        Container container = jFrame.getContentPane();
        container.setBackground(Color.WHITE);
        container.add((Component)menuLayoutDemo.createMenuBar(), "Before");
        jFrame.setSize(300, 150);
        jFrame.setVisible(true);
    }

    class HorizontalMenu
    extends JMenu {
        HorizontalMenu(String string) {
            super(string);
            JPopupMenu jPopupMenu = this.getPopupMenu();
            jPopupMenu.setLayout(new BoxLayout(jPopupMenu, 0));
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public void setPopupMenuVisible(boolean bl) {
            boolean bl2 = this.isPopupMenuVisible();
            if (bl != bl2) {
                if (bl && this.isShowing()) {
                    int n = 0;
                    int n2 = 0;
                    Container container = this.getParent();
                    if (container instanceof JPopupMenu) {
                        n = 0;
                        n2 = this.getHeight();
                    } else {
                        n = this.getWidth();
                        n2 = 0;
                    }
                    this.getPopupMenu().show(this, n, n2);
                } else {
                    this.getPopupMenu().setVisible(false);
                }
            }
        }
    }
}

